/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.inject.Inject;
import io.confluent.controlcenter.rest.AbstractClusterLookupProxyServlet;
import io.confluent.controlcenter.servicehealthcheck.ServiceHealthCheck;
import io.confluent.controlcenter.servicehealthcheck.ServiceHealthCheckModule;
import java.util.List;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class KsqlProxyServlet
extends AbstractClusterLookupProxyServlet {
    private static final String WS_REDIRECT = "ws-redirect";
    private static final String WEBSOCKET_KEYWORD = "websocket";
    private final Random random = new Random();
    private final ServiceHealthCheck ksqlHealthCheck;

    @Inject
    public KsqlProxyServlet(@ServiceHealthCheckModule.KsqlHealthCheck ServiceHealthCheck ksqlHealthCheck) {
        this.ksqlHealthCheck = ksqlHealthCheck;
    }

    protected void onProxyRewriteFailed(HttpServletRequest clientRequest, HttpServletResponse clientResponse) {
        String location = (String)clientRequest.getAttribute(WS_REDIRECT);
        if (location == null) {
            clientResponse.setStatus(404);
        } else {
            clientResponse.setStatus(302);
            clientResponse.setHeader("Location", location);
        }
    }

    @Override
    protected String rewriteTarget(HttpServletRequest clientRequest) {
        String targetUri = this.extractProxyUri(clientRequest);
        if (targetUri == null) {
            return null;
        }
        if ("Upgrade".equals(clientRequest.getHeader("Connection")) && WEBSOCKET_KEYWORD.equals(clientRequest.getHeader("Upgrade"))) {
            clientRequest.setAttribute(WS_REDIRECT, (Object)targetUri);
            return null;
        }
        return targetUri;
    }

    @Override
    public String lookupEndpoint(String ksqlClusterName) {
        List<String> endpoints = this.ksqlHealthCheck.getHealthyUrls(ksqlClusterName);
        if (endpoints == null) {
            return null;
        }
        if (endpoints.isEmpty()) {
            throw new RuntimeException("all nodes in KSQL cluster '" + ksqlClusterName + "' are down");
        }
        return endpoints.get(this.random.nextInt(endpoints.size()));
    }
}

