/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.inject.Inject;
import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.data.ScopedPermissions;
import io.confluent.controlcenter.license.LicenseInfo;
import io.confluent.controlcenter.license.LicenseManagerNotEnabledException;
import io.confluent.controlcenter.rest.req.UpdateLicenseRequest;
import io.confluent.controlcenter.rest.res.UpdateLicenseResponse;
import io.confluent.license.InvalidLicenseException;
import javax.ws.rs.Consumes;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;

@Path(value="/3.0/license")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class LicenseResource {
    private final LicenseInfo licenseInfo;
    private final ControlCenterConfig controlCenterConfig;
    @Context
    private ScopedPermissions scopedPermissions;

    @Inject
    public LicenseResource(LicenseInfo licenseInfo, ControlCenterConfig controlCenterConfig) {
        this.licenseInfo = licenseInfo;
        this.controlCenterConfig = controlCenterConfig;
    }

    @GET
    public LicenseInfo licenseInfo() {
        if (!this.scopedPermissions.hasReadLicenseAccess()) {
            throw new ForbiddenException("user must have license read access");
        }
        return this.licenseInfo;
    }

    @GET
    @Path(value="/expiration")
    public long expiration() {
        return this.licenseInfo.getExpiration();
    }

    @GET
    @Path(value="/audience")
    public String audience() {
        return this.licenseInfo.getAudience();
    }

    @GET
    @Path(value="/payload")
    public String payload() {
        return this.licenseInfo.getPayload();
    }

    @GET
    @Path(value="/string")
    public String string() throws LicenseManagerNotEnabledException {
        if (!this.controlCenterConfig.getBoolean("confluent.controlcenter.license.manager.enable").booleanValue()) {
            throw new LicenseManagerNotEnabledException("License Manager is not enabled. ");
        }
        if (!this.scopedPermissions.hasWriteLicenseAccess()) {
            throw new ForbiddenException("user must have license write access");
        }
        return this.licenseInfo.getString();
    }

    @POST
    @Path(value="/string:update")
    public UpdateLicenseResponse updateLicense(UpdateLicenseRequest updateLicenseRequest) throws InvalidLicenseException, LicenseManagerNotEnabledException {
        if (!this.controlCenterConfig.getBoolean("confluent.controlcenter.license.manager.enable").booleanValue()) {
            throw new LicenseManagerNotEnabledException("License Manager is not enabled. You cannot update license through REST request directly. You can apply your new license by updating properties file and restarting control center.");
        }
        if (!this.scopedPermissions.hasWriteLicenseAccess()) {
            throw new ForbiddenException("user must have license write access");
        }
        boolean updateSucceed = this.licenseInfo.setLicenseString(updateLicenseRequest.getLicenseString());
        return new UpdateLicenseResponse(updateSucceed, new UpdateLicenseResponse.CurrentLicense().setInfo(this.licenseInfo).build(), "");
    }

    public LicenseInfo getLicenseInfo() {
        return this.licenseInfo;
    }
}

