/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.inject.Inject;
import io.confluent.controlcenter.rest.AbstractTargetProxyServlet;
import io.confluent.controlcenter.servicehealthcheck.ServiceHealthCheckModule;
import io.confluent.controlcenter.servicehealthcheck.SingleServiceHealthCheck;
import java.util.List;
import java.util.Random;

public class MetadataProxyServlet
extends AbstractTargetProxyServlet {
    private final Random random = new Random();
    private final SingleServiceHealthCheck mdsHealthCheck;

    @Inject
    public MetadataProxyServlet(@ServiceHealthCheckModule.MetadataServiceHealthCheck SingleServiceHealthCheck mdsHealthCheck) {
        this.mdsHealthCheck = mdsHealthCheck;
    }

    @Override
    protected String getEndpoint() {
        List<String> endpoints = this.mdsHealthCheck.getHealthyUrls();
        if (endpoints == null) {
            return null;
        }
        if (endpoints.isEmpty()) {
            throw new RuntimeException("all nodes in MetadataService cluster are down");
        }
        return endpoints.get(this.random.nextInt(endpoints.size()));
    }
}

