/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.common.base.Preconditions;
import java.net.URISyntaxException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import org.apache.http.client.utils.URIBuilder;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.http.HttpClientTransportOverHTTP;
import org.eclipse.jetty.proxy.AsyncProxyServlet;
import org.eclipse.jetty.util.ProcessorUtils;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProxyServlet
extends AsyncProxyServlet {
    private int requestBufferSize;
    private SslContextFactory sslContextFactory = new SslContextFactory();
    private static final Logger log = LoggerFactory.getLogger(ProxyServlet.class);

    protected abstract String extractProxyUri(HttpServletRequest var1);

    private static boolean isValidUrl(String url) {
        try {
            new URL(url).toURI();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected static String normalizeUrlProtocol(String url) {
        if (url == null) {
            return null;
        }
        if (ProxyServlet.isValidUrl(url)) {
            return url;
        }
        String withDefaultProtocol = "http://" + url;
        if (ProxyServlet.isValidUrl(withDefaultProtocol)) {
            return withDefaultProtocol;
        }
        log.error("Malformed url: '{}'", (Object)url);
        return url;
    }

    protected static String composeProxyUri(String endpointBase, String proxyPath, String queryString) {
        if (endpointBase == null || proxyPath == null || !proxyPath.startsWith("/")) {
            return null;
        }
        try {
            URIBuilder builder = new URIBuilder(endpointBase);
            String endpointPath = builder.build().getPath();
            if (endpointPath.endsWith("/")) {
                endpointPath = endpointPath.substring(0, endpointPath.length() - 1);
            }
            String composedPath = endpointPath.concat(proxyPath);
            return builder.setPath(composedPath).setQuery(queryString).build().toString();
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    @NotNull
    public void setSslContextFactory(SslContextFactory sslContextFactory) {
        this.sslContextFactory = (SslContextFactory)Preconditions.checkNotNull((Object)sslContextFactory);
    }

    public void setRequestBufferSize(int requestBufferSize) {
        this.requestBufferSize = requestBufferSize;
    }

    protected HttpClient newHttpClient() {
        int selectors = Math.max(1, ProcessorUtils.availableProcessors() / 2);
        String value = this.getServletConfig().getInitParameter("selectors");
        if (value != null) {
            selectors = Integer.parseInt(value);
        }
        HttpClient httpClient = new HttpClient((HttpClientTransport)new HttpClientTransportOverHTTP(selectors), this.sslContextFactory);
        if (this.requestBufferSize > 0) {
            httpClient.setRequestBufferSize(this.requestBufferSize);
        }
        return httpClient;
    }

    protected String rewriteTarget(HttpServletRequest clientRequest) {
        return this.extractProxyUri(clientRequest);
    }
}

