/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import io.confluent.controlcenter.rest.AbstractClusterLookupProxyServlet;
import io.confluent.controlcenter.rest.res.SchemaRegistryCluster;
import io.confluent.controlcenter.schemaregistry.SchemaRegistryClusterMetadata;
import io.confluent.controlcenter.servicehealthcheck.ServiceHealthCheck;
import io.confluent.controlcenter.servicehealthcheck.ServiceHealthCheckModule;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.http.HttpHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaRegistryProxyServlet
extends AbstractClusterLookupProxyServlet {
    private static final Logger log = LoggerFactory.getLogger(SchemaRegistryProxyServlet.class);
    private final Random random = new Random();
    private final Map<String, String> userInfoLookup = Maps.newHashMap();
    private final ServiceHealthCheck srHealthCheck;

    @Inject
    public SchemaRegistryProxyServlet(SchemaRegistryClusterMetadata srClusterMetadata, @ServiceHealthCheckModule.SchemaRegistryHealthCheck ServiceHealthCheck srHealthCheck) {
        this.srHealthCheck = srHealthCheck;
        for (SchemaRegistryCluster srCluster : srClusterMetadata.getSrClusters()) {
            this.userInfoLookup.put(srCluster.clusterId, srClusterMetadata.getUserInfo(srCluster.clusterId));
        }
    }

    protected void addProxyHeaders(HttpServletRequest clientRequest, Request proxyRequest) {
        super.addProxyHeaders(clientRequest, proxyRequest);
        String userInfo = this.userInfoLookup.get(this.getSRIdFromRequest(clientRequest));
        if (userInfo != null) {
            proxyRequest.header(HttpHeader.AUTHORIZATION, null);
            proxyRequest.header(HttpHeader.AUTHORIZATION, "Basic " + Base64.getEncoder().encodeToString(userInfo.getBytes(StandardCharsets.UTF_8)));
        }
    }

    private String getSRIdFromRequest(HttpServletRequest request) {
        List<String> uriList = Arrays.asList(request.getRequestURI().split("/"));
        int srIndex = uriList.indexOf("schema-registry");
        return uriList.size() > srIndex + 1 ? uriList.get(srIndex + 1) : null;
    }

    @Override
    public String lookupEndpoint(String clusterId) {
        List<String> endpoints = this.srHealthCheck.getHealthyUrls(clusterId);
        if (endpoints == null) {
            return null;
        }
        if (endpoints.isEmpty()) {
            throw new RuntimeException("all nodes in SchemaRegistry cluster '" + clusterId + "' are down");
        }
        return endpoints.get(this.random.nextInt(endpoints.size()));
    }
}

