/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.connect.ConnectClusterManager;
import io.confluent.controlcenter.data.ClusterMetadataDao;
import io.confluent.controlcenter.data.ScopedServiceVisibilityFilter;
import io.confluent.controlcenter.kafka.KafkaRestManager;
import io.confluent.controlcenter.ksql.KsqlClusterMetadata;
import io.confluent.controlcenter.rest.res.KsqlCluster;
import io.confluent.controlcenter.rest.res.ServiceHealth;
import io.confluent.controlcenter.schemaregistry.SchemaRegistryClusterMetadata;
import io.confluent.controlcenter.servicehealthcheck.ServiceHealthCheck;
import io.confluent.controlcenter.servicehealthcheck.ServiceHealthCheckModule;
import io.confluent.controlcenter.servicehealthcheck.SingleServiceHealthCheck;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;

@Path(value="/api/service-health")
@Produces(value={"application/json"})
public class ServiceHealthCheckResource {
    private final ControlCenterConfig controlCenterConfig;
    private final ClusterMetadataDao kafkaClusterMetadata;
    private final KsqlClusterMetadata ksqlClusterMetadata;
    private final SchemaRegistryClusterMetadata schemaRegistryClusterMetadata;
    private final ConnectClusterManager connectClusterManager;
    private final ServiceHealthCheck ksqlServiceHealth;
    private final ServiceHealthCheck connectServiceHealth;
    private final ServiceHealthCheck srServiceHealth;
    private final KafkaRestManager kafkaRestManager;
    @Context
    private ScopedServiceVisibilityFilter scopedServiceVisibilityFilter;

    @Inject
    public ServiceHealthCheckResource(ControlCenterConfig controlCenterConfig, ClusterMetadataDao kafkaClusterMetadata, KsqlClusterMetadata ksqlClusterMetadata, ConnectClusterManager connectClusterManager, SchemaRegistryClusterMetadata schemaRegistryClusterMetadata, @ServiceHealthCheckModule.KsqlHealthCheck ServiceHealthCheck ksqlServiceHealth, @ServiceHealthCheckModule.ConnectHealthCheck ServiceHealthCheck connectServiceHealth, @ServiceHealthCheckModule.SchemaRegistryHealthCheck ServiceHealthCheck srServiceHealth, KafkaRestManager kafkaRestManager) {
        this.controlCenterConfig = controlCenterConfig;
        this.kafkaClusterMetadata = kafkaClusterMetadata;
        this.ksqlClusterMetadata = ksqlClusterMetadata;
        this.connectClusterManager = connectClusterManager;
        this.schemaRegistryClusterMetadata = schemaRegistryClusterMetadata;
        this.ksqlServiceHealth = ksqlServiceHealth;
        this.connectServiceHealth = connectServiceHealth;
        this.srServiceHealth = srServiceHealth;
        this.kafkaRestManager = kafkaRestManager;
    }

    @GET
    @Path(value="/ksql")
    public Map<String, ServiceHealth> ksqlClustersHealth() {
        if (!this.controlCenterConfig.getBoolean("confluent.controlcenter.ksql.enable").booleanValue()) {
            return ImmutableMap.of();
        }
        List<String> clusterIds = this.scopedServiceVisibilityFilter.filterKsqlClusters(this.ksqlClusterMetadata.getKsqlClusters()).stream().map(KsqlCluster::getClusterId).collect(Collectors.toList());
        return ServiceHealthCheckResource.getHealthMap(clusterIds, this.ksqlServiceHealth);
    }

    @GET
    @Path(value="/connect")
    public Map<String, ServiceHealth> connectClustersHealth() {
        List<String> clusterIds = this.scopedServiceVisibilityFilter.filterConnectClusters(this.connectClusterManager.getConnectClusters()).stream().map(c -> c.clusterId).collect(Collectors.toList());
        return ServiceHealthCheckResource.getHealthMap(clusterIds, this.connectServiceHealth);
    }

    @GET
    @Path(value="/schema-registry")
    public Map<String, ServiceHealth> schemaRegistryClustersHealth() {
        if (!this.controlCenterConfig.getBoolean("confluent.controlcenter.schema.registry.enable").booleanValue()) {
            return ImmutableMap.of();
        }
        List<String> clusterIds = this.scopedServiceVisibilityFilter.filterSchemaRegistryClusters(this.schemaRegistryClusterMetadata.getSrClusters()).stream().map(c -> c.clusterId).collect(Collectors.toList());
        return ServiceHealthCheckResource.getHealthMap(clusterIds, this.srServiceHealth);
    }

    @GET
    @Path(value="/kafka-rest")
    public Map<String, ServiceHealth> kafkaRestClustersHealth() {
        List clusterIds = this.scopedServiceVisibilityFilter.filterKafkaClusters(this.kafkaClusterMetadata.getKafkaClusters()).stream().map(c -> c.clusterId).collect(Collectors.toList());
        return clusterIds.stream().filter(id -> this.kafkaRestManager.getHealthCheck((String)id) != null).collect(Collectors.toMap(id -> id, id -> {
            SingleServiceHealthCheck healthCheck = this.kafkaRestManager.getHealthCheck((String)id);
            return new ServiceHealth(healthCheck.getOriginalUrls(), healthCheck.getHealthyUrls());
        }));
    }

    private static Map<String, ServiceHealth> getHealthMap(List<String> clusterIds, ServiceHealthCheck healthCheck) {
        return clusterIds.stream().collect(Collectors.toMap(id -> id, id -> new ServiceHealth(healthCheck.getOriginalUrls((String)id), healthCheck.getHealthyUrls((String)id))));
    }
}

