/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest.res;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.Message;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaUtils;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.json.JsonSchemaUtils;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaUtils;
import io.confluent.kafka.serializers.KafkaAvroDeserializer;
import io.confluent.kafka.serializers.json.KafkaJsonSchemaDeserializer;
import io.confluent.kafka.serializers.protobuf.KafkaProtobufDeserializer;
import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import javax.net.ssl.SSLException;
import org.apache.avro.generic.GenericRecord;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OmgDeserializer {
    private static final Logger log = LoggerFactory.getLogger(OmgDeserializer.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final StringDeserializer STRING_DESERIALIZER = new StringDeserializer();
    private final KafkaAvroDeserializer avroDeserializer;
    private final KafkaJsonSchemaDeserializer<JsonNode> jsonSchemaDeserializer;
    private final KafkaProtobufDeserializer<Message> protobufDeserializer;
    private final FormatMemoizingDeserializer keyDeserializer = new FormatMemoizingDeserializer();
    private final FormatMemoizingDeserializer valueDeserializer = new FormatMemoizingDeserializer();

    public OmgDeserializer(SchemaRegistryClient schemaRegistryClient) {
        this.avroDeserializer = new KafkaAvroDeserializer(schemaRegistryClient);
        this.jsonSchemaDeserializer = new KafkaJsonSchemaDeserializer(schemaRegistryClient);
        this.protobufDeserializer = new KafkaProtobufDeserializer(schemaRegistryClient);
    }

    public Object deserializeKey(ConsumerRecord<byte[], byte[]> record) {
        return this.keyDeserializer.get(ConsumerRecord::key, record).apply(record);
    }

    public Object deserializeValue(ConsumerRecord<byte[], byte[]> record) {
        return this.valueDeserializer.get(ConsumerRecord::value, record).apply(record);
    }

    private Function<ConsumerRecord<byte[], byte[]>, Object> detect(Function<ConsumerRecord<byte[], byte[]>, byte[]> selector, ConsumerRecord<byte[], byte[]> record) {
        byte[] bytes = selector.apply(record);
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try {
            OmgDeserializer.fromAvro(this.avroDeserializer, selector, record);
            return r -> OmgDeserializer.fromAvro(this.avroDeserializer, selector, (ConsumerRecord<byte[], byte[]>)r);
        }
        catch (SerializationException e) {
            if (OmgDeserializer.isSubclassOf(e.getCause(), SSLException.class)) {
                log.error("unable to deserialize avro", (Throwable)e);
            } else {
                log.trace("unable to deserialize avro", (Throwable)e);
            }
        }
        catch (Exception e) {
            log.trace("unable to deserialize avro", (Throwable)e);
        }
        try {
            OmgDeserializer.fromJsonSchema(this.jsonSchemaDeserializer, selector, record);
            return r -> OmgDeserializer.fromJsonSchema(this.jsonSchemaDeserializer, selector, (ConsumerRecord<byte[], byte[]>)r);
        }
        catch (SerializationException e) {
            if (OmgDeserializer.isSubclassOf(e.getCause(), SSLException.class)) {
                log.error("unable to deserialize json schema", (Throwable)e);
            } else {
                log.trace("unable to deserialize json schema", (Throwable)e);
            }
        }
        catch (Exception e) {
            log.trace("unable to deserialize json schema", (Throwable)e);
        }
        try {
            OmgDeserializer.fromProtobuf(this.protobufDeserializer, selector, record);
            return r -> OmgDeserializer.fromProtobuf(this.protobufDeserializer, selector, (ConsumerRecord<byte[], byte[]>)r);
        }
        catch (SerializationException e) {
            if (OmgDeserializer.isSubclassOf(e.getCause(), SSLException.class)) {
                log.error("unable to deserialize protobuf", (Throwable)e);
            } else {
                log.trace("unable to deserialize protobuf", (Throwable)e);
            }
        }
        catch (Exception e) {
            log.trace("unable to deserialize protobuf", (Throwable)e);
        }
        try {
            OmgDeserializer.fromJson(bytes);
            return ((Function<byte[], Object>)OmgDeserializer::fromJson).compose(selector);
        }
        catch (Exception e) {
            log.trace("unable to deserialize json", (Throwable)e);
            try {
                OmgDeserializer.fromString(bytes);
                return ((Function<byte[], Object>)OmgDeserializer::fromString).compose(selector);
            }
            catch (Exception e2) {
                log.trace("unable to deserialize string", (Throwable)e2);
                return ((Function<byte[], Object>)OmgDeserializer::objectCast).compose(selector);
            }
        }
    }

    private static <T> Object objectCast(T value) {
        return value;
    }

    private static Object fromJson(byte[] bytes) {
        try {
            return OBJECT_MAPPER.readValue(bytes, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (IOException e) {
            throw new SerializationException((Throwable)e);
        }
    }

    private static String fromString(byte[] bytes) {
        return STRING_DESERIALIZER.deserialize(null, bytes);
    }

    private static Object fromAvro(KafkaAvroDeserializer avroDeserializer, Function<ConsumerRecord<byte[], byte[]>, byte[]> selector, ConsumerRecord<byte[], byte[]> record) {
        try {
            GenericRecord avroRecord = (GenericRecord)avroDeserializer.deserialize(record.topic(), selector.apply(record));
            byte[] bytes = AvroSchemaUtils.toJson((Object)avroRecord);
            return OmgDeserializer.fromJson(bytes);
        }
        catch (IOException e) {
            throw new SerializationException((Throwable)e);
        }
    }

    private static Object fromJsonSchema(KafkaJsonSchemaDeserializer<JsonNode> jsonSchemaDeserializer, Function<ConsumerRecord<byte[], byte[]>, byte[]> selector, ConsumerRecord<byte[], byte[]> record) {
        try {
            Object value = jsonSchemaDeserializer.deserialize(record.topic(), selector.apply(record));
            byte[] bytes = JsonSchemaUtils.toJson((Object)value);
            return OmgDeserializer.fromJson(bytes);
        }
        catch (IOException e) {
            throw new SerializationException((Throwable)e);
        }
    }

    private static Object fromProtobuf(KafkaProtobufDeserializer<Message> protobufDeserializer, Function<ConsumerRecord<byte[], byte[]>, byte[]> selector, ConsumerRecord<byte[], byte[]> record) {
        try {
            Message value = protobufDeserializer.deserialize(record.topic(), selector.apply(record));
            byte[] bytes = ProtobufSchemaUtils.toJson((Message)value);
            return OmgDeserializer.fromJson(bytes);
        }
        catch (IOException e) {
            throw new SerializationException((Throwable)e);
        }
    }

    public static boolean isSubclassOf(Throwable e, Class<?> targetClass) {
        if (e == null || targetClass == null) {
            return false;
        }
        return targetClass.isAssignableFrom(e.getClass());
    }

    private class FormatMemoizingDeserializer {
        Function<ConsumerRecord<byte[], byte[]>, Object> memoized;

        private FormatMemoizingDeserializer() {
        }

        public Function<ConsumerRecord<byte[], byte[]>, Object> get(Function<ConsumerRecord<byte[], byte[]>, byte[]> selector, ConsumerRecord<byte[], byte[]> record) {
            if (this.memoized == null) {
                this.memoized = OmgDeserializer.this.detect(selector, (ConsumerRecord<byte[], byte[]>)record);
            }
            return this.memoized != null ? this.memoized : ((Function<byte[], Object>)x$0 -> OmgDeserializer.objectCast(x$0)).compose(selector);
        }
    }
}

