/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest.res;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.confluent.controlcenter.rest.jackson.JsonStandard;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.common.replica.ReplicaStatus;

@JsonStandard
public final class PartitionReplicaStatus {
    private final int partition;
    private final ImmutableList<ReplicaStatus> replicas;

    @JsonCreator
    public PartitionReplicaStatus(@JsonProperty(value="partition") int partition, @JsonProperty(value="replicas") List<ReplicaStatus> replicas) {
        this.partition = partition;
        this.replicas = ImmutableList.copyOf(replicas);
    }

    public int getPartition() {
        return this.partition;
    }

    public ImmutableList<ReplicaStatus> getReplicas() {
        return this.replicas;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionReplicaStatus that = (PartitionReplicaStatus)o;
        return this.partition == that.partition && this.replicas.equals(that.replicas);
    }

    public int hashCode() {
        return Objects.hash(this.partition, this.replicas);
    }
}

