/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.schemaregistry;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.confluent.controlcenter.schemaregistry.SchemaRegistryClientSupplier;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class CachingSchemaRegistryClientSupplier<K>
implements SchemaRegistryClientSupplier<K> {
    private static final int DEFAULT_MAX_CACHE_SIZE = 100;
    private static final long DEFAULT_CACHE_EXPIRATION_MS = TimeUnit.MINUTES.toMillis(15L);
    private static final long CLEANUP_INTERVAL_MS = TimeUnit.MINUTES.toMillis(1L);
    private final LoadingCache<K, SchemaRegistryClient> cache;
    private final ScheduledExecutorService exec = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("sr-client-cache-cleanup").setDaemon(true).build());

    public CachingSchemaRegistryClientSupplier(SchemaRegistryClientSupplier<K> baseSupplier) {
        this((CacheBuilder<Object, Object>)CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(DEFAULT_CACHE_EXPIRATION_MS, TimeUnit.MILLISECONDS), baseSupplier);
    }

    public CachingSchemaRegistryClientSupplier(CacheBuilder<Object, Object> cacheBuilder, final SchemaRegistryClientSupplier<K> baseSupplier) {
        this.cache = cacheBuilder.removalListener(notification -> {}).build(new CacheLoader<K, SchemaRegistryClient>(){

            public SchemaRegistryClient load(K key) {
                return baseSupplier.getClient(key);
            }
        });
        this.exec.scheduleAtFixedRate(() -> this.cache.cleanUp(), CLEANUP_INTERVAL_MS, CLEANUP_INTERVAL_MS, TimeUnit.MILLISECONDS);
    }

    @Override
    public SchemaRegistryClient getClient(K key) {
        try {
            return (SchemaRegistryClient)this.cache.get(key);
        }
        catch (ExecutionException ee) {
            throw new RuntimeException(ee.getCause());
        }
    }

    public void invalidate(K key) {
        this.cache.invalidate(key);
    }
}

