/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.schemaregistry;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import io.confluent.controlcenter.ControlCenterRbacConfig;
import io.confluent.controlcenter.rest.CompoundClusterTokenCredential;
import io.confluent.controlcenter.rest.res.SchemaRegistryCluster;
import io.confluent.controlcenter.schemaregistry.SchemaRegistryClientSupplier;
import io.confluent.controlcenter.schemaregistry.SchemaRegistryClusterMetadata;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaProvider;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.json.JsonSchemaProvider;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaProvider;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import joptsimple.internal.Strings;

public class SchemaRegistryClientManager
implements SchemaRegistryClientSupplier<CompoundClusterTokenCredential> {
    private final SchemaRegistryClusterMetadata srClusterMetadata;
    private ControlCenterRbacConfig rbacConfig;
    private final Map<String, List<String>> srEndpointsLookup = Maps.newHashMap();
    private final Map<String, Map<String, Object>> srConfigsLookup = Maps.newHashMap();

    public SchemaRegistryClientManager(SchemaRegistryClusterMetadata srClusterMetadata, ControlCenterRbacConfig rbacConfig) {
        this.rbacConfig = rbacConfig;
        this.srClusterMetadata = srClusterMetadata;
        for (SchemaRegistryCluster srCluster : srClusterMetadata.getSrClusters()) {
            this.srEndpointsLookup.put(srCluster.clusterId, srCluster.servers);
            this.srConfigsLookup.put(srCluster.clusterId, srClusterMetadata.getConfigs(srCluster.displayName));
        }
    }

    @Override
    public SchemaRegistryClient getClient(CompoundClusterTokenCredential credential) {
        List<String> endpoints;
        String srClusterId = credential.secondaryClusterId;
        if (Strings.isNullOrEmpty((String)srClusterId)) {
            srClusterId = this.getDefaultSrClusterId();
        }
        if ((endpoints = this.srEndpointsLookup.get(srClusterId)) == null || endpoints.isEmpty()) {
            return null;
        }
        return new CachedSchemaRegistryClient(endpoints, 100, Arrays.asList(new AvroSchemaProvider(), new JsonSchemaProvider(), new ProtobufSchemaProvider()), this.rbacConfig.isRbacEnabled() ? this.injectRbacImpersonationConfigs(this.srConfigsLookup.get(srClusterId), credential.token) : this.srConfigsLookup.get(srClusterId));
    }

    private Map<String, Object> injectRbacImpersonationConfigs(Map<String, Object> configs, String token) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)token) ? 1 : 0) != 0);
        this.rbacConfig.putAllRbacTokenConfigs(configs, token);
        configs.put("bearer.auth.credentials.source", "MDS");
        return configs;
    }

    private String getDefaultSrClusterId() {
        return this.srClusterMetadata.getSrClusters().size() > 0 ? this.srClusterMetadata.getSrClusters().get((int)0).clusterId : null;
    }
}

