/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.schemaregistry;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.StaticClusterConfigSupplier;
import io.confluent.controlcenter.rest.ControlCenterRestModule;
import io.confluent.controlcenter.rest.res.SchemaRegistryCluster;
import io.confluent.controlcenter.util.ConfigUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SchemaRegistryClusterMetadata {
    private static final Logger log = LoggerFactory.getLogger(SchemaRegistryClusterMetadata.class);
    private static final String AUTH_SOURCE_SUFFIX = "basic.auth.credentials.source";
    private static final String USER_INFO_SUFFIX = "basic.auth.user.info";
    private static final String SCHEMA_REGISTRY_PREFIX = "schema.registry.";
    private static String defaultName = "Default Schema Registry";
    private final ArrayList<SchemaRegistryCluster> srClusters = new ArrayList();
    private final Map<String, String> authSourceByName = Maps.newHashMap();
    private final Map<String, String> userInfoByName = Maps.newHashMap();
    private final Map<String, Map<String, Object>> configsByName = Maps.newHashMap();

    @Inject
    public SchemaRegistryClusterMetadata(@ControlCenterRestModule.SchemaRegistryClusterConfigSupplier StaticClusterConfigSupplier srClusterConfigSupplier, ControlCenterConfig c3Config) {
        HashMap srConfigs = Maps.newHashMap();
        srConfigs.putAll(c3Config.originalsWithPrefix("confluent.controlcenter.schema.registry."));
        for (Map.Entry<String, Map<String, Object>> entry : srClusterConfigSupplier.getConfigurations().entrySet()) {
            List<String> configList = ConfigUtils.getList(entry.getValue(), "url");
            if (configList == null) continue;
            ArrayList<String> endpoints = new ArrayList<String>();
            for (String endpoint : configList) {
                endpoints.add(endpoint.replaceAll("\\s+", ""));
            }
            this.addConfigEntry(entry.getKey(), entry.getValue(), endpoints);
        }
        this.checkDefaultNameConflict();
        this.addConfigEntry(defaultName, srConfigs, c3Config.getList("confluent.controlcenter.schema.registry.url"));
    }

    public List<SchemaRegistryCluster> getSrClusters() {
        return this.srClusters;
    }

    public Map<String, Object> getConfigs(String name) {
        return this.configsByName.get(name);
    }

    public String getUserInfo(String srClusterId) {
        SchemaRegistryCluster cluster = this.srClusters.stream().filter(clus -> clus.clusterId.equals(srClusterId)).findFirst().orElse(null);
        if (cluster == null) {
            return null;
        }
        String authSource = this.authSourceByName.get(cluster.displayName);
        if (!Strings.isNullOrEmpty((String)authSource) && "USER_INFO".equals(authSource)) {
            return this.userInfoByName.get(cluster.displayName);
        }
        if (!Strings.isNullOrEmpty((String)authSource)) {
            log.error("{} is invalid, only USER_INFO is supported for Schema Registry {}", (Object)authSource, (Object)AUTH_SOURCE_SUFFIX);
        }
        return null;
    }

    private void checkDefaultNameConflict() {
        int index = 2;
        while (this.authSourceByName.containsKey(defaultName)) {
            String tag = String.format(" (%d)", index);
            defaultName = index > 2 ? defaultName.substring(0, defaultName.length() - tag.length()).concat(tag) : defaultName.concat(tag);
            ++index;
        }
    }

    private void addConfigEntry(String name, Map<String, Object> config, List<String> endpoints) {
        this.authSourceByName.put(name, (String)config.get(AUTH_SOURCE_SUFFIX));
        this.userInfoByName.put(name, (String)config.get(USER_INFO_SUFFIX));
        this.configsByName.put(name, config);
        this.addCluster(name, endpoints);
    }

    private void addCluster(String name, List<String> endpoints) {
        if (endpoints == null || endpoints.size() == 0) {
            log.error("Invalid url property for field '{}'", (Object)(name.equals(defaultName) ? "confluent.controlcenter.schema.registry.url" : String.format("%s%s.url", "confluent.controlcenter.schema.registry.", name)));
            return;
        }
        Collections.sort(endpoints);
        this.srClusters.add(defaultName.equals(name) ? 0 : this.srClusters.size(), new SchemaRegistryCluster(Hashing.sha1().hashString((CharSequence)ConfigUtils.toString(endpoints), Charsets.UTF_8).toString(), name, endpoints));
    }
}

