/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.servicehealthcheck;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.linecorp.armeria.client.ClientFactory;
import com.linecorp.armeria.client.ClientFactoryBuilder;
import com.linecorp.armeria.client.ClientOptions;
import com.linecorp.armeria.client.ClientOptionsBuilder;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.endpoint.healthcheck.HealthCheckedEndpointGroup;
import com.linecorp.armeria.common.SessionProtocol;
import io.confluent.controlcenter.httpclient.HttpCredential;
import io.confluent.controlcenter.servicehealthcheck.ServiceHealthCheck;
import io.confluent.controlcenter.util.UriUtils;
import io.confluent.rest.RestConfig;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.FileInputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyStore;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.eclipse.jetty.http.HttpHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArmeriaServiceHealthCheck
implements ServiceHealthCheck {
    private static final Logger log = LoggerFactory.getLogger(ServiceHealthCheck.class);
    private static final Duration CONNECT_TIMEOUT = Duration.ofSeconds(15L);
    private final Map<String, List<String>> originalUrls;
    private final Map<String, HealthCheckedEndpointGroup> healthCheckMap = new HashMap<String, HealthCheckedEndpointGroup>();
    private final Map<String, UrlsHttpsEnabled> healthyUrlsMap = new ConcurrentHashMap<String, UrlsHttpsEnabled>();
    private final Duration healthCheckInterval;
    private final String healthCheckPath;
    private final RestConfig restConfig;
    private final HttpCredential httpCredential;

    public ArmeriaServiceHealthCheck(Duration healthCheckInterval, Map<String, List<String>> clusterUrlMap, String healthCheckPath, RestConfig restConfig, HttpCredential httpCredential) {
        this.healthCheckInterval = healthCheckInterval;
        this.healthCheckPath = healthCheckPath;
        this.restConfig = restConfig;
        this.httpCredential = httpCredential;
        ImmutableMap.Builder origBuilder = ImmutableMap.builder();
        for (Map.Entry<String, List<String>> cluster : clusterUrlMap.entrySet()) {
            UrlsHttpsEnabled urls = new UrlsHttpsEnabled(ArmeriaServiceHealthCheck.normalizeUrls(cluster.getValue()));
            origBuilder.put((Object)cluster.getKey(), (Object)ImmutableList.copyOf(urls.getUrls()));
            HealthCheckedEndpointGroup healthCheck = this.createHealthCheck(urls.getUrls(), urls.isHttpsEnabled());
            healthCheck.addListener(endpoints -> this.updateHealthyNodes((String)cluster.getKey(), (List<Endpoint>)endpoints));
            this.healthCheckMap.put(cluster.getKey(), healthCheck);
            this.healthyUrlsMap.put(cluster.getKey(), urls);
        }
        this.originalUrls = origBuilder.build();
    }

    @Override
    public List<String> getHealthyUrls(String clusterId) {
        UrlsHttpsEnabled urls = this.healthyUrlsMap.get(clusterId);
        if (urls == null) {
            return null;
        }
        return urls.getUrls();
    }

    @Override
    public List<String> getOriginalUrls(String clusterId) {
        return this.originalUrls.get(clusterId);
    }

    @Override
    public void close() {
        for (HealthCheckedEndpointGroup healthCheck : this.healthCheckMap.values()) {
            healthCheck.close();
        }
    }

    private HealthCheckedEndpointGroup createHealthCheck(List<String> urls, boolean httpsEnabled) {
        List endpoints = urls.stream().map(url -> ArmeriaServiceHealthCheck.uriToEndpoint(ArmeriaServiceHealthCheck.stringToUri(url))).collect(Collectors.toList());
        ClientFactoryBuilder clientFactory = ClientFactory.builder().tlsCustomizer(ssl -> ArmeriaServiceHealthCheck.buildSslContext(ssl, this.restConfig)).connectTimeout(CONNECT_TIMEOUT);
        ClientOptionsBuilder options = ClientOptions.builder();
        if (this.httpCredential != null) {
            options.addHeader((CharSequence)HttpHeader.AUTHORIZATION.toString(), (Object)this.httpCredential.authorizationHeaderValue());
        }
        return HealthCheckedEndpointGroup.builder((EndpointGroup)EndpointGroup.of(endpoints), (String)this.healthCheckPath).clientFactory(clientFactory.build()).clientOptions(options.build()).protocol(httpsEnabled ? SessionProtocol.HTTPS : SessionProtocol.HTTP).retryInterval(this.healthCheckInterval).build();
    }

    private void updateHealthyNodes(String clusterId, List<Endpoint> endpoints) {
        this.healthyUrlsMap.compute(clusterId, (k, v) -> {
            Preconditions.checkNotNull((Object)v);
            return new UrlsHttpsEnabled(endpoints.stream().map(e -> ArmeriaServiceHealthCheck.endpointToString(e, v.isHttpsEnabled())).collect(Collectors.toList()), v.isHttpsEnabled());
        });
    }

    private static boolean httpsEnabled(List<String> urls) {
        for (String url : urls) {
            if (!url.toLowerCase().startsWith("https://")) continue;
            return true;
        }
        return false;
    }

    private static String endpointToString(Endpoint endpoint, boolean https) {
        return "http" + (https ? "s" : "") + "://" + endpoint.host() + ":" + endpoint.port();
    }

    private static Endpoint uriToEndpoint(URI uri) {
        return Endpoint.of((String)uri.getHost(), (int)(uri.getPort() > 0 ? uri.getPort() : 80));
    }

    private static URI stringToUri(String url) {
        try {
            return new URI(url);
        }
        catch (URISyntaxException e) {
            log.error("unable to parse url {}", (Object)url, (Object)e);
            throw new RuntimeException(e);
        }
    }

    private static List<String> normalizeUrls(List<String> urls) {
        return urls.stream().map(url -> {
            try {
                return UriUtils.uriWithDefaultScheme(url, "http").toString();
            }
            catch (URISyntaxException e) {
                log.error("unable to parse url {}", url, (Object)e);
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }

    private static void buildSslContext(SslContextBuilder sslContextBuilder, RestConfig restConfig) {
        List enabledProtocols = restConfig.getList("ssl.enabled.protocols");
        if (!enabledProtocols.isEmpty()) {
            sslContextBuilder.protocols((Iterable)enabledProtocols);
        }
        ClientAuth clientAuth = ClientAuth.NONE;
        String clientAuthString = restConfig.getString("ssl.client.authentication");
        if (clientAuthString.equals("REQUESTED")) {
            clientAuth = ClientAuth.OPTIONAL;
        } else if (clientAuthString.equals("REQUIRED")) {
            clientAuth = ClientAuth.REQUIRE;
        }
        sslContextBuilder.clientAuth(clientAuth);
        if (!restConfig.getList("ssl.cipher.suites").isEmpty()) {
            sslContextBuilder.ciphers((Iterable)restConfig.getList("ssl.cipher.suites"));
        }
        try {
            if (!restConfig.getString("ssl.keystore.location").isEmpty()) {
                KeyManagerFactory kmf = !restConfig.getString("ssl.keymanager.algorithm").isEmpty() ? KeyManagerFactory.getInstance(restConfig.getString("ssl.keymanager.algorithm")) : KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                KeyStore keyStore = KeyStore.getInstance(restConfig.getString("ssl.keystore.type"));
                keyStore.load(new FileInputStream(restConfig.getString("ssl.keystore.location")), restConfig.getPassword("ssl.keystore.password").value().isEmpty() ? null : restConfig.getPassword("ssl.keystore.password").value().toCharArray());
                kmf.init(keyStore, restConfig.getPassword("ssl.key.password").value().toCharArray());
                sslContextBuilder.keyManager(kmf);
            }
        }
        catch (Exception e) {
            log.error("Error initializing client keystore", (Throwable)e);
            throw new RuntimeException(e);
        }
        try {
            if (!restConfig.getString("ssl.truststore.location").isEmpty()) {
                TrustManagerFactory tmf = !restConfig.getString("ssl.trustmanager.algorithm").isEmpty() ? TrustManagerFactory.getInstance(restConfig.getString("ssl.trustmanager.algorithm")) : TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                KeyStore trustStore = KeyStore.getInstance(restConfig.getString("ssl.truststore.type"));
                trustStore.load(new FileInputStream(restConfig.getString("ssl.truststore.location")), restConfig.getPassword("ssl.truststore.password").value().isEmpty() ? null : restConfig.getPassword("ssl.truststore.password").value().toCharArray());
                tmf.init(trustStore);
                sslContextBuilder.trustManager(tmf);
            }
        }
        catch (Exception e) {
            log.error("Error initializing client truststore", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static class UrlsHttpsEnabled {
        private final List<String> urls;
        private final boolean httpsEnabled;

        UrlsHttpsEnabled(List<String> urls) {
            this(urls, ArmeriaServiceHealthCheck.httpsEnabled(urls));
        }

        UrlsHttpsEnabled(List<String> urls, boolean httpsEnabled) {
            this.urls = ImmutableList.copyOf(urls);
            this.httpsEnabled = httpsEnabled;
        }

        boolean isHttpsEnabled() {
            return this.httpsEnabled;
        }

        List<String> getUrls() {
            return this.urls;
        }
    }
}

