/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.servicehealthcheck;

import com.google.inject.AbstractModule;
import com.google.inject.BindingAnnotation;
import com.google.inject.Inject;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import io.confluent.controlcenter.ControlCenterConfigModule;
import io.confluent.controlcenter.ControlCenterRbacConfig;
import io.confluent.controlcenter.connect.ConnectClusterManager;
import io.confluent.controlcenter.httpclient.BasicHttpCredential;
import io.confluent.controlcenter.httpclient.HttpCredential;
import io.confluent.controlcenter.ksql.KsqlClusterMetadata;
import io.confluent.controlcenter.rest.res.KsqlCluster;
import io.confluent.controlcenter.schemaregistry.SchemaRegistryClusterMetadata;
import io.confluent.controlcenter.servicehealthcheck.ArmeriaServiceHealthCheck;
import io.confluent.controlcenter.servicehealthcheck.ArmeriaSingleServiceHealthCheck;
import io.confluent.controlcenter.servicehealthcheck.ServiceHealthCheck;
import io.confluent.controlcenter.servicehealthcheck.SingleServiceHealthCheck;
import io.confluent.rest.RestConfig;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.time.Duration;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class ServiceHealthCheckModule
extends AbstractModule {
    @Provides
    @Singleton
    @Nullable
    @Inject
    @ServiceHealthCheckCredential
    public HttpCredential getServiceHealthCheckCredential(ControlCenterRbacConfig rbacConfig) {
        if (rbacConfig.isRbacEnabled()) {
            return new BasicHttpCredential(rbacConfig.getControlCenterUsername(), rbacConfig.getControlCenterPassword());
        }
        return null;
    }

    @Provides
    @Singleton
    @Inject
    @KsqlHealthCheck
    public ServiceHealthCheck getKsqlServiceHealthCheck(@ControlCenterConfigModule.ServiceHealthCheckInterval Duration healthCheckInterval, KsqlClusterMetadata ksqlClusterMetadata, RestConfig restConfig, @Nullable @ServiceHealthCheckCredential HttpCredential credential) {
        return new ArmeriaServiceHealthCheck(healthCheckInterval, ksqlClusterMetadata.getKsqlClusters().stream().collect(Collectors.toMap(KsqlCluster::getClusterId, KsqlCluster::getEndpoints)), "/info", restConfig, credential);
    }

    @Provides
    @Singleton
    @Inject
    @ConnectHealthCheck
    public ServiceHealthCheck getConnectServiceHealthCheck(@ControlCenterConfigModule.ServiceHealthCheckInterval Duration healthCheckInterval, ConnectClusterManager connectClusterManager, RestConfig restConfig, @Nullable @ServiceHealthCheckCredential HttpCredential credential) {
        return new ArmeriaServiceHealthCheck(healthCheckInterval, connectClusterManager.getConnectClusters().stream().collect(Collectors.toMap(c -> c.clusterId, c -> c.urls)), "/connectors", restConfig, credential);
    }

    @Provides
    @Singleton
    @Inject
    @SchemaRegistryHealthCheck
    public ServiceHealthCheck getSchemaRegistryServiceHealthCheck(@ControlCenterConfigModule.ServiceHealthCheckInterval Duration healthCheckInterval, SchemaRegistryClusterMetadata schemaRegistryClusterMetadata, RestConfig restConfig, @Nullable @ServiceHealthCheckCredential HttpCredential credential) {
        return new ArmeriaServiceHealthCheck(healthCheckInterval, schemaRegistryClusterMetadata.getSrClusters().stream().collect(Collectors.toMap(c -> c.clusterId, c -> c.servers)), "/", restConfig, credential);
    }

    @Provides
    @Singleton
    @Inject
    @MetadataServiceHealthCheck
    public SingleServiceHealthCheck getMetadataServiceHealthCheck(@ControlCenterConfigModule.ServiceHealthCheckInterval Duration healthCheckInterval, ControlCenterRbacConfig controlCenterRbacConfig, RestConfig restConfig, @Nullable @ServiceHealthCheckCredential HttpCredential credential) {
        return new ArmeriaSingleServiceHealthCheck(healthCheckInterval, controlCenterRbacConfig.getMetadataServiceUrls(), "/security/1.0/metadataClusterId", restConfig, credential);
    }

    @Provides
    @Inject
    @KafkaRestServiceHealthCheck
    public Function<List<String>, SingleServiceHealthCheck> getSimpleHealthCheckSupplier(@ControlCenterConfigModule.ServiceHealthCheckInterval Duration healthCheckInterval, RestConfig restConfig, @Nullable @ServiceHealthCheckCredential HttpCredential credential) {
        return urls -> new ArmeriaSingleServiceHealthCheck(healthCheckInterval, (List<String>)urls, "/", restConfig, credential);
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface KafkaRestServiceHealthCheck {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface MetadataServiceHealthCheck {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface SchemaRegistryHealthCheck {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface ConnectHealthCheck {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface KsqlHealthCheck {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface ServiceHealthCheckCredential {
    }
}

