/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.streams;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.streams.processor.StateRestoreListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class C3LoggingRestoreListener
implements StateRestoreListener {
    private static final Logger LOG = LoggerFactory.getLogger(C3LoggingRestoreListener.class);
    private final ConcurrentHashMap<TopicPartition, Long> restoreTimeMap = new ConcurrentHashMap();

    public void onRestoreStart(TopicPartition topicPartition, String storeName, long startingOffset, long endingOffset) {
        LOG.info("Restore started for store [{}] with topic-partition [{}] of total records to restore [{}] ", new Object[]{storeName, topicPartition, endingOffset - startingOffset});
        Long previousTime = this.restoreTimeMap.put(topicPartition, System.currentTimeMillis());
        if (previousTime != null) {
            LOG.warn("Restore should not have an entry for store [{}] and topic-partition [{}] as restoring just started", (Object)storeName, (Object)topicPartition);
        }
    }

    public void onBatchRestored(TopicPartition topicPartition, String storeName, long batchEndOffset, long numRestored) {
        LOG.info("Restored batch for store [{}] with topic-partition [{}] with [{}] records restored", new Object[]{storeName, topicPartition, numRestored});
    }

    public void onRestoreEnd(TopicPartition topicPartition, String storeName, long totalRestored) {
        long now = System.currentTimeMillis();
        Long startTime = this.restoreTimeMap.remove(topicPartition);
        if (startTime == null) {
            LOG.warn("Couldn't find start time for store [{}] with topic-partition [{}]", (Object)storeName, (Object)topicPartition);
        } else {
            long restoreTimeInSeconds = (now - startTime) / 1000L;
            LOG.info("Restore completed for store [{}] and topic-partition [{}] taking [{}] seconds to restore [{}] records", new Object[]{storeName, topicPartition, restoreTimeInSeconds, totalRestored});
        }
    }
}

