/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.streams;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.confluent.controlcenter.ControlCenterConfigModule;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.streams.processor.DefaultPartitionGrouper;
import org.apache.kafka.streams.processor.PartitionGrouper;
import org.apache.kafka.streams.processor.TaskId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleGroupPartitionGrouper
implements PartitionGrouper {
    private static final Logger log = LoggerFactory.getLogger(SingleGroupPartitionGrouper.class);
    @Inject
    @ControlCenterConfigModule.SubTopologyInputTopics
    private static ImmutableSet<String> inputTopics;
    private PartitionGrouper defaultPartitionGrouper = new DefaultPartitionGrouper();

    public Map<TaskId, Set<TopicPartition>> partitionGroups(Map<Integer, Set<String>> topicGroups, Cluster metadata) {
        log.info("All topic groups: " + topicGroups);
        HashMap<Integer, Set<String>> includedTopicGroups = new HashMap<Integer, Set<String>>();
        for (Map.Entry<Integer, Set<String>> entry : topicGroups.entrySet()) {
            if (!entry.getValue().containsAll((Collection<?>)inputTopics)) continue;
            includedTopicGroups.put(entry.getKey(), entry.getValue());
        }
        if (includedTopicGroups.isEmpty()) {
            throw new KafkaException("No topic groups match the input set: " + inputTopics);
        }
        log.info("Included topic groups: " + includedTopicGroups);
        Map result = this.defaultPartitionGrouper.partitionGroups(includedTopicGroups, metadata);
        log.warn("Running a sub-topology for input topics: {} with map: {}", inputTopics, (Object)result);
        return result;
    }
}

