/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.streams.aggregation;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.HashBiMap;
import com.google.common.primitives.Ints;
import io.confluent.controlcenter.streams.aggregation.MetricEvent;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Objects;

public class BufferMetricEvent
implements MetricEvent {
    final ByteBuffer buffer;
    private String metricName;
    private Map<String, Integer> dimensionIndex;
    private final int size;
    private final int indexOffset;
    private final int valuesOffset;

    public static BufferMetricEvent wrap(ByteBuffer buffer) {
        int offset = buffer.position();
        return new BufferMetricEvent(buffer, offset);
    }

    static BufferMetricEvent fromIntAndValues(int i, String[] values) {
        return BufferMetricEvent.fromBytesAndValues(new byte[][]{Ints.toByteArray((int)i)}, values);
    }

    static BufferMetricEvent fromIntAndMap(int i, String[] fields, Map<String, String> values) {
        return BufferMetricEvent.fromBytesAndMap(new byte[][]{Ints.toByteArray((int)i)}, fields, values);
    }

    static BufferMetricEvent fromBytesAndMap(byte[][] byteValues, String[] stringFields, Map<String, String> values) {
        String[] stringValues = new String[stringFields.length];
        for (int i = 0; i < stringValues.length; ++i) {
            stringValues[i] = values.get(stringFields[i]);
        }
        return BufferMetricEvent.fromBytesAndValues(byteValues, stringValues);
    }

    static BufferMetricEvent fromBytesAndValues(byte[][] byteValues, String[] stringValues) {
        int size = byteValues.length + stringValues.length;
        int indexSize = size * 4;
        ByteBuffer index = ByteBuffer.allocate(indexSize);
        ByteArrayOutputStream out = new ByteArrayOutputStream(128);
        int offset = 0;
        for (byte[] bytes : byteValues) {
            out.write(bytes, 0, bytes.length);
            index.putInt(offset += bytes.length);
        }
        for (String value : stringValues) {
            byte[] bytes = BufferMetricEvent.toUtf8(Strings.nullToEmpty((String)value));
            out.write(bytes, 0, bytes.length);
            index.putInt(offset += bytes.length);
        }
        index.flip();
        byte[] byArray = out.toByteArray();
        ByteBuffer buffer = ByteBuffer.allocate(4 + index.remaining() + byArray.length);
        buffer.putInt(size);
        buffer.put(index);
        buffer.put(byArray);
        buffer.rewind();
        return new BufferMetricEvent(buffer.asReadOnlyBuffer(), 0);
    }

    private BufferMetricEvent(ByteBuffer buffer, int offset) {
        this(buffer, offset, null);
    }

    private BufferMetricEvent(ByteBuffer buffer, int offset, Map<String, Integer> dimensionIndex) {
        this.buffer = buffer;
        this.dimensionIndex = dimensionIndex;
        this.size = buffer.getInt(offset);
        this.indexOffset = offset + 4;
        this.valuesOffset = this.indexOffset + 4 * this.size;
    }

    BufferMetricEvent withDimensionIndex(Map<String, Integer> dimensionIndex) {
        this.dimensionIndex = dimensionIndex;
        return this;
    }

    BufferMetricEvent withMetricName(String metricName) {
        this.metricName = metricName;
        return this;
    }

    @Override
    public String getMetricName() {
        return this.metricName;
    }

    @Override
    public String getDimension(String dimensionName) {
        if (this.dimensionIndex == null) {
            return null;
        }
        Integer pos = this.dimensionIndex.get(dimensionName);
        if (pos != null) {
            return this.getString(pos);
        }
        return null;
    }

    public int getSize() {
        return this.size;
    }

    public String getString(int pos) {
        return BufferMetricEvent.fromUtf8(this.getBytes(pos));
    }

    byte[] getBytes(int pos) {
        ByteBuffer copyBuffer = this.getBuffer(pos);
        byte[] bytes = new byte[copyBuffer.remaining()];
        copyBuffer.get(bytes);
        return bytes;
    }

    private ByteBuffer getBuffer(int pos) {
        int endOffset;
        int startOffset;
        if (pos == 0) {
            startOffset = 0;
            endOffset = this.buffer.getInt(this.indexOffset);
        } else {
            int indexEnd = this.indexOffset + pos * 4;
            int indexStart = indexEnd - 4;
            startOffset = this.buffer.getInt(indexStart);
            endOffset = this.buffer.getInt(indexEnd);
        }
        ByteBuffer copyBuffer = this.buffer.asReadOnlyBuffer();
        copyBuffer.position(this.valuesOffset + startOffset).limit(this.valuesOffset + endOffset);
        return copyBuffer;
    }

    private int getEndOffset(int pos) {
        return this.buffer.getInt(this.indexOffset + pos * 4);
    }

    public String toString() {
        HashBiMap lookup = this.dimensionIndex != null ? HashBiMap.create(this.dimensionIndex) : HashBiMap.create();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.size; ++i) {
            if (i > 0) {
                builder.append(',');
            }
            builder.append(i);
            String dimension = (String)lookup.inverse().get((Object)i);
            if (dimension != null) {
                builder.append("(" + dimension + ")");
            }
            builder.append("=").append(this.getString(i));
        }
        return MoreObjects.toStringHelper((Object)this).add("metricName", (Object)this.metricName).add("size", this.size).add("fields", (Object)builder.toString()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BufferMetricEvent that = (BufferMetricEvent)o;
        return this.size == that.size && Objects.equals(this.metricName, that.metricName) && Objects.equals(this.dimensionIndex, that.dimensionIndex) && Objects.equals(this.buffer.asReadOnlyBuffer().position(this.indexOffset).limit(this.valuesOffset + this.getEndOffset(this.size - 1)), that.buffer.asReadOnlyBuffer().position(that.indexOffset).limit(that.valuesOffset + that.getEndOffset(that.size - 1)));
    }

    public int hashCode() {
        return Objects.hash(this.metricName, this.dimensionIndex, this.size) * 31 + this.buffer.asReadOnlyBuffer().position(this.indexOffset).limit(this.valuesOffset + this.getEndOffset(this.size - 1)).hashCode();
    }

    private static byte[] toUtf8(String s) {
        try {
            return s.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static String fromUtf8(byte[] bytes) {
        try {
            return new String(bytes, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

