/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.streams.aggregation;

import io.confluent.controlcenter.streams.aggregation.MetricHolder;
import java.nio.ByteBuffer;

public class MetricAggregator {
    public void aggregate(MetricHolder agg, long value) {
        this.aggregate(agg.buffer, value);
    }

    public void aggregate(ByteBuffer buffer, long value) {
        long count = MetricHolder.count(buffer);
        ++count;
        long sum = MetricHolder.sum(buffer);
        sum += value;
        long min = MetricHolder.min(buffer);
        min = Math.min(min, value);
        long max = MetricHolder.max(buffer);
        max = Math.max(max, value);
        buffer.putLong(MetricHolder.COUNT, count);
        buffer.putLong(MetricHolder.SUM, sum);
        buffer.putLong(MetricHolder.MIN, min);
        buffer.putLong(MetricHolder.MAX, max);
    }

    public void aggregate(MetricHolder agg, MetricHolder metric) {
        long count = agg.count() + metric.count();
        long sum = agg.sum() + metric.sum();
        long min = Math.min(agg.min(), metric.min());
        long max = Math.max(agg.max(), metric.max());
        ByteBuffer buffer = agg.buffer;
        buffer.putLong(MetricHolder.COUNT, count);
        buffer.putLong(MetricHolder.SUM, sum);
        buffer.putLong(MetricHolder.MIN, min);
        buffer.putLong(MetricHolder.MAX, max);
    }
}

