/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.streams.aggregation;

import com.google.common.primitives.Ints;
import io.confluent.controlcenter.streams.aggregation.BufferMetricEvent;
import io.confluent.controlcenter.streams.aggregation.BufferUtils;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;

public class MetricEventSerde {
    private static Serializer<BufferMetricEvent> SERIALIZER = new Serializer<BufferMetricEvent>(){

        public void configure(Map<String, ?> configs, boolean isKey) {
        }

        public byte[] serialize(String topic, BufferMetricEvent data) {
            return BufferUtils.toByteArray(data.buffer);
        }

        public void close() {
        }
    };

    public static Serde<BufferMetricEvent> forGroupingSets(final int idIndex, final Map<Integer, Map<String, Integer>> dimensionIndexes, final Map<Integer, String> metricNames) {
        return new Serde<BufferMetricEvent>(){
            final Deserializer<BufferMetricEvent> deserializer = new Deserializer<BufferMetricEvent>(){

                public void configure(Map<String, ?> configs, boolean isKey) {
                }

                public BufferMetricEvent deserialize(String topic, byte[] data) {
                    BufferMetricEvent event = BufferMetricEvent.wrap(ByteBuffer.wrap(data));
                    int id = Ints.fromByteArray((byte[])event.getBytes(idIndex));
                    Map dimensionIndex = (Map)dimensionIndexes.get(id);
                    return event.withDimensionIndex(dimensionIndex).withMetricName((String)metricNames.get(id));
                }

                public void close() {
                }
            };

            public void configure(Map<String, ?> configs, boolean isKey) {
            }

            public void close() {
            }

            public Serializer<BufferMetricEvent> serializer() {
                return SERIALIZER;
            }

            public Deserializer<BufferMetricEvent> deserializer() {
                return this.deserializer;
            }
        };
    }
}

