/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.streams.aggregation;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import io.confluent.controlcenter.streams.aggregation.BufferMetricEvent;
import io.confluent.controlcenter.streams.aggregation.GroupingSets;
import io.confluent.controlcenter.streams.aggregation.MetricAggregator;
import io.confluent.controlcenter.streams.aggregation.MetricEvent;
import io.confluent.controlcenter.streams.aggregation.MetricHolder;
import io.confluent.controlcenter.streams.aggregation.MetricValues;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Aggregator;
import org.apache.kafka.streams.kstream.Initializer;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.TimeWindows;
import org.apache.kafka.streams.kstream.Windows;
import org.apache.kafka.streams.kstream.internals.TimeWindow;
import org.apache.kafka.streams.state.ReadOnlyWindowStore;

public class MetricsAggregation {
    private static final String METRIC_FIELD = "metric";
    private static final Windows<TimeWindow> ROLLUP = TimeWindows.of((long)TimeUnit.MINUTES.toMillis(1L)).until(TimeUnit.DAYS.toMillis(7L));
    private static final int COPARTITION_BROKER_RANGE = 0;
    private static final int COPARTITION_CLUSTER_TOPIC = 0;
    public static final String CLUSTER_DIMENSION = "cluster";
    public static final String BROKER_DIMENSION = "broker";
    public static final String TOPIC_DIMENSION = "topic";
    public static final String PARTITION_DIMENSION = "partition";
    public static final String REQUEST_DIMENSION = "request";
    public static final String IS_LEADER_DIMENSION = "isLeader";
    public static final ImmutableList<String> CLUSTER = ImmutableList.of((Object)"cluster");
    public static final ImmutableList<String> CLUSTER_BROKER = ImmutableList.of((Object)"cluster", (Object)"broker");
    public static final ImmutableList<String> CLUSTER_TOPIC = ImmutableList.of((Object)"cluster", (Object)"topic");
    public static final ImmutableList<String> CLUSTER_TOPIC_LEADER = ImmutableList.of((Object)"cluster", (Object)"topic", (Object)"isLeader");
    public static final ImmutableList<String> CLUSTER_TOPIC_BROKER = ImmutableList.of((Object)"cluster", (Object)"topic", (Object)"broker");
    public static final ImmutableList<String> CLUSTER_BROKER_REQUEST = ImmutableList.of((Object)"cluster", (Object)"broker", (Object)"request");
    private final GroupingSets.PartitionedGroupingSets groupingSets;

    @Inject
    public MetricsAggregation() {
        GroupingSets.PartitionedGroupingSets groupingSets = GroupingSets.partitionedBy(METRIC_FIELD).addGroupingSet("ActiveControllerCount", (List<String>)CLUSTER, 0, (List<String>)CLUSTER).addGroupingSet("ActiveControllerCount", (List<String>)CLUSTER_BROKER).addGroupingSet("UncleanLeaderElectionsPerSec", (List<String>)CLUSTER).addGroupingSet("OfflinePartitionsCount", (List<String>)CLUSTER).addGroupingSet("LeaderElectionRateAndTimeMs", (List<String>)CLUSTER).addGroupingSet("ZooKeeperDisconnectsPerSec", (List<String>)CLUSTER).addGroupingSet("ZooKeeperExpiresPerSec", (List<String>)CLUSTER).addGroupingSet("LeaderCount", (List<String>)CLUSTER).addGroupingSet("PartitionCount", (List<String>)CLUSTER_BROKER).addGroupingSet("UnderReplicatedPartitions", (List<String>)CLUSTER, 0, (List<String>)CLUSTER).addGroupingSet("Size", (List<String>)CLUSTER_BROKER).addGroupingSet("Size", (List<String>)CLUSTER_TOPIC_LEADER).addGroupingSet("NumLogSegments", (List<String>)CLUSTER_TOPIC_LEADER).addGroupingSet("LogStartOffset", (List<String>)CLUSTER_TOPIC_LEADER).addGroupingSet("LogEndOffset", (List<String>)CLUSTER_TOPIC_LEADER).addGroupingSet("ReplicasCount", (List<String>)CLUSTER).addGroupingSet("ReplicasCount", (List<String>)CLUSTER_TOPIC, 0, (List<String>)CLUSTER_TOPIC).addGroupingSet("InSyncReplicasCount", (List<String>)CLUSTER).addGroupingSet("InSyncReplicasCount", (List<String>)CLUSTER_TOPIC, 0, (List<String>)CLUSTER_TOPIC).addGroupingSet("UnderReplicated", (List<String>)CLUSTER).addGroupingSet("UnderReplicated", (List<String>)CLUSTER_TOPIC, 0, (List<String>)CLUSTER_TOPIC).addGroupingSet("NetworkProcessorAvgIdlePercent", (List<String>)CLUSTER_BROKER).addGroupingSet("RequestHandlerAvgIdlePercent", (List<String>)CLUSTER).addGroupingSet("BytesInPerSec", (List<String>)CLUSTER_TOPIC_BROKER).addGroupingSet("BytesInPerSec", (List<String>)CLUSTER_TOPIC).addGroupingSet("BytesOutPerSec", (List<String>)CLUSTER_TOPIC_BROKER).addGroupingSet("BytesOutPerSec", (List<String>)CLUSTER_TOPIC).addGroupingSet("TotalProduceRequestsPerSec", (List<String>)CLUSTER_TOPIC_BROKER).addGroupingSet("TotalProduceRequestsPerSec", (List<String>)CLUSTER_TOPIC).addGroupingSet("TotalFetchRequestsPerSec", (List<String>)CLUSTER_TOPIC_BROKER).addGroupingSet("TotalFetchRequestsPerSec", (List<String>)CLUSTER_TOPIC).addGroupingSet("FailedProduceRequestsPerSec", (List<String>)CLUSTER_TOPIC_BROKER).addGroupingSet("FailedProduceRequestsPerSec", (List<String>)CLUSTER_TOPIC).addGroupingSet("FailedFetchRequestsPerSec", (List<String>)CLUSTER_TOPIC_BROKER).addGroupingSet("FailedFetchRequestsPerSec", (List<String>)CLUSTER_TOPIC).addGroupingSet("RequestQueueSize", (List<String>)CLUSTER);
        for (Percentile p : Percentile.values()) {
            groupingSets = groupingSets.addGroupingSet(MetricsAggregation.latencyMetric("TotalTimeMs", p), (List<String>)CLUSTER_BROKER_REQUEST).addGroupingSet(MetricsAggregation.latencyMetric("RequestQueueTimeMs", p), (List<String>)CLUSTER_BROKER_REQUEST).addGroupingSet(MetricsAggregation.latencyMetric("LocalTimeMs", p), (List<String>)CLUSTER_BROKER_REQUEST).addGroupingSet(MetricsAggregation.latencyMetric("RemoteTimeMs", p), (List<String>)CLUSTER_BROKER_REQUEST).addGroupingSet(MetricsAggregation.latencyMetric("ResponseQueueTimeMs", p), (List<String>)CLUSTER_BROKER_REQUEST).addGroupingSet(MetricsAggregation.latencyMetric("ResponseSendTimeMs", p), (List<String>)CLUSTER_BROKER_REQUEST);
        }
        groupingSets = groupingSets.addGroupingSet("timestamp", (List<String>)CLUSTER).addGroupingSet("brokerRange", (List<String>)CLUSTER, 0, (List<String>)CLUSTER).addGroupingSet("timestamp", (List<String>)CLUSTER_BROKER, 0, (List<String>)CLUSTER).addGroupingSet("brokerRange", (List<String>)CLUSTER_TOPIC, 0, (List<String>)CLUSTER_TOPIC).addGroupingSet("byTopicLeaderCount", (List<String>)CLUSTER_TOPIC, 0, (List<String>)CLUSTER_TOPIC).addGroupingSet("byTopicLeaderCount", (List<String>)CLUSTER_TOPIC_BROKER, 0, (List<String>)CLUSTER_TOPIC);
        groupingSets = groupingSets.addGroupingSet("LeaderCount", (List<String>)CLUSTER_BROKER).addGroupingSet("InSyncReplicasCount", (List<String>)CLUSTER_BROKER).addGroupingSet("ReplicasCount", (List<String>)CLUSTER_BROKER).addGroupingSet("UnderReplicated", (List<String>)CLUSTER_BROKER);
        groupingSets = groupingSets.addGroupingSet("RequestHandlerAvgIdlePercent", (List<String>)CLUSTER_BROKER);
        groupingSets = groupingSets.addGroupingSet("CaughtUpReplicasCount", (List<String>)CLUSTER).addGroupingSet("CaughtUpReplicasCount", (List<String>)CLUSTER_BROKER).addGroupingSet("CaughtUpReplicasCount", (List<String>)CLUSTER_TOPIC).addGroupingSet("ObserverReplicasCount", (List<String>)CLUSTER).addGroupingSet("ObserverReplicasCount", (List<String>)CLUSTER_BROKER).addGroupingSet("ObserverReplicasCount", (List<String>)CLUSTER_TOPIC);
        this.groupingSets = groupingSets = groupingSets.addGroupingSet("UnderMinIsrPartitionCount", (List<String>)CLUSTER_BROKER).addGroupingSet("UnderReplicatedPartitions", (List<String>)CLUSTER_BROKER);
    }

    public static String latencyMetric(String metric, Percentile percentile) {
        return metric + "-" + (Object)((Object)percentile);
    }

    public GroupingSets.PartitionedGroupingSets.GroupedWindowStore<MetricValues> metricsGroupStore(ReadOnlyWindowStore<BufferMetricEvent, MetricValues> metricsAggregateStore) {
        return this.groupingSets.groupStore(metricsAggregateStore);
    }

    public GroupingSets.PartitionedGroupingSets groupingSets() {
        return this.groupingSets;
    }

    public String metricField() {
        return METRIC_FIELD;
    }

    public static Windows<TimeWindow> rollup() {
        return ROLLUP;
    }

    public static long metricsWindowSizeInSeconds() {
        return MetricsAggregation.rollup().size() / 1000L;
    }

    public Initializer<MetricHolder> initializer() {
        return new Initializer<MetricHolder>(){

            public MetricHolder apply() {
                MetricHolder holder = MetricHolder.fromByteBuffer(MetricHolder.allocateBuffer());
                holder.reset();
                return holder;
            }
        };
    }

    public KeyValueMapper<Void, Iterable<KeyValue<Map<String, String>, Long>>, Iterable<KeyValue<BufferMetricEvent, MetricHolder>>> combiner() {
        return new KeyValueMapper<Void, Iterable<KeyValue<Map<String, String>, Long>>, Iterable<KeyValue<BufferMetricEvent, MetricHolder>>>(){
            final MetricAggregator metricAggregator = new MetricAggregator();

            public Iterable<KeyValue<BufferMetricEvent, MetricHolder>> apply(Void key, Iterable<KeyValue<Map<String, String>, Long>> value) {
                HashMap<BufferMetricEvent, MetricHolder> aggregates = new HashMap<BufferMetricEvent, MetricHolder>();
                String metricField = MetricsAggregation.this.metricField();
                GroupingSets.PartitionedGroupingSets groupingSets = MetricsAggregation.this.groupingSets();
                for (KeyValue<Map<String, String>, Long> kv : value) {
                    Map dimensions = (Map)kv.key;
                    Iterable<BufferMetricEvent> bufList = groupingSets.createMetricEventForGroupingSets((String)dimensions.get(metricField), (Map)kv.key);
                    for (BufferMetricEvent event : bufList) {
                        MetricHolder agg = (MetricHolder)aggregates.get(event);
                        if (agg == null) {
                            aggregates.put(event, MetricHolder.fromValue((Long)kv.value));
                            continue;
                        }
                        this.metricAggregator.aggregate(agg, (long)((Long)kv.value));
                    }
                }
                return Iterables.transform(aggregates.entrySet(), (Function)new Function<Map.Entry<BufferMetricEvent, MetricHolder>, KeyValue<BufferMetricEvent, MetricHolder>>(){

                    public KeyValue<BufferMetricEvent, MetricHolder> apply(Map.Entry<BufferMetricEvent, MetricHolder> input) {
                        return KeyValue.pair((Object)input.getKey(), (Object)input.getValue());
                    }
                });
            }
        };
    }

    public Aggregator<MetricEvent, MetricHolder, MetricHolder> aggregator() {
        return new Aggregator<MetricEvent, MetricHolder, MetricHolder>(){
            final MetricAggregator metricAggregator = new MetricAggregator();

            public MetricHolder apply(MetricEvent aggKey, MetricHolder value, MetricHolder holder) {
                this.metricAggregator.aggregate(holder, value);
                return holder;
            }
        };
    }

    public static enum Percentile {
        P_50(0.5, 50),
        P_95(0.95, 95),
        P_99(0.99, 99),
        P_999(0.999, 999);

        private final double percentile;
        private int displayValue;
        private static final Map<Integer, Percentile> values;

        public static Percentile fromDisplayValue(int displayValue) {
            if (values.containsKey(displayValue)) {
                return values.get(displayValue);
            }
            throw new IllegalArgumentException("Invalid percentile value" + displayValue);
        }

        private Percentile(double percentile, int displayValue) {
            this.percentile = percentile;
            this.displayValue = displayValue;
        }

        public String toString() {
            return "p" + this.displayValue;
        }

        public double getPercentile() {
            return this.percentile;
        }

        public int getDisplayValue() {
            return this.displayValue;
        }

        static {
            values = Maps.newHashMap();
            for (Percentile p : Percentile.values()) {
                values.put(p.displayValue, p);
            }
        }
    }
}

