/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.streams.alert;

import io.confluent.command.record.alert.CommandAlert;
import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.record.Controlcenter;
import io.confluent.controlcenter.streams.aggregation.MetricEvent;
import io.confluent.controlcenter.streams.aggregation.MetricValues;
import io.confluent.controlcenter.streams.aggregation.MetricsAggregation;
import io.confluent.controlcenter.streams.alert.MonitoringTriggerTransformerSupplier;
import io.confluent.monitoring.common.Clock;
import java.util.ArrayList;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Transformer;
import org.apache.kafka.streams.kstream.TransformerSupplier;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricToTriggerMeasurementTransformerSupplier
implements TransformerSupplier<Windowed<MetricEvent>, MetricValues, KeyValue<Controlcenter.WindowedClusterGroup, Iterable<KeyValue<Controlcenter.WindowedClusterGroup, Controlcenter.TriggerMeasurement>>>> {
    private static final Logger log = LoggerFactory.getLogger(MonitoringTriggerTransformerSupplier.class);
    private final Clock clock;
    private final ControlCenterConfig controlCenterConfig;

    public MetricToTriggerMeasurementTransformerSupplier(Clock clock, ControlCenterConfig controlCenterConfig) {
        this.clock = clock;
        this.controlCenterConfig = controlCenterConfig;
    }

    public Transformer<Windowed<MetricEvent>, MetricValues, KeyValue<Controlcenter.WindowedClusterGroup, Iterable<KeyValue<Controlcenter.WindowedClusterGroup, Controlcenter.TriggerMeasurement>>>> get() {
        return new MetricToTriggerMeasurementTransformer();
    }

    private class MetricToTriggerMeasurementTransformer
    implements Transformer<Windowed<MetricEvent>, MetricValues, KeyValue<Controlcenter.WindowedClusterGroup, Iterable<KeyValue<Controlcenter.WindowedClusterGroup, Controlcenter.TriggerMeasurement>>>> {
        private MetricToTriggerMeasurementTransformer() {
        }

        public void init(ProcessorContext context) {
        }

        public KeyValue<Controlcenter.WindowedClusterGroup, Iterable<KeyValue<Controlcenter.WindowedClusterGroup, Controlcenter.TriggerMeasurement>>> transform(Windowed<MetricEvent> key, MetricValues metricValues) {
            Controlcenter.MetricMeasurement measurement = this.getMeasurement(key, metricValues);
            if (measurement == null) {
                log.trace("Ignoring metric (for alerting): {}", key.key());
                return null;
            }
            log.trace("Metric: Key: {}, Value {}", key.key(), (Object)metricValues);
            try {
                Controlcenter.TriggerMeasurement.Builder triggerMeasurementBuilder = Controlcenter.TriggerMeasurement.newBuilder().setClusterId(((MetricEvent)key.key()).getDimension("cluster")).setWindow(-1L).setMetricMeasurement(measurement).setHeartbeat(false).setArrivalTime(MetricToTriggerMeasurementTransformerSupplier.this.clock.currentTimeMillis());
                this.setComponent(key, measurement, triggerMeasurementBuilder);
                ArrayList<KeyValue> ret = new ArrayList<KeyValue>();
                Controlcenter.WindowedClusterGroup retKey = Controlcenter.WindowedClusterGroup.newBuilder().setClusterId(((MetricEvent)key.key()).getDimension("cluster")).setMetricName(((MetricEvent)key.key()).getMetricName()).setComponent(triggerMeasurementBuilder.getComponent()).setWindow(key.window().start()).build();
                ret.add(KeyValue.pair((Object)retKey, (Object)triggerMeasurementBuilder.build()));
                return KeyValue.pair((Object)retKey, ret);
            }
            catch (IllegalArgumentException iae) {
                log.error("Failed to create trigger measurement", (Throwable)iae);
                return null;
            }
        }

        public void close() {
        }

        private Controlcenter.MetricMeasurement getMeasurement(Windowed<? extends MetricEvent> key, MetricValues metricValues) {
            String metricName;
            MetricEvent metricEvent = (MetricEvent)key.key();
            switch (metricName = metricEvent.getMetricName()) {
                case "OfflinePartitionsCount": {
                    return this.createBrokerMeasurement(CommandAlert.BrokerTriggerMetricType.OFFLINE_TOPIC_PARTITIONS, metricValues.max());
                }
                case "UncleanLeaderElectionsPerSec": {
                    return this.createBrokerMeasurement(CommandAlert.BrokerTriggerMetricType.UNCLEAN_ELECTION_COUNT, metricValues.sum());
                }
                case "UnderReplicatedPartitions": {
                    return this.createBrokerMeasurement(CommandAlert.BrokerTriggerMetricType.UNDER_REPLICATED_TOPIC_PARTITIONS, metricValues.sum());
                }
                case "ActiveControllerCount": {
                    return MetricToTriggerMeasurementTransformerSupplier.this.controlCenterConfig.getBoolean("confluent.controlcenter.trigger.active-controller-count.enable") != false ? this.createBrokerMeasurement(CommandAlert.BrokerTriggerMetricType.ACTIVE_CONTROLLER_COUNT, metricValues.sum()) : null;
                }
                case "ZooKeeperDisconnectsPerSec": {
                    return this.createBrokerMeasurement(CommandAlert.BrokerTriggerMetricType.ZK_STATUS, metricValues.sum() == 0L ? CommandAlert.StatusValue.ONLINE : CommandAlert.StatusValue.OFFLINE);
                }
                case "ZooKeeperExpiresPerSec": {
                    return this.createBrokerMeasurement(CommandAlert.BrokerTriggerMetricType.ZK_EXPIRATION_RATE, metricValues.sum() / MetricsAggregation.metricsWindowSizeInSeconds());
                }
                case "LeaderElectionRateAndTimeMs": {
                    return this.createBrokerMeasurement(CommandAlert.BrokerTriggerMetricType.LEADER_ELECTION_RATE, metricValues.sum());
                }
                case "UnderReplicated": {
                    if (metricEvent.getDimension("topic") == null) break;
                    return this.createTopicMeasurement(CommandAlert.TopicTriggerMetricType.TOPIC_UNDER_REPLICATED_TOPIC_PARTITIONS, metricValues.sum());
                }
                case "OutOfSyncReplicasCount": {
                    if (metricEvent.getDimension("topic") == null) break;
                    return this.createTopicMeasurement(CommandAlert.TopicTriggerMetricType.TOPIC_OUT_OF_SYNC_REPLICA_COUNT, metricValues.sum());
                }
                case "BytesInPerSec": {
                    if (this.isBrokerNotTopic(metricEvent)) {
                        return this.createBrokerMeasurement(CommandAlert.BrokerTriggerMetricType.BROKER_BYTES_IN, metricValues.sum() / MetricsAggregation.metricsWindowSizeInSeconds());
                    }
                    if (!this.isTopicNotBroker(metricEvent)) break;
                    return this.createTopicMeasurement(CommandAlert.TopicTriggerMetricType.TOPIC_BYTES_IN, metricValues.sum() / MetricsAggregation.metricsWindowSizeInSeconds());
                }
                case "BytesOutPerSec": {
                    if (this.isBrokerNotTopic(metricEvent)) {
                        return this.createBrokerMeasurement(CommandAlert.BrokerTriggerMetricType.BROKER_BYTES_OUT, metricValues.sum() / MetricsAggregation.metricsWindowSizeInSeconds());
                    }
                    if (!this.isTopicNotBroker(metricEvent)) break;
                    return this.createTopicMeasurement(CommandAlert.TopicTriggerMetricType.TOPIC_BYTES_OUT, metricValues.sum() / MetricsAggregation.metricsWindowSizeInSeconds());
                }
                case "TotalProduceRequestsPerSec": {
                    if (this.isBrokerNotTopic(metricEvent)) {
                        return this.createBrokerMeasurement(CommandAlert.BrokerTriggerMetricType.BROKER_PRODUCTION_REQ_COUNT, metricValues.sum() / MetricsAggregation.metricsWindowSizeInSeconds());
                    }
                    if (!this.isTopicNotBroker(metricEvent)) break;
                    return this.createTopicMeasurement(CommandAlert.TopicTriggerMetricType.TOPIC_PRODUCTION_REQ_COUNT, metricValues.sum() / MetricsAggregation.metricsWindowSizeInSeconds());
                }
                default: {
                    for (MetricsAggregation.Percentile p : MetricsAggregation.Percentile.values()) {
                        CommandAlert.BrokerTriggerMetricType metricType;
                        if (!metricName.equals(MetricsAggregation.latencyMetric("TotalTimeMs", p)) || (metricType = this.latencyBrokerMetricType(metricEvent.getDimension("request"), p)) == null) continue;
                        return this.createBrokerMeasurement(metricType, metricValues.max());
                    }
                }
            }
            return null;
        }

        private boolean isTopicNotBroker(MetricEvent metricEvent) {
            return metricEvent.getDimension("topic") != null && metricEvent.getDimension("broker") == null;
        }

        private boolean isBrokerNotTopic(MetricEvent metricEvent) {
            return metricEvent.getDimension("broker") != null && "".equals(metricEvent.getDimension("topic"));
        }

        private void setComponent(Windowed<? extends MetricEvent> key, Controlcenter.MetricMeasurement metricMeasurement, Controlcenter.TriggerMeasurement.Builder triggerMeasurementBuilder) {
            MetricEvent metricEvent = (MetricEvent)key.key();
            block0 : switch (metricMeasurement.getMetricTypeCase()) {
                case TOPICMETRIC: {
                    triggerMeasurementBuilder.setComponentType(Controlcenter.ComponentType.TOPIC);
                    triggerMeasurementBuilder.setComponent(metricEvent.getDimension("topic"));
                    break;
                }
                case BROKERMETRIC: {
                    switch (metricMeasurement.getBrokerMetric()) {
                        case BROKER_BYTES_IN: 
                        case BROKER_BYTES_OUT: 
                        case BROKER_PRODUCTION_REQ_LATENCY_999: 
                        case BROKER_PRODUCTION_REQ_LATENCY_990: 
                        case BROKER_PRODUCTION_REQ_LATENCY_950: 
                        case BROKER_PRODUCTION_REQ_LATENCY_MEDIAN: 
                        case BROKER_PRODUCTION_REQ_COUNT: 
                        case BROKER_FETCH_REQ_LATENCY_999: 
                        case BROKER_FETCH_REQ_LATENCY_990: 
                        case BROKER_FETCH_REQ_LATENCY_950: 
                        case BROKER_FETCH_REQ_LATENCY_MEDIAN: {
                            triggerMeasurementBuilder.setComponentType(Controlcenter.ComponentType.BROKER);
                            triggerMeasurementBuilder.setComponent(metricEvent.getDimension("broker"));
                            break block0;
                        }
                        case ZK_STATUS: 
                        case ZK_EXPIRATION_RATE: 
                        case ACTIVE_CONTROLLER_COUNT: 
                        case LEADER_ELECTION_RATE: 
                        case UNCLEAN_ELECTION_COUNT: 
                        case OFFLINE_TOPIC_PARTITIONS: 
                        case UNDER_REPLICATED_TOPIC_PARTITIONS: {
                            triggerMeasurementBuilder.setComponentType(Controlcenter.ComponentType.BROKER_CLUSTER);
                            break block0;
                        }
                    }
                    throw new IllegalArgumentException("Unsupported broker metric in metric measurement " + metricMeasurement);
                }
                default: {
                    throw new IllegalArgumentException("Metric type not set in metric measurement " + metricMeasurement);
                }
            }
        }

        private CommandAlert.BrokerTriggerMetricType latencyBrokerMetricType(String requestDimension, MetricsAggregation.Percentile percentile) {
            if (requestDimension.equals("Produce")) {
                switch (percentile) {
                    case P_50: {
                        return CommandAlert.BrokerTriggerMetricType.BROKER_PRODUCTION_REQ_LATENCY_MEDIAN;
                    }
                    case P_95: {
                        return CommandAlert.BrokerTriggerMetricType.BROKER_PRODUCTION_REQ_LATENCY_950;
                    }
                    case P_99: {
                        return CommandAlert.BrokerTriggerMetricType.BROKER_PRODUCTION_REQ_LATENCY_990;
                    }
                    case P_999: {
                        return CommandAlert.BrokerTriggerMetricType.BROKER_PRODUCTION_REQ_LATENCY_999;
                    }
                }
                log.warn("unknown percentile={}", (Object)percentile);
            } else if (requestDimension.equals("Fetch")) {
                switch (percentile) {
                    case P_50: {
                        return CommandAlert.BrokerTriggerMetricType.BROKER_FETCH_REQ_LATENCY_MEDIAN;
                    }
                    case P_95: {
                        return CommandAlert.BrokerTriggerMetricType.BROKER_FETCH_REQ_LATENCY_950;
                    }
                    case P_99: {
                        return CommandAlert.BrokerTriggerMetricType.BROKER_FETCH_REQ_LATENCY_990;
                    }
                    case P_999: {
                        return CommandAlert.BrokerTriggerMetricType.BROKER_FETCH_REQ_LATENCY_999;
                    }
                }
                log.warn("unknown percentile={}", (Object)percentile);
            }
            return null;
        }

        private Controlcenter.MetricMeasurement createBrokerMeasurement(CommandAlert.BrokerTriggerMetricType type, long value) {
            return Controlcenter.MetricMeasurement.newBuilder().setBrokerMetric(type).setLongValue(value).build();
        }

        private Controlcenter.MetricMeasurement createBrokerMeasurement(CommandAlert.BrokerTriggerMetricType type, CommandAlert.StatusValue value) {
            return Controlcenter.MetricMeasurement.newBuilder().setBrokerMetric(type).setStatusValue(value).build();
        }

        private Controlcenter.MetricMeasurement createTopicMeasurement(CommandAlert.TopicTriggerMetricType type, long value) {
            return Controlcenter.MetricMeasurement.newBuilder().setTopicMetric(type).setLongValue(value).build();
        }
    }
}

