/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.streams.group;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import io.confluent.controlcenter.record.Controlcenter;
import io.confluent.controlcenter.streams.group.GroupStreamExtension;
import io.confluent.controlcenter.util.LruSet;
import java.util.Objects;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicateWindowedGroupingPredicate
implements Predicate<Bytes, Controlcenter.WindowedGrouping> {
    private static final Logger log = LoggerFactory.getLogger(GroupStreamExtension.class);
    private static final HashFunction HASH_FUNCTION = Hashing.goodFastHash((int)512);
    private final LoadingCache<Key, LruSet<Controlcenter.MemberInfo>> lru;

    DuplicateWindowedGroupingPredicate() {
        this(256, 1024);
    }

    DuplicateWindowedGroupingPredicate(int cacheSize, final int cacheElementSize) {
        this.lru = CacheBuilder.newBuilder().maximumSize((long)cacheSize).build((CacheLoader)new CacheLoader<Key, LruSet<Controlcenter.MemberInfo>>(){

            public LruSet<Controlcenter.MemberInfo> load(Key key) throws Exception {
                return new LruSet<Controlcenter.MemberInfo>(cacheElementSize);
            }
        });
    }

    public boolean test(Bytes bytes, Controlcenter.WindowedGrouping windowedGrouping) {
        LruSet memberInfos = (LruSet)this.lru.getUnchecked((Object)new Key(bytes, windowedGrouping.getWindow()));
        boolean contains = true;
        for (Controlcenter.MemberInfo mi : windowedGrouping.getMembersList()) {
            contains = contains && memberInfos.contains(mi);
            memberInfos.add(mi);
        }
        return contains;
    }

    private static final class Key {
        final Bytes bytes;
        final Long window;

        public Key(Bytes bytes, Long window) {
            this.bytes = bytes;
            this.window = window;
        }

        public int hashCode() {
            return HASH_FUNCTION.newHasher().putBytes(this.bytes.get()).putLong(this.window.longValue()).hash().hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return Objects.equals(this.bytes, key.bytes) && Objects.equals(this.window, key.window);
        }
    }
}

