/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.streams.internals;

import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.TimestampedWindowStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.internals.ReadOnlyWindowStoreFacade;

public class WindowStoreFacade<K, V>
extends ReadOnlyWindowStoreFacade<K, V>
implements WindowStore<K, V> {
    public WindowStoreFacade(TimestampedWindowStore<K, V> store) {
        super(store);
    }

    public void init(ProcessorContext context, StateStore root) {
        this.inner.init(context, root);
    }

    public void put(K key, V value) {
        this.inner.put(key, (Object)ValueAndTimestamp.make(value, (long)-1L));
    }

    public void put(K key, V value, long windowStartTimestamp) {
        this.inner.put(key, (Object)ValueAndTimestamp.make(value, (long)-1L), windowStartTimestamp);
    }

    public void flush() {
        this.inner.flush();
    }

    public void close() {
        this.inner.close();
    }

    public String name() {
        return this.inner.name();
    }

    public boolean persistent() {
        return this.inner.persistent();
    }

    public boolean isOpen() {
        return this.inner.isOpen();
    }
}

