/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.streams.verify;

import com.google.common.base.MoreObjects;
import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import io.confluent.controlcenter.errors.AlreadyShutdownException;
import io.confluent.controlcenter.errors.DuplicateSequenceNumberException;
import io.confluent.controlcenter.errors.SequenceAfterShutdownException;
import io.confluent.controlcenter.errors.ShutdownSequenceNotHighestException;
import io.confluent.controlcenter.record.Controlcenter;
import io.confluent.controlcenter.streams.verify.SequenceWithMetadata;
import io.confluent.monitoring.common.MonitoringMessageUtil;
import io.confluent.monitoring.common.TimeBucket;
import io.confluent.monitoring.record.Monitoring;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitoringVerifier {
    private static final long DEFAULT_NORMALIZED_WINDOW_DISTANCE = 10L;
    private static final long MIN_NORMALIZED_WINDOW_DISTANCE = 1L;
    private static final long MAX_CONSECUTIVE_REPORTED_MISSING_SEQUENCES = 20L;
    private static final Logger log = LoggerFactory.getLogger(MonitoringVerifier.class);
    private final Monitoring.MonitoringMessage.Builder baseMonitoringMessageBuilder;
    private final long timeout;
    private final long windowHistorySize;
    private RangeSet<SequenceWithMetadata> ranges = TreeRangeSet.create();
    private boolean shutdownReceived = false;
    private boolean sessionEnded = false;
    private boolean maybeSessionEnded = false;
    private long lastSequenceTime = -1L;
    private SequenceWithMetadata lastSequenceWithWindow = null;
    private long expectedWindowDistance = -1L;

    public MonitoringVerifier(Monitoring.MonitoringMessage firstMonitoringMessage, long timeout) {
        this(firstMonitoringMessage, timeout, 10);
    }

    public MonitoringVerifier(Monitoring.MonitoringMessage firstMonitoringMessage, long timeout, int windowHistorySize) {
        this.baseMonitoringMessageBuilder = Monitoring.MonitoringMessage.newBuilder((Monitoring.MonitoringMessage)MonitoringMessageUtil.baseMonitoringMessage()).setClusterId(firstMonitoringMessage.getClusterId()).setWindow(firstMonitoringMessage.getWindow()).setSession(firstMonitoringMessage.getSession()).setGroup(firstMonitoringMessage.getGroup()).setClientId(firstMonitoringMessage.getClientId()).setClientType(firstMonitoringMessage.getClientType()).setTopic(firstMonitoringMessage.getTopic()).setPartition(firstMonitoringMessage.getPartition()).setMinWindow(firstMonitoringMessage.getMinWindow()).setMaxWindow(firstMonitoringMessage.getMaxWindow()).setSamplePeriod(firstMonitoringMessage.getSamplePeriod());
        this.baseMonitoringMessageBuilder.setSamplePeriod(firstMonitoringMessage.getSamplePeriod() < TimeBucket.SIZE ? TimeBucket.SIZE : firstMonitoringMessage.getSamplePeriod());
        this.timeout = timeout;
        this.windowHistorySize = windowHistorySize;
    }

    public MonitoringVerifier(Controlcenter.VerifierInfo info) {
        this.baseMonitoringMessageBuilder = Monitoring.MonitoringMessage.newBuilder((Monitoring.MonitoringMessage)info.getBaseMonitoringMessage());
        this.timeout = info.getTimeout();
        this.shutdownReceived = info.getShutdownReceived();
        this.sessionEnded = info.getSessionEnded();
        this.maybeSessionEnded = info.getMaybeSessionEnded();
        this.lastSequenceTime = info.getLastSequenceTime();
        this.windowHistorySize = info.getWindowHistorySize();
        this.expectedWindowDistance = info.getExpectedWindowDistance();
        if (info.getLastSequenceWithWindow() != null && info.getLastSequenceWithWindow().getSequence() > -1L) {
            this.lastSequenceWithWindow = new SequenceWithMetadata(info.getLastSequenceWithWindow());
        }
        for (Controlcenter.SequenceInfoPair pair : info.getRangesList()) {
            this.ranges.add(Range.closedOpen((Comparable)new SequenceWithMetadata(pair.getLower()), (Comparable)new SequenceWithMetadata(pair.getUpper())));
        }
    }

    public Controlcenter.VerifierInfo createVerifierInfo() {
        ArrayList<Controlcenter.SequenceInfoPair> rangeList = new ArrayList<Controlcenter.SequenceInfoPair>();
        for (Range range : this.ranges.asRanges()) {
            rangeList.add(Controlcenter.SequenceInfoPair.newBuilder().setLower(((SequenceWithMetadata)range.lowerEndpoint()).toSequenceInfo()).setUpper(((SequenceWithMetadata)range.upperEndpoint()).toSequenceInfo()).build());
        }
        Controlcenter.VerifierInfo.Builder builder = Controlcenter.VerifierInfo.newBuilder().setBaseMonitoringMessage(this.baseMonitoringMessageBuilder).setTimeout(this.timeout).setShutdownReceived(this.shutdownReceived).setSessionEnded(this.sessionEnded).setMaybeSessionEnded(this.maybeSessionEnded).setLastSequenceTime(this.lastSequenceTime).setWindowHistorySize(this.windowHistorySize).setExpectedWindowDistance(this.expectedWindowDistance).addAllRanges(rangeList);
        if (this.lastSequenceWithWindow != null) {
            builder.setLastSequenceWithWindow(this.lastSequenceWithWindow.toSequenceInfo());
        } else {
            builder.setLastSequenceWithWindow(Controlcenter.SequenceInfo.newBuilder().setSequence(-1L).build());
        }
        return builder.build();
    }

    public String getClientId() {
        return this.baseMonitoringMessageBuilder.getClientId();
    }

    public String getTopic() {
        return this.baseMonitoringMessageBuilder.getTopic();
    }

    public int getPartition() {
        return this.baseMonitoringMessageBuilder.getPartition();
    }

    public long getSamplePeriod() {
        return this.baseMonitoringMessageBuilder.getSamplePeriod();
    }

    public String getSession() {
        return this.baseMonitoringMessageBuilder.getSession();
    }

    public Monitoring.MonitoringMessage getCopyOfBaseMonitoringMessage() {
        return this.baseMonitoringMessageBuilder.build();
    }

    public long lastActivityTimeMs() {
        return this.lastSequenceTime;
    }

    public void addSequence(Monitoring.MonitoringMessage monitoringMessage, long now) {
        if (this.isDone()) {
            throw new IllegalStateException("Received monitoring message after all expected sequences were received. Sequence=" + monitoringMessage.getSequence());
        }
        this.maybeSessionEnded = false;
        SequenceWithMetadata seq = new SequenceWithMetadata(monitoringMessage, now);
        this.ensureSequenceNotDuplicate(seq);
        SequenceWithMetadata nextSeq = seq.nextWithTimestamp(seq.timestamp());
        if (monitoringMessage.getShutdown()) {
            if (this.shutdownReceived) {
                throw new AlreadyShutdownException("One more non-duplicate sequence with shutdown. " + seq);
            }
            if (!this.ranges.isEmpty() && (this.ranges.span().contains((Comparable)seq) || seq.sequence() < ((SequenceWithMetadata)this.ranges.span().lowerEndpoint()).sequence())) {
                throw new ShutdownSequenceNotHighestException("Sequence with shutdown flag is not highest: " + seq);
            }
            this.shutdownReceived = true;
        } else if (this.shutdownReceived && this.ranges.span().intersection(Range.atLeast((Comparable)seq)).isEmpty()) {
            throw new SequenceAfterShutdownException("Sequence number after shutdown is higher than any other sequence number " + seq);
        }
        this.ranges.add(Range.closedOpen((Comparable)seq, (Comparable)nextSeq));
        if (now >= 0L) {
            this.lastSequenceTime = now;
        }
        this.updateWindowDistanceAndLastSequence(seq, monitoringMessage.getType() == Monitoring.MessageType.NORMAL ? monitoringMessage.getWindow() : -1L);
        this.verifySequencesBeforeShutdownAndMaybeSetDone();
    }

    public RangeSet<Long> getMissingMonitoringData(long now) {
        if (!this.ranges.isEmpty() && now >= 0L) {
            if (this.lastSequenceTime < 0L) {
                this.lastSequenceTime = now;
            }
            SequenceWithMetadata seqAfterHighest = (SequenceWithMetadata)((Range)this.ranges.asDescendingSetOfRanges().iterator().next()).upperEndpoint();
            long delta = this.lastSequenceTime <= 0L ? 0L : now - this.lastSequenceTime;
            long thresholdTimestamp = seqAfterHighest.timestamp() - this.timeout + delta;
            log.trace("thresholdTimestamp=" + thresholdTimestamp + ", local delta = " + delta);
            Iterator it = this.ranges.asRanges().iterator();
            TreeRangeSet verifiedMissedRanges = null;
            RangeSet<Long> missingWindows = null;
            Range prevRange = null;
            Long missingSeq = null;
            while (it.hasNext()) {
                Range nextRange = (Range)it.next();
                SequenceWithMetadata nextLowerEndpoint = (SequenceWithMetadata)nextRange.lowerEndpoint();
                if (prevRange == null && nextLowerEndpoint.sequence() > 0L) {
                    missingSeq = 0L;
                } else if (prevRange != null) {
                    if (prevRange.upperBoundType() == BoundType.CLOSED) {
                        throw new IllegalStateException("Upper bound of any range must always be open");
                    }
                    missingSeq = ((SequenceWithMetadata)prevRange.upperEndpoint()).sequence();
                }
                Long endMissingSeq = nextLowerEndpoint.sequence() - 1L;
                if (missingSeq != null && missingSeq <= endMissingSeq) {
                    long estimatedTimestamp = this.getTimedOutSequenceTimestamp(now, prevRange == null ? null : (SequenceWithMetadata)prevRange.upperEndpoint(), nextLowerEndpoint.timestamp());
                    if (estimatedTimestamp >= 0L) {
                        log.warn("Missing sequence numbers=[{}, {}] from client={}, topic={}, partition={}, estimated timestamp={}, next timestamp={}", new Object[]{missingSeq, endMissingSeq, this.getClientId(), this.getTopic(), this.getPartition(), estimatedTimestamp, nextLowerEndpoint.timestamp()});
                        long firstReportedMissingSeq = missingSeq;
                        if (endMissingSeq - firstReportedMissingSeq >= 20L) {
                            log.warn("Missing {} consecutive sequences; will report {} highest sequences for client={},  topic={}, partition=={}", new Object[]{endMissingSeq - firstReportedMissingSeq + 1L, 20L, this.getClientId(), this.getTopic(), this.getPartition()});
                            firstReportedMissingSeq = endMissingSeq - 20L + 1L;
                        }
                        for (long seq = firstReportedMissingSeq; seq <= endMissingSeq; ++seq) {
                            missingWindows = this.addMissingWindowRange(seq, nextLowerEndpoint, missingWindows, seq == firstReportedMissingSeq);
                        }
                        if (verifiedMissedRanges == null) {
                            verifiedMissedRanges = TreeRangeSet.create();
                        }
                        verifiedMissedRanges.add(Range.closedOpen((Comparable)new SequenceWithMetadata(missingSeq, (Long)estimatedTimestamp), (Comparable)nextLowerEndpoint));
                    }
                } else if (missingSeq != null) {
                    throw new IllegalStateException("Ranges must be in increasing sequence order");
                }
                if (missingSeq != null && missingWindows == null) break;
                prevRange = nextRange;
            }
            if (verifiedMissedRanges != null && !verifiedMissedRanges.isEmpty()) {
                this.ranges.addAll(verifiedMissedRanges);
            }
            if ((missingWindows = this.maybeTimeoutSequenceAfterHighest(seqAfterHighest, thresholdTimestamp, missingWindows)) != null) {
                this.verifySequencesBeforeShutdownAndMaybeSetDone();
            }
            return missingWindows;
        }
        return null;
    }

    public void notifySessionEnded() {
        this.sessionEnded = true;
    }

    public boolean isDone() {
        return this.shutdownReceived && this.ranges.isEmpty();
    }

    public boolean isSessionNotActive() {
        return this.isDone() || this.sessionEnded || this.maybeSessionEnded;
    }

    protected boolean isSessionEnded() {
        return this.sessionEnded;
    }

    private void ensureSequenceNotDuplicate(SequenceWithMetadata seq) {
        if (this.ranges.contains((Comparable)seq)) {
            throw new DuplicateSequenceNumberException("Duplicate sequence number: " + seq.sequence());
        }
    }

    private RangeSet<Long> maybeTimeoutSequenceAfterHighest(SequenceWithMetadata sequenceAfterHighest, long thresholdTimestamp, RangeSet<Long> missingWindows) {
        if (!this.shutdownReceived) {
            long estimatedTimestamp = sequenceAfterHighest.timestamp() + 5L * this.getSamplePeriod();
            long missingSeq = sequenceAfterHighest.sequence();
            if (this.sessionEnded && estimatedTimestamp <= thresholdTimestamp) {
                log.info("Session ended and timed out at least one sequence number ({}) after the highest received sequence number. Done", (Object)missingSeq);
                this.ranges.clear();
                this.shutdownReceived = true;
                return this.addMissingWindowRange(missingSeq, missingWindows, true);
            }
            if (!this.maybeSessionEnded && !this.sessionEnded && estimatedTimestamp <= thresholdTimestamp) {
                log.info("Timed out sequence={} after the highest received sequence for topic={}, partition={}, clientID={}. Session maybe ended.", new Object[]{missingSeq, this.getTopic(), this.getPartition(), this.getClientId()});
                this.ranges.add(Range.closedOpen((Comparable)new SequenceWithMetadata(0L), (Comparable)sequenceAfterHighest.nextWithTimestamp(estimatedTimestamp)));
                this.maybeSessionEnded = true;
                return this.addMissingWindowRange(missingSeq, missingWindows, true);
            }
        }
        return missingWindows;
    }

    private void verifySequencesBeforeShutdownAndMaybeSetDone() {
        Set rangeSet;
        if (this.shutdownReceived && (rangeSet = this.ranges.asRanges()).size() == 1 && ((SequenceWithMetadata)((Range)rangeSet.iterator().next()).lowerEndpoint()).sequence() == 0L) {
            log.debug("MonitoringVerifier got all sequence numbers and a shutdown flag!");
            this.ranges.clear();
        }
    }

    private long getTimedOutSequenceTimestamp(long currentWallclockTime, SequenceWithMetadata prevUpperEndpoint, long nextNonMissingSequenceTimestamp) {
        long thresholdTimestamp = currentWallclockTime - this.timeout;
        long estimatedTimestamp = nextNonMissingSequenceTimestamp;
        if (prevUpperEndpoint != null && prevUpperEndpoint.timestamp() > 0L) {
            estimatedTimestamp = Math.max(estimatedTimestamp, prevUpperEndpoint.timestamp());
        }
        if (estimatedTimestamp <= thresholdTimestamp) {
            return estimatedTimestamp;
        }
        return -1L;
    }

    private RangeSet<Long> addMissingWindowRange(long missingSequence, SequenceWithMetadata nextLowerEndpoint, RangeSet<Long> missingWindows, boolean firstInMissingRange) {
        long delta = nextLowerEndpoint.sequence() - missingSequence;
        if (delta < 1L) {
            throw new IllegalArgumentException("Invalid missing sequence");
        }
        if (nextLowerEndpoint.minWindow() < 0L && delta <= this.windowHistorySize) {
            return missingWindows;
        }
        TreeRangeSet retWindows = missingWindows;
        if (retWindows == null) {
            retWindows = TreeRangeSet.create();
        }
        if (nextLowerEndpoint.minWindow() >= 0L) {
            long minWindow = nextLowerEndpoint.minWindow();
            long maxWindow = nextLowerEndpoint.maxWindow();
            if (delta > this.windowHistorySize) {
                log.info("Missed too many consecutive sequence numbers for client=" + this.getClientId() + ", topic=" + this.getTopic() + ", partition=" + this.getPartition() + ". Will estimate time window range with missed monitoring data.");
                long expectedDistance = this.getExpectedDistanceMs(delta - this.windowHistorySize);
                minWindow = Math.max(0L, minWindow - expectedDistance);
                maxWindow += expectedDistance;
            }
            retWindows.add(Range.closed((Comparable)Long.valueOf(minWindow), (Comparable)Long.valueOf(maxWindow)));
            log.info("Missing sequence=" + missingSequence + " window range=[" + minWindow + "..." + maxWindow + "] for clientId=" + this.getClientId() + ", topic=" + this.getTopic() + ", partition=" + this.getPartition());
            return retWindows;
        }
        return this.addMissingWindowRange(missingSequence, (RangeSet<Long>)missingWindows, firstInMissingRange);
    }

    private RangeSet<Long> addMissingWindowRange(long missingSequence, RangeSet<Long> missingWindows, boolean firstInMissingRange) {
        TreeRangeSet retWindows = missingWindows;
        if (retWindows == null) {
            retWindows = TreeRangeSet.create();
        }
        if (this.lastSequenceWithWindow == null || this.lastSequenceWithWindow.minWindow() < 0L || this.lastSequenceWithWindow.maxWindow() < 0L || this.lastSequenceWithWindow.sequence() < 0L) {
            if (firstInMissingRange) {
                log.warn("No information about windows received for this session for client=" + this.getClientId() + "topic=" + this.getTopic() + ", partition=" + this.getPartition());
            }
            retWindows.add(Range.closed((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(0L)));
            return retWindows;
        }
        long delta = Math.abs(missingSequence - this.lastSequenceWithWindow.sequence());
        if (delta < 1L) {
            throw new IllegalArgumentException("Missing sequence expected to be different from last seen");
        }
        long expectedDistance = this.getExpectedDistanceMs(delta + 1L);
        long minWindow = Math.max(0L, this.lastSequenceWithWindow.minWindow() - expectedDistance);
        long maxWindow = this.lastSequenceWithWindow.maxWindow() + expectedDistance;
        retWindows.add(Range.closed((Comparable)Long.valueOf(minWindow), (Comparable)Long.valueOf(maxWindow)));
        log.warn("No window info in the next non-missing sequence. Estimated window range for missing sequence=" + missingSequence + " [" + minWindow + "..." + maxWindow + "], lastSequenceWithWindow=" + this.lastSequenceWithWindow + " for clientId=" + this.getClientId() + ", topic=" + this.getTopic() + ", partition=" + this.getPartition());
        return retWindows;
    }

    private void updateWindowDistanceAndLastSequence(SequenceWithMetadata seq, long seqWindow) {
        if (seq.minWindow() >= 0L && seq.maxWindow() >= 0L) {
            this.lastSequenceWithWindow = seq;
            long delta = seq.maxWindow() - seq.minWindow();
            if (delta < 0L) {
                log.error("maxWindow < minWindow. Not able to record expected window range.");
            } else {
                this.expectedWindowDistance = Math.max(this.expectedWindowDistance, delta);
            }
        } else if (seqWindow >= 0L) {
            this.lastSequenceWithWindow = seq.withMinMaxWindow(seqWindow);
        }
    }

    private long getExpectedDistanceMs(long sequenceDelta) {
        long normalizedDistanceWin = Math.max(this.expectedWindowDistance < 0L || this.windowHistorySize <= 1L ? 10L : this.expectedWindowDistance / (this.windowHistorySize - 1L) / this.getSamplePeriod(), 1L);
        normalizedDistanceWin = Math.min(normalizedDistanceWin, 600L);
        long normalizedDistance = normalizedDistanceWin * this.getSamplePeriod();
        log.trace("Calculated normalized distance =" + normalizedDistance + ", history size=" + this.windowHistorySize + ", expectedWindowDistance=" + this.expectedWindowDistance + ", default normalized distance = " + 10L);
        return normalizedDistance * sequenceDelta;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MonitoringVerifier other = (MonitoringVerifier)o;
        return Objects.equals(this.baseMonitoringMessageBuilder.buildPartial(), other.baseMonitoringMessageBuilder.buildPartial()) && Objects.equals(this.lastSequenceTime, other.lastSequenceTime) && Objects.equals(this.ranges, other.ranges) && Objects.equals(this.shutdownReceived, other.shutdownReceived) && Objects.equals(this.sessionEnded, other.sessionEnded) && Objects.equals(this.maybeSessionEnded, other.maybeSessionEnded) && Objects.equals(this.timeout, other.timeout) && Objects.equals(this.windowHistorySize, other.windowHistorySize) && Objects.equals(this.expectedWindowDistance, other.expectedWindowDistance) && Objects.equals(this.lastSequenceWithWindow, other.lastSequenceWithWindow);
    }

    public int hashCode() {
        return Objects.hash(this.baseMonitoringMessageBuilder.buildPartial(), this.lastSequenceTime, this.ranges, this.shutdownReceived, this.sessionEnded, this.maybeSessionEnded, this.timeout, this.windowHistorySize, this.expectedWindowDistance, this.lastSequenceWithWindow);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("clientId", (Object)this.getClientId()).add("topic", (Object)this.getTopic()).add("partition", this.getPartition()).add("session", (Object)this.getSession()).add("timeout", this.timeout).add("windowHistorySize", this.windowHistorySize).add("shutdownReceived", this.shutdownReceived).add("maybeSessionEnded", this.maybeSessionEnded).add("sessionEnded", this.sessionEnded).add("lastSequenceTime", this.lastSequenceTime).add("expectedWindowDistance", this.expectedWindowDistance).add("lastSequenceWithWindow", (Object)this.lastSequenceWithWindow).add("ranges", this.ranges).toString();
    }
}

