/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class ProxyUtil {
    public static <T extends AutoCloseable> T newDelegatingProxy(Class<T> clientType, final T delegate, final Runnable closeAction) {
        InvocationHandler delegatingHandler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if ("close".equals(method.getName())) {
                    closeAction.run();
                    return null;
                }
                return method.invoke((Object)delegate, args);
            }
        };
        return (T)((AutoCloseable)clientType.cast(Proxy.newProxyInstance(clientType.getClassLoader(), new Class[]{clientType}, delegatingHandler)));
    }
}

