/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.util;

import com.google.common.collect.Maps;
import io.confluent.common.metrics.KafkaMetric;
import io.confluent.common.metrics.MetricsReporter;
import java.util.List;
import java.util.Map;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class StreamProgressReporter
implements MetricsReporter {
    private static final Logger log = LoggerFactory.getLogger(StreamProgressReporter.class);
    private Map<String, KafkaMetric> monitoringInputProgress = Maps.newConcurrentMap();
    private Map<String, KafkaMetric> monitoringInputRate = Maps.newConcurrentMap();
    private Map<String, KafkaMetric> metricsInputProgress = Maps.newConcurrentMap();
    private Map<String, KafkaMetric> metricsInputRate = Maps.newConcurrentMap();

    public void configure(Map<String, ?> map) {
    }

    public void init(List<KafkaMetric> metrics) {
        for (KafkaMetric metric : metrics) {
            this.metricChange(metric);
        }
    }

    public void metricChange(KafkaMetric kafkaMetric) {
        String cluster = (String)kafkaMetric.metricName().tags().get("cluster");
        String inputType = (String)kafkaMetric.metricName().tags().get("input");
        String progressType = (String)kafkaMetric.metricName().tags().get("progress");
        String name = kafkaMetric.metricName().name();
        if (inputType != null && cluster != null) {
            log.info("name={} type={} cluster={} value={}", new Object[]{name, inputType, cluster, kafkaMetric.value()});
            if ("monitoring".equals(inputType)) {
                if ("input-topic".equals(progressType)) {
                    if (name.endsWith(".timestamp")) {
                        this.monitoringInputProgress.put(cluster, kafkaMetric);
                    } else if (name.endsWith(".rate")) {
                        this.monitoringInputRate.put(cluster, kafkaMetric);
                    }
                }
            } else if ("metrics".equals(inputType) && "input-topic".equals(progressType)) {
                if (name.endsWith(".timestamp")) {
                    this.metricsInputProgress.put(cluster, kafkaMetric);
                } else if (name.endsWith(".rate")) {
                    this.metricsInputRate.put(cluster, kafkaMetric);
                }
            }
        }
    }

    public void close() {
    }

    public long getMonitoringInputProgress(String cluster) {
        return StreamProgressReporter.getLong(this.monitoringInputProgress, cluster);
    }

    public long getMonitoringInputProgress() {
        return StreamProgressReporter.getInputProgress(this.monitoringInputProgress);
    }

    public long getMonitoringInputProgressRate(String cluster) {
        return StreamProgressReporter.getLong(this.monitoringInputRate, cluster);
    }

    public double getMonitoringInputProgressRate() {
        return StreamProgressReporter.getInputRate(this.monitoringInputRate);
    }

    public long getMetricsInputProgress(String cluster) {
        return StreamProgressReporter.getLong(this.metricsInputProgress, cluster);
    }

    public long getMetricsInputProgress() {
        return StreamProgressReporter.getInputProgress(this.metricsInputProgress);
    }

    public long getMetricsInputProgressRate(String cluster) {
        return StreamProgressReporter.getLong(this.metricsInputRate, cluster);
    }

    public double getMetricsInputProgressRate() {
        return StreamProgressReporter.getInputRate(this.metricsInputRate);
    }

    private static long getInputProgress(Map<String, KafkaMetric> progress) {
        long out = Long.MAX_VALUE;
        for (KafkaMetric metric : progress.values()) {
            if (metric == null) continue;
            out = Math.min(out, (long)metric.value());
        }
        return out;
    }

    private static double getInputRate(Map<String, KafkaMetric> rate) {
        double out = 0.0;
        for (KafkaMetric metric : rate.values()) {
            if (metric == null) continue;
            out += metric.value();
        }
        return out;
    }

    private static long getLong(Map<String, KafkaMetric> map, String key) {
        KafkaMetric metric = map.get(key);
        if (metric != null) {
            return (long)metric.value();
        }
        return -1L;
    }
}

