/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog;

import io.confluent.catalog.model.typedef.TagDef;
import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.rest.RestConfigException;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.kafka.common.config.ConfigDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataCatalogConfig
extends SchemaRegistryConfig {
    private static final Logger log = LoggerFactory.getLogger(DataCatalogConfig.class);
    public static final String ATLAS_HOME_CONFIG = "atlas.home";
    public static final String ATLAS_DATA_CONFIG = "atlas.data";
    public static final String CATALOG_ENABLE_CONFIG = "catalog.enable";
    public static final String CATALOG_TOPIC_CONFIG = "catalog.topic";
    public static final String CATALOG_EXCLUDE_SUBJECTS_CONFIG = "catalog.exclude.subjects";
    public static final String CATALOG_NUM_THREADS_CONFIG = "catalog.num.threads";
    public static final String CATALOG_METRICS_NUM_THREADS_CONFIG = "catalog.metrics.num.threads";
    public static final String CATALOG_MAX_QUEUE_SIZE_CONFIG = "catalog.max.queue.size";
    public static final String CATALOG_TENANT_MAX_TAGDEFS_CONFIG = "catalog.tenant.max.tagdefs";
    public static final String CATALOG_DELETE_TYPEDEFS_CONFIG = "catalog.delete.typedefs";
    public static final String CATALOG_DELETE_ATTRDEFS_CONFIG = "catalog.delete.attrdefs";
    public static final String CATALOG_GRAPHQL_MAX_COMPLEXITY_CONFIG = "catalog.graphql.max.complexity";
    public static final String CATALOG_GRAPHQL_MAX_DEPTH_CONFIG = "catalog.graphql.max.depth";
    public static final String CATALOG_GRAPHQL_TIMEOUT_MS_CONFIG = "catalog.graphql.timeout.ms";
    public static final String CATALOG_GRAPHQL_NUM_THREADS_CONFIG = "catalog.graphql.num.threads";
    public static final String CATALOG_INGESTOR_ENABLE_CONFIG = "catalog.ingestor.enable";
    public static final String CATALOG_INGESTOR_TOPICS_CONFIG = "catalog.ingestor.topics";
    public static final String CATALOG_INGESTOR_BATCH_SIZE_CONFIG = "catalog.ingestor.batch.size";
    public static final String CATALOG_INGESTOR_BATCH_TIMEOUT_MS_CONFIG = "catalog.ingestor.batch.timeout.ms";
    public static final String CATALOG_INGESTOR_CACHE_MAX_SIZE_CONFIG = "catalog.ingestor.cache.max.size";
    public static final String CATALOG_INGESTOR_CACHE_TTL_SEC_CONFIG = "catalog.ingestor.cache.ttl.sec";
    public static final String CATALOG_INGESTOR_MAX_POLL_INTERVAL_MS = "catalog.ingestor.max.poll.interval.ms";
    public static final String CATALOG_INGESTOR_SHUTDOWN_TIMEOUT_MS = "catalog.ingestor.shutdown.timeout.ms";
    public static final String CATALOG_RECONCILIATION_CLUSTER_ENABLE_CONFIG = "catalog.reconciliation.cluster.enable";
    public static final String CATALOG_RECONCILIATION_TOPIC_ENABLE_CONFIG = "catalog.reconciliation.topic.enable";
    public static final String CATALOG_RECONCILIATION_CACHE_MAX_SIZE_CONFIG = "catalog.reconciliation.cache.max.size";
    public static final String CATALOG_RECONCILIATION_CACHE_TTL_SEC_CONFIG = "catalog.reconciliation.cache.ttl.sec";
    public static final String CATALOG_ENTITY_WRITE_APIS_ENABLE_CONFIG = "catalog.entity.write.apis.enable";
    public static final String CATALOG_ENTITY_MODIFIABLE_ATTRS_CONFIG = "catalog.entity.modifiable.attrs";
    public static final String CATALOG_ENTITY_MODIFIABLE_ATTRS_PREFIX_CONFIG = "catalog.entity.modifiable.attrs.prefix";
    public static final String CATALOG_RBAC_ENABLE_CONFIG = "catalog.rbac.enable";
    public static final String CATALOG_RBAC_AUTHORIZER_CLASS_CONFIG = "catalog.rbac.authorizer.class";
    public static final String CATALOG_MAX_RETRIES_CONFIG = "catalog.max.retries";
    public static final String CATALOG_RETRIES_WAIT_MS_CONFIG = "catalog.retries.wait.ms";
    public static final String CATALOG_NOTIFICATIONS_ENABLE_CONFIG = "catalog.notifications.enable";
    public static final String CATALOG_NOTIFICATIONS_DESIGNATED_HOST_PREFIX_CONFIG = "catalog.notifications.designated.host";
    public static final String CATALOG_NOTIFICATIONS_TOPIC = "catalog.notifications.topic";
    public static final String CATALOG_NOTIFICATIONS_HOOK_TOPIC = "catalog.notifications.hook.topic";
    public static final String CATALOG_USE_INDEX_QUERY_TO_FIND_ENTITY_BY_UNIQUE_ATTRIBUTES = "catalog.use.index.query.unique.attr";
    public static final String CATALOG_COUNT_TAGS_USE_SEARCH_CONFIG = "catalog.count.tags.use.search";
    public static final String CATALOG_COUNT_TAGS_AB_TESTING_CONFIG = "catalog.count.tags.ab.testing";
    public static final String CATALOG_COUNT_TAGS_TENANTS_USE_SEARCH_CONFIG = "catalog.count.tags.tenants.use.search";
    public static final String CATALOG_COUNT_TAGS_PERSISTENT_CACHE_CONFIG = "catalog.count.tags.persistent.cache";
    public static final String CATALOG_CACHE_DATA_DIR_CONFIG = "catalog.cache.data.dir";
    public static final String CATALOG_MAX_LIMIT_PER_ITERATION = "catalog.max.limit.per.iteration";
    public static final String CATALOG_TAGDEF_UPDATE_TO_DEFAULT_COLOR_CONFIG = "catalog.tagdef.update.to.default.color";
    public static final String CATALOG_TAGDEF_UPDATE_COLOR_CONFIG = "catalog.tagdef.update.color";
    protected static final String CATALOG_TOPIC_DEFAULT = "_catalog";
    public static final int CATALOG_MAX_LIMIT_PER_ITERATION_DEFAULT = 500;
    protected static final int CATALOG_NUM_THREADS_DEFAULT = 10;
    protected static final int CATALOG_METRICS_NUM_THREADS_DEFAULT = 10;
    protected static final int CATALOG_MAX_QUEUE_SIZE_DEFAULT = 100000;
    protected static final int CATALOG_TENANT_MAX_TAGDEFS_DEFAULT = 1000;
    protected static final int CATALOG_GRAPHQL_MAX_COMPLEXITY_DEFAULT = 200;
    protected static final int CATALOG_GRAPHQL_MAX_DEPTH_DEFAULT = 20;
    protected static final int CATALOG_GRAPHQL_TIMEOUT_MS_DEFAULT = 30000;
    protected static final int CATALOG_GRAPHQL_NUM_THREADS_DEFAULT = 10;
    protected static final int CATALOG_INGESTOR_BATCH_SIZE_DEFAULT = 500;
    protected static final int CATALOG_INGESTOR_BATCH_TIMEOUT_MS_DEFAULT = 5000;
    protected static final int CATALOG_INGESTOR_CACHE_MAX_SIZE_DEFAULT = 10000;
    protected static final int CATALOG_INGESTOR_CACHE_TTL_SEC_DEFAULT = 600;
    protected static final int CATALOG_INGESTOR_MAX_POLL_INTERVAL_MS_DEFAULT = 300000;
    protected static final int CATALOG_INGESTOR_SHUTDOWN_TIMEOUT_MS_DEFAULT = 180000;
    protected static final int CATALOG_RECONCILIATION_CACHE_MAX_SIZE_DEFAULT = 1000;
    protected static final int CATALOG_RECONCILIATION_CACHE_TTL_SEC_DEFAULT = 180;
    protected static final String CATALOG_ENTITY_MODIFIABLE_ATTRS_DEFAULT = "description,owner,ownerEmail";
    protected static final String CATALOG_ENTITY_MODIFIABLE_ATTRS_PREFIX_DEFAULT = "__";
    protected static final int CATALOG_MAX_RETRIES_DEFAULT = 3;
    protected static final int CATALOG_RETRIES_WAIT_MS_DEFAULT = 1000;
    protected static final boolean CATALOG_TAGDEF_UPDATE_TO_DEFAULT_COLOR_DEFAULT = false;
    public static final String CATALOG_TAGDEF_UPDATE_COLOR_DEFAULT = TagDef.TagColor.PURPLE_LIGHT.name();
    protected static final String ATLAS_HOME_DOC = "The Atlas home directory.";
    protected static final String ATLAS_DATA_DOC = "The Atlas data directory.";
    protected static final String CATALOG_ENABLE_DOC = "Whether to enable the catalog.";
    protected static final String CATALOG_TOPIC_DOC = "The topic for catalog metadata.";
    protected static final String CATALOG_EXCLUDE_SUBJECTS_DOC = "Subjects to exclude from the catalog.";
    protected static final String CATALOG_NUM_THREADS_DOC = "The number of catalog indexing threads.";
    protected static final String CATALOG_METRICS_NUM_THREADS_DOC = "The number of threads for updating catalog metrics.";
    protected static final String CATALOG_MAX_QUEUE_SIZE_DOC = "The maximum queue size per thread.";
    protected static final String CATALOG_TENANT_MAX_TAGDEFS_DOC = "The maximum number of tag definitions per tenant.";
    protected static final String CATALOG_DELETE_TYPEDEFS_DOC = "Legacy typeDefs to be deleted.";
    protected static final String CATALOG_DELETE_ATTRDEFS_DOC = "Legacy attrDefs to be deleted.";
    protected static final String CATALOG_GRAPHQL_MAX_COMPLEXITY_DOC = "The maximum complexity of the fields for a GraphQL query.";
    protected static final String CATALOG_GRAPHQL_MAX_DEPTH_DOC = "The maximum depth for a GraphQL query.";
    protected static final String CATALOG_GRAPHQL_TIMEOUT_MS_DOC = "The timeout in ms for a GraphQL query.";
    protected static final String CATALOG_GRAPHQL_NUM_THREADS_DOC = "The number of threads fetching data for a GraphQL query.";
    protected static final String CATALOG_INGESTOR_ENABLE_DOC = "Whether to enable the catalog ingestor.";
    protected static final String CATALOG_INGESTOR_TOPICS_DOC = "A comma separated list of topics for the catalog ingestor.";
    protected static final String CATALOG_INGESTOR_BATCH_SIZE_DOC = "Batch size for the ingestion.";
    protected static final String CATALOG_INGESTOR_BATCH_TIMEOUT_MS_DOC = "The timeout for committing the batch during ingestion.";
    protected static final String CATALOG_INGESTOR_CACHE_MAX_SIZE_DOC = "Maximum size for the ingestor cache.";
    protected static final String CATALOG_INGESTOR_CACHE_TTL_SEC_DOC = "The TTL in seconds for the ingestor cache.";
    protected static final String CATALOG_INGESTOR_MAX_POLL_INTERVAL_MS_DOC = "Maximum delay between two calls of poll().";
    protected static final String CATALOG_INGESTOR_SHUTDOWN_TIMEOUT_MS_DOC = "The timeout for shutting down kstreams in catalog ingestor.";
    protected static final String CATALOG_RECONCILIATION_CLUSTER_ENABLE_DOC = "Whether to enable the catalog reconciliation for cluster metadata.";
    protected static final String CATALOG_RECONCILIATION_TOPIC_ENABLE_DOC = "Whether to enable the catalog reconciliation for topic metadata.";
    protected static final String CATALOG_RECONCILIATION_CACHE_MAX_SIZE_DOC = "Maximum size for the reconciliation cache.";
    protected static final String CATALOG_RECONCILIATION_CACHE_TTL_SEC_DOC = "The TTL in seconds for the reconciliation cache.";
    protected static final String CATALOG_ENTITY_WRITE_APIS_DOC = "Whether to enable APIs to create, update, and delete entities.";
    protected static final String CATALOG_ENTITY_MODIFIABLE_ATTRS_DOC = "The entity attributes that can be modified during an update.";
    protected static final String CATALOG_ENTITY_MODIFIABLE_ATTRS_PREFIX_DOC = "The prefix of entity attributes that can be modified during an update. If both `catalog.entity.modifiable.attrs` and `__` are set, the union of these two configs will be applied.";
    protected static final String CATALOG_RBAC_ENABLE_DOC = "Whether to enable RBAC for catalog.";
    protected static final String CATALOG_RBAC_AUTHORIZER_CLASS_DOC = "Authorizer class name for rbac catalog.";
    protected static final String CATALOG_NOTIFICATIONS_ENABLE_DOC = "Whether to enable notifications for catalog.";
    protected static final String CATALOG_NOTIFICATIONS_DESIGNATED_HOST_PREFIX_DOC = "Host matching this prefix will send the notifications. Typically schema-registry-0";
    protected static final String CATALOG_NOTIFICATIONS_TOPIC_DOC = "Topic for catalog notifications";
    protected static final String CATALOG_NOTIFICATIONS_HOOK_TOPIC_DOC = "Catalog hook topic. Currently not in use";
    protected static final String CATALOG_MAX_RETRIES_DOC = "Maximum number of times to retry catalog operations.";
    protected static final String CATALOG_RETRIES_WAIT_MS_DOC = "Time in milliseconds to wait before each retry.";
    protected static final String CATALOG_USE_INDEX_QUERY_TO_FIND_ENTITY_BY_UNIQUE_ATTRIBUTES_DOC = "Whether to use index query to find entity by unique attributes in Atlas.";
    protected static final String CATALOG_COUNT_TAGS_USE_SEARCH_DOC = "Whether to use search to count tags in Atlas.";
    protected static final String CATALOG_COUNT_TAGS_AB_TESTING_DOC = "Whether to enable A/B testing for counting tags.";
    protected static final String CATALOG_COUNT_TAGS_TENANTS_USE_SEARCH_DOC = "Tenants who use Atlas discovery search service to count tags.";
    protected static final String CATALOG_COUNT_TAGS_PERSISTENT_CACHE_DOC = "Whether to enable persistent cache for counting tags.";
    protected static final String CATALOG_CACHE_DATA_DIR_DOC = "Directory to use for the persistent cache for catalog.";
    protected static final String CATALOG_MAX_LIMIT_PER_ITERATION_DOC = "The maximum limit for every iteration in GraphQL queries when refill is true";
    protected static final String CATALOG_TAGDEF_UPDATE_TO_DEFAULT_COLOR_DOC = "Reset all tags with color defined by catalog.tagdef.update.color to DEFAULT_COLOR";
    protected static final String CATALOG_TAGDEF_UPDATE_COLOR_DOC = "All tags of this color will be reset to DEFAULT_COLOR";
    private static final ConfigDef serverConfig = DataCatalogConfig.baseSchemaRegistryConfigDef().define("atlas.home", ConfigDef.Type.STRING, null, ConfigDef.Importance.HIGH, "The Atlas home directory.").define("atlas.data", ConfigDef.Type.STRING, null, ConfigDef.Importance.HIGH, "The Atlas data directory.").define("catalog.enable", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.HIGH, "Whether to enable the catalog.").define("catalog.topic", ConfigDef.Type.STRING, (Object)"_catalog", ConfigDef.Importance.MEDIUM, "The topic for catalog metadata.").define("catalog.exclude.subjects", ConfigDef.Type.LIST, (Object)"", ConfigDef.Importance.LOW, "Subjects to exclude from the catalog.").define("catalog.num.threads", ConfigDef.Type.INT, (Object)10, ConfigDef.Importance.LOW, "The number of catalog indexing threads.").define("catalog.metrics.num.threads", ConfigDef.Type.INT, (Object)10, ConfigDef.Importance.LOW, "The number of threads for updating catalog metrics.").define("catalog.max.queue.size", ConfigDef.Type.INT, (Object)100000, ConfigDef.Importance.LOW, "The maximum queue size per thread.").define("catalog.tenant.max.tagdefs", ConfigDef.Type.INT, (Object)1000, ConfigDef.Importance.LOW, "The maximum number of tag definitions per tenant.").define("catalog.delete.typedefs", ConfigDef.Type.LIST, (Object)"", ConfigDef.Importance.LOW, "Legacy typeDefs to be deleted.").define("catalog.delete.attrdefs", ConfigDef.Type.LIST, (Object)"", ConfigDef.Importance.LOW, "Legacy attrDefs to be deleted.").define("catalog.graphql.max.complexity", ConfigDef.Type.INT, (Object)200, ConfigDef.Importance.LOW, "The maximum complexity of the fields for a GraphQL query.").define("catalog.graphql.max.depth", ConfigDef.Type.INT, (Object)20, ConfigDef.Importance.LOW, "The maximum depth for a GraphQL query.").define("catalog.graphql.timeout.ms", ConfigDef.Type.INT, (Object)30000, ConfigDef.Importance.LOW, "The timeout in ms for a GraphQL query.").define("catalog.graphql.num.threads", ConfigDef.Type.INT, (Object)10, ConfigDef.Importance.LOW, "The number of threads fetching data for a GraphQL query.").define("catalog.ingestor.enable", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.HIGH, "Whether to enable the catalog ingestor.").define("catalog.ingestor.topics", ConfigDef.Type.LIST, (Object)"", ConfigDef.Importance.MEDIUM, "A comma separated list of topics for the catalog ingestor.").define("catalog.ingestor.batch.size", ConfigDef.Type.INT, (Object)500, ConfigDef.Importance.LOW, "Batch size for the ingestion.").define("catalog.ingestor.batch.timeout.ms", ConfigDef.Type.LONG, (Object)5000, ConfigDef.Importance.LOW, "The timeout for committing the batch during ingestion.").define("catalog.ingestor.cache.max.size", ConfigDef.Type.INT, (Object)10000, ConfigDef.Importance.LOW, "Maximum size for the ingestor cache.").define("catalog.ingestor.cache.ttl.sec", ConfigDef.Type.INT, (Object)600, ConfigDef.Importance.LOW, "The TTL in seconds for the ingestor cache.").define("catalog.ingestor.max.poll.interval.ms", ConfigDef.Type.INT, (Object)300000, ConfigDef.Importance.LOW, "Maximum delay between two calls of poll().").define("catalog.ingestor.shutdown.timeout.ms", ConfigDef.Type.INT, (Object)180000, ConfigDef.Importance.LOW, "The timeout for shutting down kstreams in catalog ingestor.").define("catalog.reconciliation.cluster.enable", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, "Whether to enable the catalog reconciliation for cluster metadata.").define("catalog.reconciliation.topic.enable", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, "Whether to enable the catalog reconciliation for topic metadata.").define("catalog.reconciliation.cache.max.size", ConfigDef.Type.INT, (Object)1000, ConfigDef.Importance.LOW, "Maximum size for the reconciliation cache.").define("catalog.reconciliation.cache.ttl.sec", ConfigDef.Type.INT, (Object)180, ConfigDef.Importance.LOW, "The TTL in seconds for the reconciliation cache.").define("catalog.entity.write.apis.enable", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, "Whether to enable APIs to create, update, and delete entities.").define("catalog.entity.modifiable.attrs", ConfigDef.Type.LIST, (Object)"description,owner,ownerEmail", ConfigDef.Importance.LOW, "The entity attributes that can be modified during an update.").define("catalog.entity.modifiable.attrs.prefix", ConfigDef.Type.STRING, (Object)"__", ConfigDef.Importance.LOW, "The prefix of entity attributes that can be modified during an update. If both `catalog.entity.modifiable.attrs` and `__` are set, the union of these two configs will be applied.").define("catalog.rbac.enable", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, "Whether to enable RBAC for catalog.").define("catalog.rbac.authorizer.class", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, "Authorizer class name for rbac catalog.").define("catalog.max.retries", ConfigDef.Type.INT, (Object)3, ConfigDef.Importance.LOW, "Maximum number of times to retry catalog operations.").define("catalog.retries.wait.ms", ConfigDef.Type.INT, (Object)1000, ConfigDef.Importance.LOW, "Time in milliseconds to wait before each retry.").define("catalog.notifications.enable", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, "Whether to enable notifications for catalog.").define("catalog.notifications.designated.host", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, "Host matching this prefix will send the notifications. Typically schema-registry-0").define("catalog.notifications.topic", ConfigDef.Type.STRING, (Object)"_confluent-catalog-entities", ConfigDef.Importance.LOW, "Topic for catalog notifications").define("catalog.notifications.hook.topic", ConfigDef.Type.STRING, (Object)"_confluent-catalog-hooks", ConfigDef.Importance.LOW, "Catalog hook topic. Currently not in use").define("catalog.use.index.query.unique.attr", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, "Whether to use index query to find entity by unique attributes in Atlas.").define("catalog.count.tags.use.search", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, "Whether to use search to count tags in Atlas.").define("catalog.count.tags.ab.testing", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, "Whether to enable A/B testing for counting tags.").define("catalog.count.tags.tenants.use.search", ConfigDef.Type.LIST, (Object)"", ConfigDef.Importance.LOW, "Tenants who use Atlas discovery search service to count tags.").define("catalog.count.tags.persistent.cache", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, "Whether to enable persistent cache for counting tags.").define("catalog.cache.data.dir", ConfigDef.Type.STRING, (Object)"/tmp/catalog_cache", ConfigDef.Importance.LOW, "Directory to use for the persistent cache for catalog.").define("catalog.max.limit.per.iteration", ConfigDef.Type.INT, (Object)500, ConfigDef.Importance.LOW, "The maximum limit for every iteration in GraphQL queries when refill is true").define("catalog.tagdef.update.to.default.color", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, "Reset all tags with color defined by catalog.tagdef.update.color to DEFAULT_COLOR").define("catalog.tagdef.update.color", ConfigDef.Type.STRING, (Object)CATALOG_TAGDEF_UPDATE_COLOR_DEFAULT, ConfigDef.Importance.LOW, "All tags of this color will be reset to DEFAULT_COLOR");

    private static Properties getPropsFromFile(String propsFile) throws RestConfigException {
        Properties props = new Properties();
        if (propsFile == null) {
            return props;
        }
        try (FileInputStream propStream = new FileInputStream(propsFile);){
            props.load(propStream);
        }
        catch (IOException e) {
            throw new RestConfigException("Couldn't load properties from " + propsFile, (Throwable)e);
        }
        return props;
    }

    public DataCatalogConfig(String propsFile) throws RestConfigException {
        this(DataCatalogConfig.getPropsFromFile(propsFile));
    }

    public DataCatalogConfig(Properties props) throws RestConfigException {
        super(serverConfig, props);
    }

    public String atlasHome() {
        return this.getString(ATLAS_HOME_CONFIG);
    }

    public String atlasData() {
        return this.getString(ATLAS_DATA_CONFIG);
    }

    public boolean isCatalogEnabled() {
        return this.getBoolean(CATALOG_ENABLE_CONFIG);
    }

    public String catalogTopic() {
        return this.getString(CATALOG_TOPIC_CONFIG);
    }

    public List<String> catalogExcludeSubjects() {
        return this.getList(CATALOG_EXCLUDE_SUBJECTS_CONFIG);
    }

    public int catalogNumThreads() {
        return this.getInt(CATALOG_NUM_THREADS_CONFIG);
    }

    public int catalogMetricsNumThreads() {
        return this.getInt(CATALOG_METRICS_NUM_THREADS_CONFIG);
    }

    public int catalogMaxQueueSize() {
        return this.getInt(CATALOG_MAX_QUEUE_SIZE_CONFIG);
    }

    public int catalogTenantMaxTagDefs() {
        return this.getInt(CATALOG_TENANT_MAX_TAGDEFS_CONFIG);
    }

    public List<String> catalogDeleteTypeDefs() {
        return this.getList(CATALOG_DELETE_TYPEDEFS_CONFIG);
    }

    public List<String> catalogDeleteAttrDefs() {
        return this.getList(CATALOG_DELETE_ATTRDEFS_CONFIG);
    }

    public int catalogGraphQLMaxComplexity() {
        return this.getInt(CATALOG_GRAPHQL_MAX_COMPLEXITY_CONFIG);
    }

    public int catalogGraphQLMaxDepth() {
        return this.getInt(CATALOG_GRAPHQL_MAX_DEPTH_CONFIG);
    }

    public int catalogGraphQLTimeoutMs() {
        return this.getInt(CATALOG_GRAPHQL_TIMEOUT_MS_CONFIG);
    }

    public int getCatalogMaxLimitPerIteration() {
        return this.getInt(CATALOG_MAX_LIMIT_PER_ITERATION);
    }

    public int catalogGraphQLNumThreads() {
        return this.getInt(CATALOG_GRAPHQL_NUM_THREADS_CONFIG);
    }

    public boolean isCatalogIngestorEnabled() {
        return this.getBoolean(CATALOG_INGESTOR_ENABLE_CONFIG);
    }

    public int getCatalogIngestorBatchSize() {
        return this.getInt(CATALOG_INGESTOR_BATCH_SIZE_CONFIG);
    }

    public long getCatalogIngestorBatchTimeoutMs() {
        return this.getLong(CATALOG_INGESTOR_BATCH_TIMEOUT_MS_CONFIG);
    }

    public int getCatalogIngestorCacheMaxSize() {
        return this.getInt(CATALOG_INGESTOR_CACHE_MAX_SIZE_CONFIG);
    }

    public int getCatalogIngestorCacheTtlSec() {
        return this.getInt(CATALOG_INGESTOR_CACHE_TTL_SEC_CONFIG);
    }

    public boolean isCatalogReconciliationClusterEnabled() {
        return this.getBoolean(CATALOG_RECONCILIATION_CLUSTER_ENABLE_CONFIG);
    }

    public boolean isCatalogReconciliationTopicEnabled() {
        return this.getBoolean(CATALOG_RECONCILIATION_TOPIC_ENABLE_CONFIG);
    }

    public int getCatalogReconciliationCacheMaxSize() {
        return this.getInt(CATALOG_RECONCILIATION_CACHE_MAX_SIZE_CONFIG);
    }

    public int getCatalogReconciliationCacheTtlSec() {
        return this.getInt(CATALOG_RECONCILIATION_CACHE_TTL_SEC_CONFIG);
    }

    public boolean isCatalogEntityWriteApisEnabled() {
        return this.getBoolean(CATALOG_ENTITY_WRITE_APIS_ENABLE_CONFIG);
    }

    public List<String> catalogEntityModifiableAttrs() {
        return this.getList(CATALOG_ENTITY_MODIFIABLE_ATTRS_CONFIG);
    }

    public String catalogEntityModifiableAttrsPrefix() {
        return this.getString(CATALOG_ENTITY_MODIFIABLE_ATTRS_PREFIX_CONFIG);
    }

    public boolean isCatalogRbacEnabled() {
        return this.getBoolean(CATALOG_RBAC_ENABLE_CONFIG);
    }

    public String getRbacAuthorizerClassName() {
        return this.getString(CATALOG_RBAC_AUTHORIZER_CLASS_CONFIG);
    }

    public int catalogMaxRetries() {
        return this.getInt(CATALOG_MAX_RETRIES_CONFIG);
    }

    public int catalogRetriesWaitMs() {
        return this.getInt(CATALOG_RETRIES_WAIT_MS_CONFIG);
    }

    public boolean isCatalogNotificationsEnabled() {
        return this.getBoolean(CATALOG_NOTIFICATIONS_ENABLE_CONFIG);
    }

    public String getCatalogNotificationsDesignatedHostPrefix() {
        return this.getString(CATALOG_NOTIFICATIONS_DESIGNATED_HOST_PREFIX_CONFIG);
    }

    public String getCatalogNotificationsTopic() {
        return this.getString(CATALOG_NOTIFICATIONS_TOPIC);
    }

    public String getCatalogNotificationsHookTopic() {
        return this.getString(CATALOG_NOTIFICATIONS_HOOK_TOPIC);
    }

    public boolean useAtlasIndexQueryToFindEntityByUniqueAttr() {
        return this.getBoolean(CATALOG_USE_INDEX_QUERY_TO_FIND_ENTITY_BY_UNIQUE_ATTRIBUTES);
    }

    public boolean countTagsUseAtlasSearch() {
        return this.getBoolean(CATALOG_COUNT_TAGS_USE_SEARCH_CONFIG);
    }

    public boolean countTagsTestingEnabled() {
        return this.getBoolean(CATALOG_COUNT_TAGS_AB_TESTING_CONFIG);
    }

    public List<String> getCountTagsTenantsUseAtlasSearch() {
        return this.getList(CATALOG_COUNT_TAGS_TENANTS_USE_SEARCH_CONFIG);
    }

    public boolean countTagsPersistentCacheEnabled() {
        return this.getBoolean(CATALOG_COUNT_TAGS_PERSISTENT_CACHE_CONFIG);
    }

    public String getCatalogCacheDataDir() {
        return this.getString(CATALOG_CACHE_DATA_DIR_CONFIG);
    }
}

