/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog;

import com.google.inject.Injector;
import com.google.inject.Module;
import com.netflix.governator.InjectorBuilder;
import com.netflix.governator.LifecycleInjector;
import com.netflix.governator.LifecycleInjectorCreator;
import com.netflix.governator.spi.InjectorCreator;
import io.confluent.catalog.DataCatalogConfig;
import io.confluent.catalog.DataCatalogModule;
import io.confluent.catalog.client.autthorizer.CatalogAuthorizerClient;
import io.confluent.catalog.hook.SchemaAtlasHook;
import io.confluent.catalog.model.typedef.TagDef;
import io.confluent.catalog.storage.MetadataRegistry;
import io.confluent.catalog.util.QualifiedNameGenerator;
import io.confluent.catalog.web.errors.AtlasBaseExceptionMapper;
import io.confluent.catalog.web.errors.NotFoundExceptionMapper;
import io.confluent.catalog.web.filters.AtlasInitializationFilter;
import io.confluent.catalog.web.filters.AtlasMaxQueueSizeFilter;
import io.confluent.catalog.web.filters.CatalogRbacAuthorizationFilter;
import io.confluent.catalog.web.filters.CatalogRequestCleanupFilter;
import io.confluent.catalog.web.filters.CatalogRequestFilter;
import io.confluent.catalog.web.filters.CatalogResponseWriter;
import io.confluent.catalog.web.filters.MultiTenantAuthChecker;
import io.confluent.catalog.web.graphql.resources.GraphQLResource;
import io.confluent.catalog.web.rest.exceptions.RestInvalidTagException;
import io.confluent.catalog.web.rest.resources.CatalogResource;
import io.confluent.catalog.web.rest.resources.EntityResource;
import io.confluent.catalog.web.rest.resources.ExtendedEntityResource;
import io.confluent.catalog.web.rest.resources.SearchResource;
import io.confluent.catalog.web.rest.resources.TypesResource;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaTags;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.ConfigUpdateRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.TagSchemaRequest;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.rest.extensions.SchemaRegistryResourceExtension;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.Mode;
import io.confluent.kafka.schemaregistry.storage.RuleSet;
import io.confluent.kafka.schemaregistry.storage.RuleSetHandler;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import io.confluent.kafka.schemaregistry.utils.QualifiedSubject;
import io.confluent.rest.RestConfigException;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.Configurable;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasException;
import org.apache.atlas.authorize.AtlasAuthorizationException;
import org.apache.atlas.authorize.AtlasAuthorizer;
import org.apache.atlas.authorize.AtlasAuthorizerFactory;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.store.graph.AtlasEntityStore;
import org.apache.commons.configuration.Configuration;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataCatalogResourceExtension
extends RuleSetHandler
implements SchemaRegistryResourceExtension {
    private static final Logger LOG = LoggerFactory.getLogger(DataCatalogResourceExtension.class);
    public static final String ATLAS_HOME = "atlas.home";
    public static final String ATLAS_DATA = "atlas.data";
    protected KafkaSchemaRegistry schemaRegistry;
    protected LifecycleInjector injector;
    protected MetadataRegistry metadataRegistry;
    protected CatalogAuthorizerClient authorizerClient;

    public void register(Configurable<?> configurable, SchemaRegistryConfig schemaRegistryConfig, SchemaRegistry schemaRegistry) throws SchemaRegistryException {
        try {
            this.schemaRegistry = (KafkaSchemaRegistry)schemaRegistry;
            this.schemaRegistry.setRuleSetHandler((RuleSetHandler)this);
            DataCatalogConfig dataCatalogConfig = new DataCatalogConfig(schemaRegistryConfig.originalProperties());
            if (!dataCatalogConfig.isCatalogEnabled()) {
                return;
            }
            LOG.info("Registering catalog extension");
            DataCatalogResourceExtension.setApplicationHome(dataCatalogConfig);
            configurable.register(MultiPartFeature.class);
            configurable.register(AtlasBaseExceptionMapper.class);
            configurable.register(NotFoundExceptionMapper.class);
            Configuration config = ApplicationProperties.get();
            if (config == null) {
                LOG.error("Could not obtain application properties");
            }
            LOG.debug("registering injector");
            this.injector = (LifecycleInjector)InjectorBuilder.fromModules((Module[])new Module[]{new DataCatalogModule(schemaRegistry, dataCatalogConfig)}).createInjector((InjectorCreator)new LifecycleInjectorCreator());
            LOG.debug("done registering injector");
            this.metadataRegistry = (MetadataRegistry)this.injector.getInstance(MetadataRegistry.class);
            LOG.debug("registering filters");
            AtlasInitializationFilter initFilter = new AtlasInitializationFilter((Injector)this.injector);
            configurable.register((Object)initFilter);
            AtlasMaxQueueSizeFilter queueSizeFilter = new AtlasMaxQueueSizeFilter(schemaRegistry);
            configurable.register((Object)queueSizeFilter);
            MultiTenantAuthChecker multiTenantAuthChecker = new MultiTenantAuthChecker(schemaRegistryConfig);
            configurable.register((Object)new CatalogResponseWriter(schemaRegistry, multiTenantAuthChecker));
            LOG.debug("done registering filters");
            LOG.debug("registering rest classes");
            configurable.register(this.injector.getInstance(CatalogResource.class));
            configurable.register(this.injector.getInstance(EntityResource.class));
            configurable.register(this.injector.getInstance(SearchResource.class));
            configurable.register(this.injector.getInstance(TypesResource.class));
            configurable.register(this.injector.getInstance(GraphQLResource.class));
            if (dataCatalogConfig.isCatalogEntityWriteApisEnabled()) {
                configurable.register(this.injector.getInstance(ExtendedEntityResource.class));
            }
            LOG.debug("done registering rest classes");
            if (dataCatalogConfig.isCatalogRbacEnabled()) {
                String authorizerClassName = dataCatalogConfig.getRbacAuthorizerClassName();
                if (authorizerClassName.isEmpty()) {
                    LOG.error("Authorizer class name is not set");
                    throw new RestConfigException("Authorizer class name not set");
                }
                try {
                    Class<?> authorizerClientObject = Class.forName(authorizerClassName);
                    if (authorizerClientObject != null) {
                        this.authorizerClient = (CatalogAuthorizerClient)authorizerClientObject.newInstance();
                        this.authorizerClient.init(schemaRegistry);
                    }
                    AtlasAuthorizer authorizer = null;
                    try {
                        authorizer = AtlasAuthorizerFactory.getAtlasAuthorizer();
                    }
                    catch (AtlasAuthorizationException e) {
                        LOG.error("Unable to enable RBAC for CatalogRbacAuthorizationFilter", (Throwable)e);
                    }
                    if (authorizer != null) {
                        ((CatalogRbacAuthorizationFilter)authorizer).setRbacEnabled(true);
                        ((CatalogRbacAuthorizationFilter)authorizer).setAuthorizerRestClient(this.authorizerClient);
                        ((CatalogRbacAuthorizationFilter)authorizer).setSchemaRegistry((KafkaSchemaRegistry)schemaRegistry);
                        ((CatalogRbacAuthorizationFilter)authorizer).setEntityStore((AtlasEntityStore)this.injector.getInstance(AtlasEntityStore.class));
                    }
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    LOG.error("Unable to initiate authorizer client class", (Throwable)e);
                    return;
                }
                configurable.register((Object)new CatalogRequestFilter(schemaRegistry, this.injector, this.authorizerClient));
                configurable.register(CatalogRequestCleanupFilter.class);
                LOG.debug("Getting authorizer value =" + config.getProperty("atlas.authorizer.impl"));
            }
            LOG.debug("notifying hook");
            SchemaAtlasHook hook = (SchemaAtlasHook)schemaRegistry.properties().get("hook");
            hook.notifyReady((Injector)this.injector);
            LOG.debug("done notifying hook");
        }
        catch (RestConfigException | AtlasException e) {
            LOG.error("Error registering catalog extension", e);
            throw new SchemaRegistryException(e);
        }
        LOG.info("Done registering catalog extension");
    }

    public boolean initialized() {
        return this.metadataRegistry.initialized();
    }

    private static void setApplicationHome(DataCatalogConfig dataCatalogConfig) throws SchemaRegistryException {
        String atlasHome = dataCatalogConfig.atlasHome();
        if (atlasHome == null) {
            throw new SchemaRegistryException("Missing value for atlas.home");
        }
        System.setProperty(ATLAS_HOME, atlasHome);
        LOG.info("Using {}={}", (Object)ATLAS_HOME, (Object)atlasHome);
        int version = dataCatalogConfig.getInt("kafkastore.checkpoint.version");
        String atlasData = dataCatalogConfig.atlasData();
        if (atlasData == null) {
            throw new SchemaRegistryException("Missing value for atlas.data");
        }
        DataCatalogResourceExtension.removeOldVersions(atlasData, version);
        File dir = new File(atlasData, "catalog-" + version);
        System.setProperty(ATLAS_DATA, dir.toString());
        LOG.info("Using {}={}", (Object)ATLAS_DATA, (Object)dir.toString());
    }

    private static void removeOldVersions(String atlasData, int version) {
        for (int i = 0; i < version; ++i) {
            File oldDir = new File(atlasData, "catalog-" + i);
            if (!oldDir.exists() || DataCatalogResourceExtension.deleteDirectory(oldDir)) continue;
            LOG.warn("Could not delete old dir: {}", (Object)oldDir);
        }
    }

    private static boolean deleteDirectory(File directoryToBeDeleted) {
        File[] allContents = directoryToBeDeleted.listFiles();
        if (allContents != null) {
            for (File file : allContents) {
                DataCatalogResourceExtension.deleteDirectory(file);
            }
        }
        return directoryToBeDeleted.delete();
    }

    public void handle(String subject, ConfigUpdateRequest request) {
        try {
            HashSet<String> tags = new HashSet<String>();
            Metadata metadata = request.getDefaultMetadata();
            if (metadata != null && metadata.getTags() != null) {
                metadata.getTags().forEach((key, value) -> tags.addAll((Collection<String>)value));
            }
            if ((metadata = request.getOverrideMetadata()) != null && metadata.getTags() != null) {
                metadata.getTags().forEach((key, value) -> tags.addAll((Collection<String>)value));
            }
            String tenant = this.schemaRegistry.tenant();
            this.maybeCreateTagDefs(subject, tags, tenant);
        }
        catch (SchemaRegistryException schemaRegistryException) {
            // empty catch block
        }
    }

    public void handle(String subject, boolean normalize, RegisterSchemaRequest request) {
        try {
            boolean isNew;
            String tenant = this.schemaRegistry.tenant();
            subject = QualifiedSubject.normalize((String)tenant, (String)subject);
            Schema schema = new Schema(subject, request);
            boolean bl = isNew = schema.getId() < 0;
            if (!isNew) {
                return;
            }
            ParsedSchema parsedSchema = this.schemaRegistry.parseSchema(schema, false, normalize);
            this.maybeCreateTagDefs(subject, parsedSchema.tags(), tenant);
        }
        catch (SchemaRegistryException schemaRegistryException) {
            // empty catch block
        }
    }

    public void handle(Schema schema, TagSchemaRequest request) {
        try {
            String tenant = this.schemaRegistry.tenant();
            String subject = QualifiedSubject.normalize((String)tenant, (String)schema.getSubject());
            if (request.getTagsToAdd() != null && !request.getTagsToAdd().isEmpty()) {
                Set<String> tags = request.getTagsToAdd().stream().map(SchemaTags::getTags).flatMap(Collection::stream).collect(Collectors.toSet());
                this.maybeCreateTagDefs(subject, tags, tenant);
            }
            if (this.metadataRegistry == null) {
                return;
            }
            if (this.schemaRegistry.isLeader()) {
                String qualifiedSchemaName = QualifiedNameGenerator.getQualifiedName(tenant, QualifiedSubject.contextFor((String)tenant, (String)subject), schema.getId());
                if (request.getTagsToAdd() != null) {
                    request.getTagsToAdd().addAll(this.metadataRegistry.getCatalogTags(tenant, qualifiedSchemaName));
                } else {
                    request.setTagsToAdd(this.metadataRegistry.getCatalogTags(tenant, qualifiedSchemaName));
                }
            }
        }
        catch (SchemaRegistryException tenant) {
        }
        catch (AtlasBaseException e) {
            throw new RuntimeException("Can't find old schema tags in catalog due to", e);
        }
    }

    private void maybeCreateTagDefs(String subject, Set<String> tags, String tenant) throws SchemaRegistryException {
        if (this.metadataRegistry == null) {
            return;
        }
        Set<String> missingTags = this.metadataRegistry.checkTags(tenant, tags);
        if (!missingTags.isEmpty()) {
            if (this.schemaRegistry.getModeInScope(subject) == Mode.IMPORT) {
                if (this.schemaRegistry.isLeader()) {
                    List<TagDef> tagDefs = missingTags.stream().map(TagDef::new).collect(Collectors.toList());
                    this.metadataRegistry.createTagDefsOrForward(tenant, tagDefs, Collections.emptyMap());
                }
            } else {
                throw new RestInvalidTagException(missingTags);
            }
        }
    }

    public RuleSet transform(io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet ruleSet) {
        return ruleSet != null ? new RuleSet(ruleSet) : null;
    }

    public void close() throws IOException {
        if (this.metadataRegistry != null) {
            this.metadataRegistry.close();
            this.metadataRegistry = null;
        }
        if (this.injector != null) {
            LOG.info("Shutting down Atlas graph");
            try {
                AtlasGraph atlasGraph = (AtlasGraph)this.injector.getInstance(AtlasGraph.class);
                atlasGraph.shutdown();
            }
            catch (Exception exception) {
                // empty catch block
            }
            LOG.info("Done shutting down Atlas graph");
            this.injector.close();
            this.injector = null;
        }
    }
}

