/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.atlas.repository.graphdb.janus;

import java.lang.reflect.Field;
import java.util.Set;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusGraph;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusGraphManagement;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.core.schema.JanusGraphSchemaElement;
import org.janusgraph.graphdb.database.management.JanusGraphIndexWrapper;
import org.janusgraph.graphdb.database.management.ManagementSystem;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.janusgraph.graphdb.types.IndexType;
import org.janusgraph.graphdb.types.vertices.JanusGraphSchemaVertex;
import org.janusgraph.graphdb.types.vertices.RelationTypeVertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CfltAtlasJanusGraphManagement
extends AtlasJanusGraphManagement {
    private static final Logger LOG = LoggerFactory.getLogger(CfltAtlasJanusGraphManagement.class);
    private AtlasJanusGraph graph;
    private ManagementSystem management;

    public CfltAtlasJanusGraphManagement(AtlasJanusGraph graph, JanusGraphManagement managementSystem) {
        super(graph, managementSystem);
        this.management = (ManagementSystem)managementSystem;
        this.graph = graph;
    }

    public void deletePropertyKey(String propertyKey) {
        PropertyKey janusPropertyKey = this.management.getPropertyKey(propertyKey);
        if (null == janusPropertyKey) {
            return;
        }
        janusPropertyKey.remove();
        if (janusPropertyKey instanceof RelationTypeVertex) {
            RelationTypeVertex type = (RelationTypeVertex)janusPropertyKey;
            type.resetCache();
            this.addUpdatedType((JanusGraphSchemaVertex)type);
        }
        IndexType index = ManagementSystem.getGraphIndexDirect((String)"vertex_index", (StandardJanusGraphTx)this.management.getWrappedTx());
        index.resetCache();
        this.addUpdatedType(this.management.getSchemaVertex((JanusGraphSchemaElement)new JanusGraphIndexWrapper(index)));
    }

    private void addUpdatedType(JanusGraphSchemaVertex vertex) {
        try {
            Field field = ManagementSystem.class.getDeclaredField("updatedTypes");
            field.setAccessible(true);
            Set updatedTypes = (Set)field.get(this.management);
            updatedTypes.add(vertex);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

