/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.atlas.repository.graphdb.janus.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.function.BiPredicate;
import org.apache.atlas.repository.graphdb.AtlasEdge;
import org.apache.atlas.repository.graphdb.AtlasGraphQuery;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusEdge;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusGraph;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusVertex;
import org.apache.atlas.repository.graphdb.tinkerpop.query.NativeTinkerpopGraphQuery;
import org.apache.tinkerpop.gremlin.process.traversal.Compare;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.JanusGraphQuery;
import org.janusgraph.core.attribute.Contain;
import org.janusgraph.core.attribute.Text;
import org.janusgraph.graphdb.internal.ElementCategory;
import org.janusgraph.graphdb.query.JanusGraphPredicate;
import org.janusgraph.graphdb.query.JanusGraphPredicateUtils;
import org.janusgraph.graphdb.query.graph.GraphCentricQueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CfltNativeJanusGraphQuery
implements NativeTinkerpopGraphQuery<AtlasJanusVertex, AtlasJanusEdge> {
    private static final Logger LOG = LoggerFactory.getLogger(CfltNativeJanusGraphQuery.class);
    private AtlasJanusGraph graph;
    private JanusGraphQuery<?> query;

    public CfltNativeJanusGraphQuery(AtlasJanusGraph graph) {
        this.query = graph.getGraph().query();
        this.graph = graph;
    }

    public Iterable<AtlasVertex<AtlasJanusVertex, AtlasJanusEdge>> vertices() {
        Iterable it = this.query.vertices();
        return this.graph.wrapVertices(it);
    }

    public Iterable<AtlasEdge<AtlasJanusVertex, AtlasJanusEdge>> edges() {
        Iterable it = this.query.edges();
        return this.graph.wrapEdges(it);
    }

    public Iterable<AtlasEdge<AtlasJanusVertex, AtlasJanusEdge>> edges(int limit) {
        Iterable it = this.query.limit(limit).edges();
        if (LOG.isDebugEnabled()) {
            if (this.query instanceof GraphCentricQueryBuilder) {
                LOG.debug("NativeJanusGraphQuery.vertices({}): resultSize={}, {}", new Object[]{limit, this.getCountForDebugLog(it), ((GraphCentricQueryBuilder)this.query).constructQuery(ElementCategory.EDGE)});
            } else {
                LOG.debug("NativeJanusGraphQuery.vertices({}): resultSize={}, {}", new Object[]{limit, this.getCountForDebugLog(it), this.query});
            }
        }
        return this.graph.wrapEdges(it);
    }

    public Iterable<AtlasEdge<AtlasJanusVertex, AtlasJanusEdge>> edges(int offset, int limit) {
        ArrayList<Edge> result = new ArrayList<Edge>(limit);
        Iterable it = this.query.limit(offset + limit).edges();
        if (LOG.isDebugEnabled()) {
            if (this.query instanceof GraphCentricQueryBuilder) {
                LOG.debug("NativeJanusGraphQuery.vertices({}, {}): resultSize={}, {}", new Object[]{offset, limit, this.getCountForDebugLog(it), ((GraphCentricQueryBuilder)this.query).constructQuery(ElementCategory.EDGE)});
            } else {
                LOG.debug("NativeJanusGraphQuery.vertices({}, {}): resultSize={}, {}", new Object[]{offset, limit, this.getCountForDebugLog(it), this.query});
            }
        }
        Iterator iter = it.iterator();
        long resultIdx = 0L;
        while (iter.hasNext() && result.size() < limit) {
            Edge e = (Edge)iter.next();
            if (resultIdx >= (long)offset) {
                result.add(e);
            }
            ++resultIdx;
        }
        return this.graph.wrapEdges(result);
    }

    public Iterable<AtlasVertex<AtlasJanusVertex, AtlasJanusEdge>> vertices(int limit) {
        Iterable it = this.query.limit(limit).vertices();
        if (LOG.isDebugEnabled()) {
            if (this.query instanceof GraphCentricQueryBuilder) {
                LOG.debug("NativeJanusGraphQuery.vertices({}): resultSize={}, {}", new Object[]{limit, this.getCountForDebugLog(it), ((GraphCentricQueryBuilder)this.query).constructQuery(ElementCategory.VERTEX)});
            } else {
                LOG.debug("NativeJanusGraphQuery.vertices({}): resultSize={}, {}", new Object[]{limit, this.getCountForDebugLog(it), this.query});
            }
        }
        return this.graph.wrapVertices(it);
    }

    public Iterable<AtlasVertex<AtlasJanusVertex, AtlasJanusEdge>> vertices(int offset, int limit) {
        ArrayList<Vertex> result = new ArrayList<Vertex>(limit);
        Iterable it = this.query.limit(offset + limit).vertices();
        if (LOG.isDebugEnabled()) {
            if (this.query instanceof GraphCentricQueryBuilder) {
                LOG.debug("NativeJanusGraphQuery.vertices({}, {}): resultSize={}, {}", new Object[]{offset, limit, this.getCountForDebugLog(it), ((GraphCentricQueryBuilder)this.query).constructQuery(ElementCategory.VERTEX)});
            } else {
                LOG.debug("NativeJanusGraphQuery.vertices({}, {}): resultSize={}, {}", new Object[]{offset, limit, this.getCountForDebugLog(it), this.query});
            }
        }
        Iterator iter = it.iterator();
        long resultIdx = 0L;
        while (iter.hasNext() && result.size() < limit) {
            Vertex v = (Vertex)iter.next();
            if (resultIdx >= (long)offset) {
                result.add(v);
            }
            ++resultIdx;
        }
        return this.graph.wrapVertices(result);
    }

    public Iterable<Object> vertexIds() {
        HashSet<Object> result = new HashSet<Object>();
        Iterable it = this.query.vertices();
        Iterator iter = it.iterator();
        while (iter.hasNext()) {
            result.add(((Vertex)iter.next()).id());
        }
        return result;
    }

    public Iterable<Object> vertexIds(int limit) {
        HashSet<Object> result = new HashSet<Object>(limit);
        Iterable it = this.query.limit(limit).vertices();
        if (LOG.isDebugEnabled()) {
            if (this.query instanceof GraphCentricQueryBuilder) {
                LOG.debug("NativeJanusGraphQuery.vertices({}): resultSize={}, {}", new Object[]{limit, this.getCountForDebugLog(it), ((GraphCentricQueryBuilder)this.query).constructQuery(ElementCategory.VERTEX)});
            } else {
                LOG.debug("NativeJanusGraphQuery.vertices({}): resultSize={}, {}", new Object[]{limit, this.getCountForDebugLog(it), this.query});
            }
        }
        Iterator iter = it.iterator();
        while (iter.hasNext()) {
            result.add(((Vertex)iter.next()).id());
        }
        return result;
    }

    public Iterable<Object> vertexIds(int offset, int limit) {
        HashSet<Object> result = new HashSet<Object>(limit);
        Iterable it = this.query.limit(offset + limit).vertices();
        if (LOG.isDebugEnabled()) {
            if (this.query instanceof GraphCentricQueryBuilder) {
                LOG.debug("NativeJanusGraphQuery.vertices({}, {}): resultSize={}, {}", new Object[]{offset, limit, this.getCountForDebugLog(it), ((GraphCentricQueryBuilder)this.query).constructQuery(ElementCategory.VERTEX)});
            } else {
                LOG.debug("NativeJanusGraphQuery.vertices({}, {}): resultSize={}, {}", new Object[]{offset, limit, this.getCountForDebugLog(it), this.query});
            }
        }
        Iterator iter = it.iterator();
        long resultIdx = 0L;
        while (iter.hasNext() && result.size() < limit) {
            if (resultIdx >= (long)offset) {
                result.add(((Vertex)iter.next()).id());
            }
            ++resultIdx;
        }
        return result;
    }

    public void in(String propertyName, Collection<? extends Object> values) {
        this.query.has(propertyName, (JanusGraphPredicate)Contain.IN, values);
    }

    public void has(String propertyName, AtlasGraphQuery.QueryOperator op, Object value) {
        Text pred;
        if (op instanceof AtlasGraphQuery.ComparisionOperator) {
            Compare c = this.getGremlinPredicate((AtlasGraphQuery.ComparisionOperator)op);
            pred = JanusGraphPredicateUtils.convert((BiPredicate)c);
        } else {
            pred = this.getGremlinPredicate((AtlasGraphQuery.MatchingOperator)op);
        }
        this.query.has(propertyName, (JanusGraphPredicate)pred, value);
    }

    public void orderBy(String propertyName, AtlasGraphQuery.SortOrder sortOrder) {
        Order order = sortOrder == AtlasGraphQuery.SortOrder.ASC ? Order.asc : Order.desc;
        this.query.orderBy(propertyName, order);
    }

    private Text getGremlinPredicate(AtlasGraphQuery.MatchingOperator op) {
        switch (op) {
            case CONTAINS: {
                return Text.CONTAINS;
            }
            case PREFIX: {
                return Text.PREFIX;
            }
            case SUFFIX: {
                return Text.CONTAINS_REGEX;
            }
            case REGEX: {
                return Text.REGEX;
            }
        }
        throw new RuntimeException("Unsupported matching operator:" + op);
    }

    private Compare getGremlinPredicate(AtlasGraphQuery.ComparisionOperator op) {
        switch (op) {
            case EQUAL: {
                return Compare.eq;
            }
            case GREATER_THAN: {
                return Compare.gt;
            }
            case GREATER_THAN_EQUAL: {
                return Compare.gte;
            }
            case LESS_THAN: {
                return Compare.lt;
            }
            case LESS_THAN_EQUAL: {
                return Compare.lte;
            }
            case NOT_EQUAL: {
                return Compare.neq;
            }
        }
        throw new RuntimeException("Unsupported comparison operator:" + op);
    }

    private int getCountForDebugLog(Iterable it) {
        int ret = 0;
        if (LOG.isDebugEnabled() && it != null) {
            Iterator iter = it.iterator();
            while (iter.hasNext()) {
                ++ret;
                iter.next();
            }
        }
        return ret;
    }
}

