/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.atlas.repository.store.graph.v2;

import io.confluent.catalog.atlas.repository.store.graph.v2.CfltAtlasTypeDefGraphStoreV2;
import javax.inject.Inject;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.authorize.AtlasAuthorizationUtils;
import org.apache.atlas.authorize.AtlasPrivilege;
import org.apache.atlas.authorize.AtlasTypeAccessRequest;
import org.apache.atlas.discovery.EntityDiscoveryService;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.model.typedef.AtlasBusinessMetadataDef;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.v2.AtlasBusinessMetadataDefStoreV2;
import org.apache.atlas.repository.store.graph.v2.AtlasTypeDefGraphStoreV2;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.typesystem.types.DataTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CfltAtlasBusinessMetadataDefStoreV2
extends AtlasBusinessMetadataDefStoreV2 {
    private static final Logger LOG = LoggerFactory.getLogger(CfltAtlasBusinessMetadataDefStoreV2.class);

    @Inject
    public CfltAtlasBusinessMetadataDefStoreV2(AtlasTypeDefGraphStoreV2 typeDefStore, AtlasTypeRegistry typeRegistry, EntityDiscoveryService entityDiscoveryService) {
        super(typeDefStore, typeRegistry, entityDiscoveryService);
    }

    public AtlasVertex preDeleteByName(String name) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasBusinessMetadataDefStoreV2.preDeleteByName({})", (Object)name);
        }
        AtlasBusinessMetadataDef existingDef = this.typeRegistry.getBusinessMetadataDefByName(name);
        AtlasAuthorizationUtils.verifyAccess((AtlasTypeAccessRequest)new AtlasTypeAccessRequest(AtlasPrivilege.TYPE_DELETE, (AtlasBaseTypeDef)existingDef), (Object[])new Object[]{"delete businessMetadata-def ", name});
        AtlasVertex ret = ((CfltAtlasTypeDefGraphStoreV2)this.typeDefStore).findTypeVertexByNameAndCategory(name, DataTypes.TypeCategory.BUSINESS_METADATA);
        if (ret == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_NOT_FOUND, new String[]{name});
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasBusinessMetadataDefStoreV2.preDeleteByName({}): {}", (Object)name, (Object)ret);
        }
        return ret;
    }

    public AtlasVertex preDeleteByGuid(String guid) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasBusinessMetadataDefStoreV2.preDeleteByGuid({})", (Object)guid);
        }
        AtlasBusinessMetadataDef existingDef = this.typeRegistry.getBusinessMetadataDefByGuid(guid);
        AtlasAuthorizationUtils.verifyAccess((AtlasTypeAccessRequest)new AtlasTypeAccessRequest(AtlasPrivilege.TYPE_DELETE, (AtlasBaseTypeDef)existingDef), (Object[])new Object[]{"delete businessMetadata-def ", existingDef != null ? existingDef.getName() : guid});
        AtlasVertex ret = ((CfltAtlasTypeDefGraphStoreV2)this.typeDefStore).findTypeVertexByGuidAndCategory(guid, DataTypes.TypeCategory.BUSINESS_METADATA);
        if (ret == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_GUID_NOT_FOUND, new String[]{guid});
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasBusinessMetadataDefStoreV2.preDeleteByGuid({}): ret={}", (Object)guid, (Object)ret);
        }
        return ret;
    }
}

