/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.hook;

import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.internal.parser.EnumElement;
import com.squareup.wire.schema.internal.parser.FieldElement;
import com.squareup.wire.schema.internal.parser.MessageElement;
import com.squareup.wire.schema.internal.parser.OptionElement;
import com.squareup.wire.schema.internal.parser.ProtoFileElement;
import com.squareup.wire.schema.internal.parser.TypeElement;
import io.confluent.catalog.hook.SchemaAtlasHook;
import io.confluent.catalog.hook.SchemaAtlasTypes;
import io.confluent.catalog.hook.SchemaOperationContext;
import io.confluent.catalog.model.instance.Tag;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.type.AtlasTypeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtobufSchemaAtlasHook {
    private static final Logger LOG = LoggerFactory.getLogger(ProtobufSchemaAtlasHook.class);

    public AtlasEntity createSchema(SchemaOperationContext ctx, int id, ProtoFileElement schema) {
        String qualifiedName = ctx.getQualifiedName(id);
        AtlasEntity entity = ctx.getEntity(qualifiedName);
        if (entity != null) {
            return entity;
        }
        entity = new AtlasEntity(SchemaAtlasTypes.SR_SCHEMA.getName());
        SchemaAtlasHook.setDefaultAttrs(ctx, entity, qualifiedName, id, "");
        entity.setAttribute("namespace", (Object)schema.getPackageName());
        entity.setAttribute("schemaType", (Object)"PROTOBUF");
        this.setMeta(ctx, entity, "confluent.file_meta", schema.getOptions());
        List<AtlasEntity> typeEntities = this.createTypes(ctx, ".", id, schema.getTypes());
        entity.setRelationshipAttribute("types", (Object)AtlasTypeUtil.toAtlasRelatedObjectIds(typeEntities));
        for (AtlasEntity typeEntity : typeEntities) {
            typeEntity.setRelationshipAttribute("schema", (Object)AtlasTypeUtil.toAtlasRelatedObjectId((AtlasEntity)entity));
        }
        ctx.createOrUpdate(entity);
        return entity;
    }

    private void setMeta(SchemaOperationContext ctx, AtlasEntity entity, String optionName, List<OptionElement> options) {
        ProtobufSchema.ProtobufMeta meta = ProtobufSchema.findMeta((String)optionName, options);
        if (meta != null) {
            if (meta.getDoc() != null) {
                entity.setAttribute("doc", (Object)meta.getDoc());
            }
            if (meta.getTags() != null) {
                entity.setClassifications(meta.getTags().stream().map(t -> new Tag(ctx.getTenant(), (String)t)).collect(Collectors.toList()));
            }
        }
    }

    private List<AtlasEntity> createTypes(SchemaOperationContext ctx, String scope, int id, List<TypeElement> types) {
        ArrayList<AtlasEntity> typeEntities = new ArrayList<AtlasEntity>();
        for (TypeElement type : types) {
            AtlasEntity typeEntity = null;
            if (type instanceof MessageElement) {
                typeEntity = this.createMessage(ctx, scope, id, (MessageElement)type);
            } else if (type instanceof EnumElement) {
                typeEntity = this.createEnum(ctx, scope, id, (EnumElement)type);
            }
            if (typeEntity == null) continue;
            typeEntities.add(typeEntity);
        }
        return typeEntities;
    }

    private AtlasEntity createMessage(SchemaOperationContext ctx, String scope, int id, MessageElement message) {
        String scopedName = scope + message.getName();
        String qualifiedName = ctx.getQualifiedName(id, scopedName);
        AtlasEntity entity = ctx.getEntity(qualifiedName);
        if (entity != null) {
            return entity;
        }
        entity = new AtlasEntity(SchemaAtlasTypes.SR_RECORD.getName());
        SchemaAtlasHook.setDefaultAttrs(ctx, entity, qualifiedName, id, message.getName());
        this.setMeta(ctx, entity, "confluent.message_meta", message.getOptions());
        List<AtlasEntity> typeEntities = this.createTypes(ctx, scopedName + ".", id, message.getNestedTypes());
        entity.setRelationshipAttribute("child_types", (Object)AtlasTypeUtil.toAtlasRelatedObjectIds(typeEntities));
        for (AtlasEntity typeEntity : typeEntities) {
            typeEntity.setRelationshipAttribute("parent_type", (Object)AtlasTypeUtil.toAtlasRelatedObjectId((AtlasEntity)entity));
        }
        List unions = message.getOneOfs().stream().flatMap(oneof -> oneof.getFields().stream().map(f -> this.createField(ctx, scopedName + "." + oneof.getName() + ".", id, (FieldElement)f, true))).collect(Collectors.toList());
        List fields = message.getFields().stream().map(f -> this.createField(ctx, scopedName + ".", id, (FieldElement)f, false)).collect(Collectors.toList());
        ArrayList allFields = new ArrayList(unions.size() + fields.size());
        allFields.addAll(unions);
        allFields.addAll(fields);
        entity.setRelationshipAttribute("fields", (Object)AtlasTypeUtil.toAtlasRelatedObjectIds(allFields));
        for (AtlasEntity field : allFields) {
            field.setRelationshipAttribute("record", (Object)AtlasTypeUtil.toAtlasRelatedObjectId((AtlasEntity)entity));
        }
        ctx.createOrUpdate(entity);
        return entity;
    }

    private AtlasEntity createField(SchemaOperationContext ctx, String scope, int id, FieldElement field, boolean isOneof) {
        String scopedName = scope + field.getName();
        String qualifiedName = ctx.getQualifiedName(id, scopedName);
        AtlasEntity entity = ctx.getEntity(qualifiedName);
        if (entity != null) {
            return entity;
        }
        entity = new AtlasEntity(SchemaAtlasTypes.SR_FIELD.getName());
        SchemaAtlasHook.setDefaultAttrs(ctx, entity, qualifiedName, id, field.getName());
        if (field.getDefaultValue() != null) {
            entity.setAttribute("default", (Object)field.getDefaultValue());
        }
        entity.setAttribute("tag", (Object)field.getTag());
        if (isOneof) {
            entity.setAttribute("label", (Object)"oneof");
        }
        this.setMeta(ctx, entity, "confluent.field_meta", field.getOptions());
        AtlasEntity type = this.createType(ctx, id, field.getLabel(), ProtoType.get((String)field.getType()));
        entity.setRelationshipAttribute("type", (Object)AtlasTypeUtil.toAtlasRelatedObjectId((AtlasEntity)type));
        type.setRelationshipAttribute("field", (Object)AtlasTypeUtil.toAtlasRelatedObjectId((AtlasEntity)entity));
        ctx.createOrUpdate(entity);
        return entity;
    }

    private AtlasEntity createType(SchemaOperationContext ctx, int id, Field.Label label, ProtoType type) {
        String qualifiedName = ctx.getQualifiedName(id, type.toString());
        AtlasEntity entity = ctx.getEntity(qualifiedName);
        if (entity != null) {
            return entity;
        }
        if (label == Field.Label.REPEATED) {
            return this.createArray(ctx, id, type);
        }
        if (type.isMap()) {
            return this.createMap(ctx, id, type.getKeyType(), type.getValueType());
        }
        String entityType = type.isScalar() ? SchemaAtlasTypes.SR_PRIMITIVE.getName() : SchemaAtlasTypes.SR_TYPE.getName();
        entity = new AtlasEntity(entityType);
        SchemaAtlasHook.setDefaultAttrs(ctx, entity, qualifiedName, id, "");
        entity.setAttribute("type", (Object)type.toString());
        ctx.createOrUpdate(entity);
        return entity;
    }

    private AtlasEntity createEnum(SchemaOperationContext ctx, String scope, int id, EnumElement enumElem) {
        String scopedName = scope + enumElem.getName();
        String qualifiedName = ctx.getQualifiedName(id, scopedName);
        AtlasEntity entity = ctx.getEntity(qualifiedName);
        if (entity != null) {
            return entity;
        }
        entity = new AtlasEntity(SchemaAtlasTypes.SR_ENUM.getName());
        SchemaAtlasHook.setDefaultAttrs(ctx, entity, qualifiedName, id, enumElem.getName());
        this.setMeta(ctx, entity, "confluent.enum_meta", enumElem.getOptions());
        entity.setAttribute("symbols", enumElem.getConstants().stream().map(c -> c.getName()).collect(Collectors.toList()));
        ctx.createOrUpdate(entity);
        return entity;
    }

    private AtlasEntity createArray(SchemaOperationContext ctx, int id, ProtoType type) {
        String name = "array<" + type + ">";
        String qualifiedName = ctx.getQualifiedName(id, name);
        AtlasEntity entity = ctx.getEntity(qualifiedName);
        if (entity != null) {
            return entity;
        }
        entity = new AtlasEntity(SchemaAtlasTypes.SR_ARRAY.getName());
        SchemaAtlasHook.setDefaultAttrs(ctx, entity, qualifiedName, id, "");
        AtlasEntity typeEntity = this.createType(ctx, id, null, type);
        entity.setRelationshipAttribute("type", (Object)AtlasTypeUtil.toAtlasRelatedObjectId((AtlasEntity)typeEntity));
        typeEntity.setRelationshipAttribute("array", (Object)AtlasTypeUtil.toAtlasRelatedObjectId((AtlasEntity)entity));
        ctx.createOrUpdate(entity);
        return entity;
    }

    private AtlasEntity createMap(SchemaOperationContext ctx, int id, ProtoType keyType, ProtoType valueType) {
        String name = "map<" + keyType + "," + valueType + ">";
        String qualifiedName = ctx.getQualifiedName(id, name);
        AtlasEntity entity = ctx.getEntity(qualifiedName);
        if (entity != null) {
            return entity;
        }
        entity = new AtlasEntity(SchemaAtlasTypes.SR_MAP.getName());
        SchemaAtlasHook.setDefaultAttrs(ctx, entity, qualifiedName, id, "");
        AtlasEntity keyTypeEntity = this.createType(ctx, id, null, keyType);
        entity.setRelationshipAttribute("keyType", (Object)AtlasTypeUtil.toAtlasRelatedObjectId((AtlasEntity)keyTypeEntity));
        keyTypeEntity.setRelationshipAttribute("mapKey", (Object)AtlasTypeUtil.toAtlasRelatedObjectId((AtlasEntity)entity));
        AtlasEntity valueTypeEntity = this.createType(ctx, id, null, valueType);
        entity.setRelationshipAttribute("valueType", (Object)AtlasTypeUtil.toAtlasRelatedObjectId((AtlasEntity)valueTypeEntity));
        valueTypeEntity.setRelationshipAttribute("mapValue", (Object)AtlasTypeUtil.toAtlasRelatedObjectId((AtlasEntity)entity));
        ctx.createOrUpdate(entity);
        return entity;
    }

    public void deleteSchema(SchemaOperationContext ctx, int id, ProtoFileElement schema, boolean purge) {
        String qualifiedName = ctx.getQualifiedName(id);
        AtlasObjectId entityId = new AtlasObjectId(SchemaAtlasTypes.SR_SCHEMA.getName(), "qualifiedName", (Object)qualifiedName);
        this.deleteTypes(ctx, ".", id, schema.getTypes(), purge);
        if (purge) {
            ctx.purge(entityId);
        } else {
            ctx.delete(entityId);
        }
    }

    private void deleteTypes(SchemaOperationContext ctx, String scope, int id, List<TypeElement> types, boolean purge) {
        for (TypeElement type : types) {
            if (type instanceof MessageElement) {
                this.deleteMessage(ctx, scope, id, (MessageElement)type, purge);
                continue;
            }
            if (!(type instanceof EnumElement)) continue;
            this.deleteEnum(ctx, scope, id, (EnumElement)type, purge);
        }
    }

    private void deleteMessage(SchemaOperationContext ctx, String scope, int id, MessageElement message, boolean purge) {
        String scopedName = scope + message.getName();
        String qualifiedName = ctx.getQualifiedName(id, scopedName);
        if (ctx.isDeleted(qualifiedName)) {
            return;
        }
        AtlasObjectId entityId = new AtlasObjectId(SchemaAtlasTypes.SR_RECORD.getName(), "qualifiedName", (Object)qualifiedName);
        ctx.addDeleted(qualifiedName);
        this.deleteTypes(ctx, scopedName + ".", id, message.getNestedTypes(), purge);
        message.getOneOfs().forEach(oneof -> oneof.getFields().forEach(f -> this.deleteField(ctx, scopedName + "." + oneof.getName() + ".", id, (FieldElement)f, true, purge)));
        message.getFields().forEach(f -> this.deleteField(ctx, scopedName + ".", id, (FieldElement)f, false, purge));
        if (purge) {
            ctx.purge(entityId);
        } else {
            ctx.delete(entityId);
        }
    }

    private void deleteField(SchemaOperationContext ctx, String scope, int id, FieldElement field, boolean isOneof, boolean purge) {
        String scopedName = scope + field.getName();
        String qualifiedName = ctx.getQualifiedName(id, scopedName);
        AtlasObjectId entityId = new AtlasObjectId(SchemaAtlasTypes.SR_FIELD.getName(), "qualifiedName", (Object)qualifiedName);
        this.deleteType(ctx, id, field.getLabel(), ProtoType.get((String)field.getType()), purge);
        if (purge) {
            ctx.purge(entityId);
        } else {
            ctx.delete(entityId);
        }
    }

    private void deleteType(SchemaOperationContext ctx, int id, Field.Label label, ProtoType type, boolean purge) {
        String qualifiedName = ctx.getQualifiedName(id, type.toString());
        String entityType = type.isScalar() ? SchemaAtlasTypes.SR_PRIMITIVE.getName() : SchemaAtlasTypes.SR_TYPE.getName();
        AtlasObjectId entityId = new AtlasObjectId(entityType, "qualifiedName", (Object)qualifiedName);
        if (label == Field.Label.REPEATED) {
            this.deleteArray(ctx, id, type, purge);
        } else if (type.isMap()) {
            this.deleteMap(ctx, id, type.getKeyType(), type.getValueType(), purge);
        }
        if (purge) {
            ctx.purge(entityId);
        } else {
            ctx.delete(entityId);
        }
    }

    private void deleteEnum(SchemaOperationContext ctx, String scope, int id, EnumElement enumElem, boolean purge) {
        String scopedName = scope + enumElem.getName();
        String qualifiedName = ctx.getQualifiedName(id, scopedName);
        AtlasObjectId entityId = new AtlasObjectId(SchemaAtlasTypes.SR_ENUM.getName(), "qualifiedName", (Object)qualifiedName);
        this.deleteTypes(ctx, scopedName + ".", id, enumElem.getNestedTypes(), purge);
        if (purge) {
            ctx.purge(entityId);
        } else {
            ctx.delete(entityId);
        }
    }

    private void deleteArray(SchemaOperationContext ctx, int id, ProtoType type, boolean purge) {
        String name = "array<" + type + ">";
        String qualifiedName = ctx.getQualifiedName(id, name);
        AtlasObjectId entityId = new AtlasObjectId(SchemaAtlasTypes.SR_ARRAY.getName(), "qualifiedName", (Object)qualifiedName);
        this.deleteType(ctx, id, null, type, purge);
        if (purge) {
            ctx.purge(entityId);
        } else {
            ctx.delete(entityId);
        }
    }

    private void deleteMap(SchemaOperationContext ctx, int id, ProtoType keyType, ProtoType valueType, boolean purge) {
        String name = "map<" + keyType + "," + valueType + ">";
        String qualifiedName = ctx.getQualifiedName(id, name);
        AtlasObjectId entityId = new AtlasObjectId(SchemaAtlasTypes.SR_MAP.getName(), "qualifiedName", (Object)qualifiedName);
        this.deleteType(ctx, id, null, keyType, purge);
        this.deleteType(ctx, id, null, valueType, purge);
        if (purge) {
            ctx.purge(entityId);
        } else {
            ctx.delete(entityId);
        }
    }
}

