/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.hook;

import io.confluent.catalog.util.QualifiedNameGenerator;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryValue;
import io.confluent.kafka.schemaregistry.storage.SubjectKey;
import io.confluent.kafka.schemaregistry.utils.QualifiedSubject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.kafka.common.TopicPartition;

public class SchemaOperationContext {
    private final KafkaSchemaRegistry schemaRegistry;
    private final QualifiedSubject qs;
    private final SubjectKey key;
    private final SchemaRegistryValue value;
    private final SchemaRegistryValue oldValue;
    private final TopicPartition tp;
    private final long offset;
    private final long timestamp;
    private Set<String> embeddedTags = Collections.emptySet();
    private Integer newVersion;
    private int nameIndex = 0;
    private final Map<String, AtlasEntity> createdEntities = new HashMap<String, AtlasEntity>();
    private final Set<String> deletedEntities = new HashSet<String>();
    private final List<AtlasEntity> upserts = new ArrayList<AtlasEntity>();
    private final Map<AtlasObjectId, AtlasEntity> updates = new HashMap<AtlasObjectId, AtlasEntity>();
    private final Set<AtlasObjectId> deletes = new HashSet<AtlasObjectId>();
    private final Set<AtlasObjectId> purges = new HashSet<AtlasObjectId>();

    public SchemaOperationContext(KafkaSchemaRegistry schemaRegistry, SubjectKey key, SchemaRegistryValue value, SchemaRegistryValue oldValue, TopicPartition tp, long offset, long timestamp) {
        this.schemaRegistry = schemaRegistry;
        this.qs = QualifiedSubject.create((String)schemaRegistry.tenant(), (String)key.getSubject());
        this.key = key;
        this.value = value;
        this.oldValue = oldValue;
        this.tp = tp;
        this.offset = offset;
        this.timestamp = timestamp;
    }

    public QualifiedSubject getQualifiedSubject() {
        return this.qs;
    }

    public String getTenant() {
        return this.qs.getTenant();
    }

    public String getContext() {
        return this.qs.getContext();
    }

    public String getSubject() {
        return this.qs.getSubject();
    }

    public SubjectKey getKey() {
        return this.key;
    }

    public SchemaRegistryValue getValue() {
        return this.value;
    }

    public SchemaRegistryValue getOldValue() {
        return this.oldValue;
    }

    public TopicPartition getTopicPartition() {
        return this.tp;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Set<String> getEmbeddedTags() {
        return this.embeddedTags;
    }

    public void setEmbeddedTags(Set<String> embeddedTags) {
        this.embeddedTags = embeddedTags;
    }

    public Integer getNewVersion() {
        return this.newVersion;
    }

    public void setNewVersion(int newVersion) {
        this.newVersion = newVersion;
    }

    public String getQualifiedName(Object ... parts) {
        ArrayList<Object> newParts = new ArrayList<Object>();
        newParts.add(this.getTenant());
        newParts.add(this.getContext());
        for (Object part : parts) {
            newParts.add(part);
        }
        return QualifiedNameGenerator.getQualifiedName(newParts.toArray());
    }

    public int incrementNameIndex() {
        return ++this.nameIndex;
    }

    public AtlasEntity getEntity(String qualifiedName) {
        return this.createdEntities.get(qualifiedName);
    }

    public void addEntity(String qualifiedName, AtlasEntity entity) {
        this.createdEntities.put(qualifiedName, entity);
    }

    public boolean isDeleted(String qualifiedName) {
        return this.deletedEntities.contains(qualifiedName);
    }

    public void addDeleted(String qualifiedName) {
        this.deletedEntities.add(qualifiedName);
    }

    public boolean isEmpty() {
        return this.createdEntities.isEmpty() && this.deletedEntities.isEmpty() && this.upserts.isEmpty() && this.updates.isEmpty() && this.deletes.isEmpty() && this.purges.isEmpty();
    }

    public List<AtlasEntity> getEntitiesToCreateOrUpdate() {
        return this.upserts;
    }

    public Map<AtlasObjectId, AtlasEntity> getEntitiesToPartiallyUpdate() {
        return this.updates;
    }

    public Set<AtlasObjectId> getEntitiesToDelete() {
        return this.deletes;
    }

    public Set<AtlasObjectId> getEntitiesToPurge() {
        return this.purges;
    }

    public void createOrUpdate(AtlasEntity entity) {
        this.upserts.add(entity);
    }

    public void partiallyUpdate(AtlasObjectId entityId, AtlasEntity entity) {
        this.updates.put(entityId, entity);
    }

    public void delete(AtlasObjectId entityId) {
        this.deletes.add(entityId);
    }

    public void purge(AtlasObjectId entityId) {
        this.purges.add(entityId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaOperationContext that = (SchemaOperationContext)o;
        return this.timestamp == that.timestamp && Objects.equals(this.qs, that.qs) && Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value) && Objects.equals(this.oldValue, that.oldValue) && Objects.equals(this.upserts, that.upserts) && Objects.equals(this.updates, that.updates) && Objects.equals(this.deletes, that.deletes) && Objects.equals(this.purges, that.purges);
    }

    public int hashCode() {
        return Objects.hash(this.qs, this.key, this.value, this.oldValue, this.timestamp, this.upserts, this.updates, this.deletes, this.purges);
    }

    public String toString() {
        return "SchemaOperationContext{qualifiedSubject='" + this.qs + '\'' + ", key=" + this.key + ", value=" + this.value + ", oldValue=" + this.oldValue + ", timestamp=" + this.timestamp + ", upserts=" + this.upserts + ", updates=" + this.updates + ", deletes=" + this.deletes + ", purges=" + this.purges + '}';
    }
}

