/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.hook;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import io.confluent.catalog.DataCatalogConfig;
import io.confluent.catalog.hook.SchemaAtlasHook;
import io.confluent.catalog.model.typedef.TagDef;
import io.confluent.catalog.storage.MetadataRegistry;
import io.confluent.rest.RestConfigException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.atlas.RequestContext;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.model.typedef.AtlasClassificationDef;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.repository.store.bootstrap.AtlasTypeDefStoreInitializer;
import org.apache.atlas.store.AtlasTypeDefStore;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Singleton
@Service
public class TypeDefStoreLoader {
    private static final Logger LOG = LoggerFactory.getLogger(TypeDefStoreLoader.class);
    private MetadataRegistry metadataRegistry;
    private AtlasTypeDefStore typeDefStore;
    private AtlasTypeRegistry typeRegistry;
    private List<String> typeDefsToDelete;
    private List<String> attrDefsToDelete;
    private volatile AtlasTypeDefStoreInitializer storeInitializer;
    private final Boolean updateTagDefDefaultColor;
    private final String tagColorToUpdate;

    @Inject
    public TypeDefStoreLoader(MetadataRegistry metadataRegistry, AtlasTypeDefStore typeDefStore, AtlasTypeRegistry typeRegistry) {
        try {
            this.metadataRegistry = metadataRegistry;
            this.typeDefStore = typeDefStore;
            this.typeRegistry = typeRegistry;
            DataCatalogConfig dataCatalogConfig = new DataCatalogConfig(metadataRegistry.getSchemaRegistry().config().originalProperties());
            this.updateTagDefDefaultColor = dataCatalogConfig.getBoolean("catalog.tagdef.update.to.default.color");
            this.tagColorToUpdate = dataCatalogConfig.getString("catalog.tagdef.update.color");
            this.typeDefsToDelete = dataCatalogConfig.catalogDeleteTypeDefs();
            this.attrDefsToDelete = dataCatalogConfig.catalogDeleteAttrDefs();
        }
        catch (RestConfigException e) {
            throw new IllegalArgumentException("Could not instantiate TypeDefStoreLoader", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initTypeDefStore(Injector injector) {
        if (this.storeInitializer == null) {
            TypeDefStoreLoader typeDefStoreLoader = this;
            synchronized (typeDefStoreLoader) {
                if (this.storeInitializer == null) {
                    LOG.info("Registering typedef store");
                    this.storeInitializer = (AtlasTypeDefStoreInitializer)injector.getInstance(AtlasTypeDefStoreInitializer.class);
                    Thread thread = new Thread(() -> {
                        LOG.info("Deleting legacy type/attr defs");
                        if (this.updateTagDefDefaultColor.booleanValue()) {
                            this.updateTagDefDefaultColor(this.tagColorToUpdate);
                        }
                        this.deleteLegacyTypeDefs();
                        this.deleteLegacyAttrDefs();
                        LOG.info("Done deleting legacy type/attr defs");
                    });
                    thread.start();
                    LOG.info("Done registering typedef store");
                    this.initMetadataRegistry();
                }
            }
        }
    }

    private void updateTagDefDefaultColor(String tagColorToUpdate) {
        LOG.info("Updating tag colors to DEFAULT_COLOR with retry logic");
        try {
            TagDef.TagColor.valueOf(tagColorToUpdate);
        }
        catch (IllegalArgumentException e) {
            LOG.error("Cannot update tag def color from {} to DEFAULT_COLOR. Invalid color passed in {}", (Object)tagColorToUpdate, (Object)"catalog.tagdef.update.color");
        }
        Collection tagDefs = this.typeRegistry.getAllClassificationDefs();
        ArrayList<AtlasTypesDef> retryDefs = new ArrayList<AtlasTypesDef>();
        for (AtlasClassificationDef tagDef : tagDefs) {
            if (!tagDef.hasAttribute("__color") || !tagColorToUpdate.equalsIgnoreCase(tagDef.getAttribute("__color").getDefaultValue())) continue;
            AtlasClassificationDef updatedTagDef = new AtlasClassificationDef(tagDef);
            updatedTagDef.setEntityTypes(tagDef.getEntityTypes());
            updatedTagDef.setTypeVersion(MetadataRegistry.incrementVersion(tagDef.getTypeVersion()));
            AtlasStructDef.AtlasAttributeDef attributeDef = new AtlasStructDef.AtlasAttributeDef("__color", "string");
            attributeDef.setIsOptional(true);
            attributeDef.setDefaultValue(TagDef.TagColor.DEFAULT_COLOR.name());
            updatedTagDef.addAttribute(attributeDef);
            AtlasTypesDef typesDef = new AtlasTypesDef();
            typesDef.setClassificationDefs(Collections.singletonList(updatedTagDef));
            try {
                LOG.info("Updating TagDef color for tag {}", (Object)tagDef.getName());
                this.typeDefStore.updateTypesDef(typesDef);
            }
            catch (Exception e) {
                LOG.error("Unable to modify color from {} to DEFAULT_COLOR for TagDef {}, failed due to Exception", new Object[]{tagColorToUpdate, tagDef.getName(), e});
                retryDefs.add(typesDef);
            }
        }
        if (!retryDefs.isEmpty()) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                LOG.error("Retry sleep interrupted");
            }
            for (AtlasTypesDef typesDef : retryDefs) {
                try {
                    LOG.info("Retry : Updating TagDef color for tag {}", (Object)((AtlasClassificationDef)typesDef.getClassificationDefs().get(0)).getName());
                    this.typeDefStore.updateTypesDef(typesDef);
                }
                catch (Exception e) {
                    LOG.warn("Retry : Unable to modify color from {} to DEFAULT_COLOR for TagDef {}, failed due to Exception", new Object[]{tagColorToUpdate, ((AtlasClassificationDef)typesDef.getClassificationDefs().get(0)).getName(), e});
                }
            }
        }
        LOG.info("Updating tag colors to DEFAULT_COLOR complete");
    }

    private void deleteLegacyTypeDefs() {
        for (String typeName : this.typeDefsToDelete) {
            AtlasBaseTypeDef typeDef = null;
            try {
                typeDef = this.typeDefStore.getByName(typeName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (typeDef != null) {
                    this.typeDefStore.deleteTypeByName(typeName);
                    LOG.info("Deleted type def " + typeName);
                    continue;
                }
                LOG.info("Could not find type def " + typeName);
            }
            catch (Exception e) {
                LOG.warn("Could not delete type def " + typeName, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteLegacyAttrDefs() {
        for (String qualifiedAttrName : this.attrDefsToDelete) {
            int index = qualifiedAttrName.indexOf(46);
            if (index <= 0) {
                LOG.warn("Skipping attr def " + qualifiedAttrName);
                continue;
            }
            String entityName = qualifiedAttrName.substring(0, index);
            String attrName = qualifiedAttrName.substring(index + 1);
            try {
                RequestContext.get().setInTypePatching(true);
                AtlasEntityDef entityDef = this.typeRegistry.getEntityDefByName(entityName);
                AtlasEntityDef updatedDef = new AtlasEntityDef(entityDef);
                if (updatedDef.hasAttribute(attrName)) {
                    updatedDef.removeAttribute(attrName);
                    this.typeDefStore.updateEntityDefByName(entityName, updatedDef);
                    LOG.info("Deleted attr def " + qualifiedAttrName);
                    continue;
                }
                LOG.info("Could not find attr def " + qualifiedAttrName);
            }
            catch (Exception e) {
                LOG.warn("Could not delete attr def " + qualifiedAttrName, (Throwable)e);
            }
            finally {
                RequestContext.get().setInTypePatching(false);
                RequestContext.clear();
            }
        }
    }

    private void initMetadataRegistry() {
        Thread thread = new Thread(() -> {
            try {
                SchemaAtlasHook hook = (SchemaAtlasHook)this.metadataRegistry.properties().get("hook");
                hook.waitForInit();
                LOG.info("Initializing metadata registry");
                this.metadataRegistry.init();
                LOG.info("Done initializing metadata registry");
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        thread.start();
    }

    public void waitForMetadataRegistryInit() throws InterruptedException {
        this.metadataRegistry.waitForInit();
    }

    public boolean metadataRegistryInitialized() {
        return this.metadataRegistry.initialized();
    }
}

