/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.ingestion;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class ReconciliationCache {
    private final Cache<ReconciliationCacheKey, ReconciliationCacheValue> cache;

    public ReconciliationCache(int cacheSize, int ttl) {
        this.cache = Caffeine.newBuilder().maximumSize((long)cacheSize).expireAfterWrite((long)ttl, TimeUnit.SECONDS).build();
    }

    public ReconciliationCacheValue getOrDefault(ReconciliationCacheKey key) {
        ReconciliationCacheValue value = (ReconciliationCacheValue)this.cache.getIfPresent((Object)key);
        if (value == null) {
            value = new ReconciliationCacheValue();
            this.cache.put((Object)key, (Object)value);
        }
        return value;
    }

    public boolean contains(ReconciliationCacheKey key) {
        return this.cache.getIfPresent((Object)key) != null;
    }

    public void invalidate(ReconciliationCacheKey key) {
        this.cache.invalidate((Object)key);
    }

    public static class ReconciliationCacheValue {
        private final HashSet<String> entities = new HashSet();
        private final HashSet<Integer> pageNumbers = new HashSet();

        public HashSet<String> getEntities() {
            return this.entities;
        }

        public HashSet<Integer> getPageNumbers() {
            return this.pageNumbers;
        }
    }

    public static class ReconciliationCacheKey {
        private final String tenant;
        private final String group;
        private final String metadataType;

        public ReconciliationCacheKey(String tenant, String group, String metadataType) {
            this.tenant = tenant;
            this.group = group;
            this.metadataType = metadataType;
        }

        public String getTenant() {
            return this.tenant;
        }

        public String getGroup() {
            return this.group;
        }

        public String getMetadataType() {
            return this.metadataType;
        }

        public int hashCode() {
            return Objects.hash(this.tenant, this.group, this.metadataType);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ReconciliationCacheKey other = (ReconciliationCacheKey)obj;
            return Objects.equals(this.tenant, other.tenant) && Objects.equals(this.group, other.group) && Objects.equals(this.metadataType, other.metadataType);
        }

        public String toString() {
            return "SnapshotGroup{tenant=" + this.tenant + ", group=" + this.group + ", metadataType=" + this.metadataType + '}';
        }
    }
}

