/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.notification;

import java.util.ArrayList;
import java.util.List;
import org.apache.atlas.GraphTransactionInterceptor;
import org.apache.atlas.notification.NotificationException;
import org.apache.atlas.notification.NotificationInterface;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityNotificationSender<T> {
    private static final Logger LOG = LoggerFactory.getLogger(EntityNotificationSender.class);
    private static final boolean NOTIFY_POST_COMMIT_DEFAULT = true;
    private final NotificationSender<T> notificationSender;
    private final NotificationSender<T> inlineNotificationSender;

    public EntityNotificationSender(NotificationInterface notificationInterface, Configuration configuration) {
        this(notificationInterface);
    }

    public EntityNotificationSender(NotificationInterface notificationInterface) {
        this.notificationSender = new PostCommitNotificationSender(notificationInterface);
        this.inlineNotificationSender = new InlineNotificationSender(notificationInterface);
    }

    public void send(List<T> notifications) throws NotificationException {
        this.notificationSender.send(notifications);
    }

    public void sendInlineNotifications(List<T> notifications) throws NotificationException {
        this.inlineNotificationSender.send(notifications);
    }

    private class PostCommitNotificationSender<T>
    implements NotificationSender<T> {
        private final NotificationInterface notificationInterface;
        private final ThreadLocal<PostCommitNotificationHook> postCommitNotificationHooks = new ThreadLocal();

        public PostCommitNotificationSender(NotificationInterface notificationInterface) {
            this.notificationInterface = notificationInterface;
        }

        @Override
        public void send(List<T> notifications) throws NotificationException {
            PostCommitNotificationHook<T> notificationHook = this.postCommitNotificationHooks.get();
            if (notificationHook == null) {
                notificationHook = new PostCommitNotificationHook<T>(notifications);
                this.postCommitNotificationHooks.set(notificationHook);
            } else {
                notificationHook.addNotifications(notifications);
            }
        }

        class PostCommitNotificationHook<T>
        extends GraphTransactionInterceptor.PostTransactionHook {
            private final List<T> notifications = new ArrayList<T>();

            public PostCommitNotificationHook(List<T> notifications) {
                this.addNotifications(notifications);
            }

            public void addNotifications(List<T> notifications) {
                if (notifications != null) {
                    this.notifications.addAll(notifications);
                }
            }

            public void onComplete(boolean isSuccess) {
                PostCommitNotificationSender.this.postCommitNotificationHooks.remove();
                if (CollectionUtils.isNotEmpty(this.notifications)) {
                    if (isSuccess) {
                        try {
                            PostCommitNotificationSender.this.notificationInterface.send(NotificationInterface.NotificationType.ENTITIES, this.notifications);
                        }
                        catch (NotificationException excp) {
                            LOG.error("failed to send entity notifications", (Throwable)excp);
                        }
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug("Transaction not committed. Not sending {} notifications: {}", (Object)this.notifications.size(), this.notifications);
                    }
                }
            }
        }
    }

    private class InlineNotificationSender<T>
    implements NotificationSender<T> {
        private final NotificationInterface notificationInterface;

        public InlineNotificationSender(NotificationInterface notificationInterface) {
            this.notificationInterface = notificationInterface;
        }

        @Override
        public void send(List<T> notifications) throws NotificationException {
            this.notificationInterface.send(NotificationInterface.NotificationType.ENTITIES, notifications);
        }
    }

    private static interface NotificationSender<T> {
        public void send(List<T> var1) throws NotificationException;
    }
}

