/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.notification;

import io.confluent.catalog.notification.CatalogEntityHeader;
import io.confluent.catalog.notification.MultiTenantKafkaNotification;
import io.confluent.catalog.notification.NotificationContainer;
import io.confluent.catalog.notification.NotificationSender;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.atlas.AtlasException;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.notification.EntityNotification;
import org.apache.atlas.notification.NotificationConsumer;
import org.apache.atlas.notification.NotificationException;
import org.apache.atlas.notification.NotificationInterface;
import org.apache.atlas.repository.store.graph.AtlasEntityStore;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.commons.lang.StringUtils;

public class NotificationEnrichProcessor
implements NotificationInterface {
    private NotificationInterface delegate;
    private final AtlasTypeRegistry typeRegistry;
    private final AtlasEntityStore entityStore;

    @Inject
    public NotificationEnrichProcessor(@NotificationSender NotificationInterface delegate, AtlasTypeRegistry typeRegistry, AtlasEntityStore entityStore) throws AtlasException {
        MultiTenantKafkaNotification.LOG.info("==> NotificationEnrichProcessor()");
        this.delegate = delegate;
        this.entityStore = entityStore;
        this.typeRegistry = typeRegistry;
        MultiTenantKafkaNotification.LOG.info("<== NotificationEnrichProcessor()");
    }

    public void init(String s, Object o) {
    }

    public void setCurrentUser(String user) {
    }

    public <T> List<NotificationConsumer<T>> createConsumers(NotificationInterface.NotificationType notificationType, int i) {
        return this.delegate.createConsumers(notificationType, i);
    }

    public <T> void send(NotificationInterface.NotificationType notificationType, T ... messages) throws NotificationException {
        this.send(notificationType, Arrays.asList(messages));
    }

    public <T> void send(NotificationInterface.NotificationType notificationType, List<T> messages) throws NotificationException {
        for (int index = 0; index < messages.size(); ++index) {
            NotificationContainer envelope;
            T message = messages.get(index);
            if (!(message instanceof NotificationContainer) || !((envelope = (NotificationContainer)message).getNotification() instanceof EntityNotification.EntityNotificationV2)) continue;
            this.addQualifiedName((EntityNotification.EntityNotificationV2)envelope.getNotification());
        }
        this.delegate.send(notificationType, messages);
    }

    private void addQualifiedName(EntityNotification.EntityNotificationV2 notificationV2) throws NotificationException {
        CatalogEntityHeader header = (CatalogEntityHeader)notificationV2.getEntity();
        for (Map.Entry<String, Object> kv : header.getRelationships().entrySet()) {
            if (kv.getValue() instanceof AtlasObjectId) {
                Object value = kv.getValue();
                this.setQualifiedName(value);
                header.setAttribute(kv.getKey(), value);
                continue;
            }
            if (kv.getValue() instanceof List) {
                List kvValue = (List)kv.getValue();
                for (Object v : kvValue) {
                    this.setQualifiedName(v);
                }
                header.setAttribute(kv.getKey(), kvValue);
                continue;
            }
            header.setAttribute(kv.getKey(), kv.getValue());
        }
    }

    private void setQualifiedName(Object v) {
        String qualifiedName;
        AtlasObjectId value;
        if (v instanceof AtlasObjectId && ((value = (AtlasObjectId)v).getUniqueAttributes() == null || value.getUniqueAttributes().get("qualifiedName") == null) && StringUtils.isNotEmpty((String)(qualifiedName = this.getQualifiedNameFromGuid(value.getGuid())))) {
            value.setUniqueAttributes(Collections.singletonMap("qualifiedName", qualifiedName));
        }
    }

    private String getQualifiedNameFromGuid(String guid) {
        try {
            AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = this.entityStore.getById(guid, true, true);
            if (entityWithExtInfo == null) {
                return "";
            }
            AtlasEntity entity = entityWithExtInfo.getEntity();
            if (entity == null || entity.getAttribute("qualifiedName") == null) {
                return "";
            }
            return (String)entity.getAttribute("qualifiedName");
        }
        catch (AtlasBaseException e) {
            return "";
        }
    }

    public void close() {
    }

    public boolean isReady(NotificationInterface.NotificationType notificationType) {
        return this.delegate.isReady(notificationType);
    }
}

