/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.storage;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.atlas.AtlasConfiguration;
import org.apache.atlas.discovery.AtlasDiscoveryService;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.discovery.AtlasSearchResult;
import org.apache.atlas.model.discovery.SearchParameters;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.springframework.stereotype.Service;

@Singleton
@Service
public class EntitySearchService {
    private final AtlasDiscoveryService discoveryService;

    @Inject
    public EntitySearchService(AtlasDiscoveryService discoveryService) {
        this.discoveryService = discoveryService;
    }

    public List<AtlasEntityHeader> searchAllNonDeprecatedEntities(String typeName, String qualifiedNamePrefix, String tenant, Set<String> attrs, Set<String> qualifiedTagDefNames) throws AtlasBaseException {
        ArrayList<SearchParameters.FilterCriteria> criteria = new ArrayList<SearchParameters.FilterCriteria>();
        if (qualifiedNamePrefix != null && !qualifiedNamePrefix.isEmpty()) {
            criteria.add(this.qualifiedNamePrefixFilter(qualifiedNamePrefix));
        }
        if (tenant != null && !tenant.isEmpty()) {
            criteria.add(this.tenantFilter(tenant));
        }
        ArrayList<SearchParameters.FilterCriteria> deprecatedTimeCriteria = new ArrayList<SearchParameters.FilterCriteria>();
        deprecatedTimeCriteria.add(this.deprecatedTimeZeroFilter(true));
        deprecatedTimeCriteria.add(this.deprecatedTimeNullFilter(true));
        SearchParameters.FilterCriteria deprecatedTimeFilters = new SearchParameters.FilterCriteria();
        deprecatedTimeFilters.setCondition(SearchParameters.FilterCriteria.Condition.OR);
        deprecatedTimeFilters.setCriterion(deprecatedTimeCriteria);
        criteria.add(deprecatedTimeFilters);
        SearchParameters.FilterCriteria filters = new SearchParameters.FilterCriteria();
        filters.setCondition(SearchParameters.FilterCriteria.Condition.AND);
        filters.setCriterion(criteria);
        return this.searchAllEntitiesWithCustomFilters(typeName, attrs, filters, qualifiedTagDefNames);
    }

    public List<AtlasEntityHeader> searchAllDeprecatedEntities(String typeName, String qualifiedNamePrefix, String tenant, Set<String> attrs, Set<String> qualifiedTagDefNames) throws AtlasBaseException {
        ArrayList<SearchParameters.FilterCriteria> criteria = new ArrayList<SearchParameters.FilterCriteria>();
        if (qualifiedNamePrefix != null && !qualifiedNamePrefix.isEmpty()) {
            criteria.add(this.qualifiedNamePrefixFilter(qualifiedNamePrefix));
        }
        if (tenant != null && !tenant.isEmpty()) {
            criteria.add(this.tenantFilter(tenant));
        }
        ArrayList<SearchParameters.FilterCriteria> deprecatedTimeCriteria = new ArrayList<SearchParameters.FilterCriteria>();
        deprecatedTimeCriteria.add(this.deprecatedTimeZeroFilter(false));
        deprecatedTimeCriteria.add(this.deprecatedTimeNullFilter(false));
        SearchParameters.FilterCriteria deprecatedTimeFilters = new SearchParameters.FilterCriteria();
        deprecatedTimeFilters.setCondition(SearchParameters.FilterCriteria.Condition.AND);
        deprecatedTimeFilters.setCriterion(deprecatedTimeCriteria);
        criteria.add(deprecatedTimeFilters);
        SearchParameters.FilterCriteria filters = new SearchParameters.FilterCriteria();
        filters.setCondition(SearchParameters.FilterCriteria.Condition.AND);
        filters.setCriterion(criteria);
        return this.searchAllEntitiesWithCustomFilters(typeName, attrs, filters, qualifiedTagDefNames);
    }

    public List<AtlasEntityHeader> searchAllEntitiesWithCustomFilters(String typeName, Set<String> attrs, SearchParameters.FilterCriteria filters, Set<String> qualifiedTagDefNames) throws AtlasBaseException {
        if (typeName == null || typeName.isEmpty()) {
            typeName = "cf_entity";
        }
        SearchParameters searchParams = new SearchParameters();
        searchParams.setTypeName(typeName);
        searchParams.setAttributes(attrs);
        searchParams.setExcludeDeletedEntities(true);
        searchParams.setEntityFilters(filters);
        if (qualifiedTagDefNames != null && !qualifiedTagDefNames.isEmpty()) {
            searchParams.setClassification(String.join((CharSequence)",", qualifiedTagDefNames));
        }
        int offset = 0;
        int limit = AtlasConfiguration.SEARCH_MAX_LIMIT.getInt();
        boolean hasMoreResults = true;
        ArrayList<AtlasEntityHeader> result = new ArrayList<AtlasEntityHeader>();
        while (hasMoreResults) {
            searchParams.setOffset(offset);
            searchParams.setLimit(limit);
            AtlasSearchResult searchResult = this.discoveryService.searchWithParameters(searchParams);
            if (searchResult == null || searchResult.getEntities() == null) break;
            result.addAll(searchResult.getEntities());
            offset += limit;
            hasMoreResults = searchResult.getEntities().size() == limit;
        }
        return result;
    }

    public List<AtlasEntityHeader> searchEntityByQualifiedNamePrefix(String typeName, String qualifiedNamePrefix, Set<String> attrs) throws AtlasBaseException {
        SearchParameters searchParams = new SearchParameters();
        searchParams.setAttributes(attrs);
        searchParams.setTypeName(typeName);
        searchParams.setEntityFilters(this.qualifiedNamePrefixFilter(qualifiedNamePrefix));
        searchParams.setExcludeDeletedEntities(true);
        AtlasSearchResult searchResult = this.discoveryService.searchWithParameters(searchParams);
        return searchResult.getEntities();
    }

    private SearchParameters.FilterCriteria qualifiedNamePrefixFilter(String qualifiedNamePrefix) {
        SearchParameters.FilterCriteria attrFilter = new SearchParameters.FilterCriteria();
        attrFilter.setAttributeName("qualifiedName");
        attrFilter.setOperator(SearchParameters.Operator.STARTS_WITH);
        attrFilter.setAttributeValue(qualifiedNamePrefix);
        return attrFilter;
    }

    private SearchParameters.FilterCriteria tenantFilter(String tenant) {
        SearchParameters.FilterCriteria attrFilter = new SearchParameters.FilterCriteria();
        attrFilter.setAttributeName("tenant");
        attrFilter.setOperator(SearchParameters.Operator.EQ);
        attrFilter.setAttributeValue(tenant);
        return attrFilter;
    }

    private SearchParameters.FilterCriteria deprecatedTimeZeroFilter(boolean isZero) {
        SearchParameters.FilterCriteria attrFilter = new SearchParameters.FilterCriteria();
        attrFilter.setAttributeName("deprecatedTime");
        attrFilter.setOperator(isZero ? SearchParameters.Operator.EQ : SearchParameters.Operator.NEQ);
        attrFilter.setAttributeValue("0");
        return attrFilter;
    }

    private SearchParameters.FilterCriteria deprecatedTimeNullFilter(boolean isNull) {
        SearchParameters.FilterCriteria attrFilter = new SearchParameters.FilterCriteria();
        attrFilter.setAttributeName("deprecatedTime");
        attrFilter.setOperator(isNull ? SearchParameters.Operator.IS_NULL : SearchParameters.Operator.NOT_NULL);
        return attrFilter;
    }
}

