/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.storage;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class EntitySnapshot {
    private Set<String> entities;
    private int pageNumber;
    private int totalPages;

    public EntitySnapshot() {
        this.entities = null;
        this.pageNumber = 0;
        this.totalPages = 1;
    }

    public EntitySnapshot(Set<String> entities) {
        this.entities = entities;
        this.pageNumber = 0;
        this.totalPages = 1;
    }

    public EntitySnapshot(Set<String> entities, int pageNumber, int totalPages) {
        this.entities = entities;
        this.pageNumber = pageNumber;
        this.totalPages = totalPages;
    }

    @JsonProperty(value="entities")
    public void setEntities(Set<String> entities) {
        this.entities = entities;
    }

    @JsonProperty(value="entities")
    public Set<String> getEntities() {
        return this.entities;
    }

    @JsonProperty(value="pageNumber")
    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    @JsonProperty(value="pageNumber")
    public int getPageNumber() {
        return this.pageNumber;
    }

    @JsonProperty(value="totalPages")
    public void setTotalPages(int totalPages) {
        this.totalPages = totalPages;
    }

    @JsonProperty(value="totalPages")
    public int getTotalPages() {
        return this.totalPages;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntitySnapshot that = (EntitySnapshot)o;
        return this.pageNumber == that.pageNumber && this.totalPages == that.totalPages && this.entities.equals(that.entities);
    }

    public int hashCode() {
        return Objects.hash(this.entities, this.pageNumber, this.totalPages);
    }

    public String toString() {
        return "EntitySnapshot{pageNumber=" + this.pageNumber + ", totalPages=" + this.totalPages + ", entities=" + this.entities + '}';
    }
}

