/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.storage;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.catalog.storage.MetadataRegistryKind;
import io.confluent.catalog.storage.MetadataRegistryOp;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class MetadataRegistryKey
implements Comparable<MetadataRegistryKey> {
    private String tenant;
    private MetadataRegistryOp op;
    private MetadataRegistryKind kind;
    private String type;
    private String version;
    private String name;
    private String relatedType;
    private String relatedName;

    public MetadataRegistryKey(@JsonProperty(value="tenant") String tenant, @JsonProperty(value="op") MetadataRegistryOp op, @JsonProperty(value="kind") MetadataRegistryKind kind, @JsonProperty(value="type") String type, @JsonProperty(value="version") String version, @JsonProperty(value="name") String name, @JsonProperty(value="relType") String relatedType, @JsonProperty(value="relName") String relatedName) {
        this.tenant = tenant;
        this.op = op;
        this.kind = kind;
        this.type = type;
        this.version = version;
        this.name = name;
        this.relatedType = relatedType;
        this.relatedName = relatedName;
    }

    @JsonProperty(value="tenant")
    public String getTenant() {
        return this.tenant;
    }

    @JsonProperty(value="tenant")
    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    @JsonProperty(value="op")
    public MetadataRegistryOp getOp() {
        return this.op;
    }

    @JsonProperty(value="op")
    public void setOp(MetadataRegistryOp op) {
        this.op = op;
    }

    @JsonProperty(value="kind")
    public MetadataRegistryKind getKind() {
        return this.kind;
    }

    @JsonProperty(value="kind")
    public void setKind(MetadataRegistryKind kind) {
        this.kind = kind;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(String type) {
        this.type = type;
    }

    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    public void setVersion(String version) {
        this.version = version;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="relType")
    public String getRelatedType() {
        return this.relatedType;
    }

    @JsonProperty(value="relType")
    public void setRelatedType(String relatedType) {
        this.relatedType = relatedType;
    }

    @JsonProperty(value="relName")
    public String getRelatedName() {
        return this.relatedName;
    }

    @JsonProperty(value="relName")
    public void setRelatedName(String relatedName) {
        this.relatedName = relatedName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataRegistryKey that = (MetadataRegistryKey)o;
        return this.tenant.equals(that.tenant) && this.op == that.op && this.kind == that.kind && Objects.equals(this.type, that.type) && Objects.equals(this.version, that.version) && Objects.equals(this.name, that.name) && Objects.equals(this.relatedType, that.relatedType) && Objects.equals(this.relatedName, that.relatedName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tenant, this.op, this.kind, this.type, this.version, this.name, this.relatedType, this.relatedName});
    }

    @Override
    public int compareTo(MetadataRegistryKey that) {
        if (this.tenant != null || that.tenant != null) {
            if (this.tenant == null) {
                return -1;
            }
            if (that.tenant == null) {
                return 1;
            }
            int tenantComparison = this.tenant.compareTo(that.tenant);
            if (tenantComparison != 0) {
                return tenantComparison < 0 ? -1 : 1;
            }
        }
        if (this.op != null || that.op != null) {
            if (this.op == null) {
                return -1;
            }
            if (that.op == null) {
                return 1;
            }
            int opComparison = this.op.compareTo(that.op);
            if (opComparison != 0) {
                return opComparison < 0 ? -1 : 1;
            }
        }
        if (this.kind != null || that.kind != null) {
            if (this.kind == null) {
                return -1;
            }
            if (that.kind == null) {
                return 1;
            }
            int kindComparison = this.kind.compareTo(that.kind);
            if (kindComparison != 0) {
                return kindComparison < 0 ? -1 : 1;
            }
        }
        if (this.type != null || that.type != null) {
            if (this.type == null) {
                return -1;
            }
            if (that.type == null) {
                return 1;
            }
            int typeComparison = this.type.compareTo(that.type);
            if (typeComparison != 0) {
                return typeComparison < 0 ? -1 : 1;
            }
        }
        if (this.version != null || that.version != null) {
            if (this.version == null) {
                return -1;
            }
            if (that.version == null) {
                return 1;
            }
            int versionComparison = this.version.compareTo(that.version);
            if (versionComparison != 0) {
                return versionComparison < 0 ? -1 : 1;
            }
        }
        if (this.name != null || that.name != null) {
            if (this.name == null) {
                return -1;
            }
            if (that.name == null) {
                return 1;
            }
            int nameComparison = this.name.compareTo(that.name);
            if (nameComparison != 0) {
                return nameComparison < 0 ? -1 : 1;
            }
        }
        if (this.relatedType != null || that.relatedType != null) {
            if (this.relatedType == null) {
                return -1;
            }
            if (that.relatedType == null) {
                return 1;
            }
            int relatedTypeComparison = this.relatedType.compareTo(that.relatedType);
            if (relatedTypeComparison != 0) {
                return relatedTypeComparison < 0 ? -1 : 1;
            }
        }
        if (this.relatedName == null && that.relatedName == null) {
            return 0;
        }
        if (this.relatedName == null) {
            return -1;
        }
        if (that.relatedName == null) {
            return 1;
        }
        return this.relatedName.compareTo(that.relatedName);
    }

    public String toString() {
        return "MetadataRegistryKey{tenant='" + this.tenant + '\'' + ", op=" + (Object)((Object)this.op) + ", kind=" + (Object)((Object)this.kind) + ", type='" + this.type + '\'' + ", version='" + this.version + '\'' + ", name='" + this.name + '\'' + ", relatedType='" + this.relatedType + '\'' + ", relatedName='" + this.relatedName + '\'' + '}';
    }
}

