/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.util;

import io.confluent.catalog.util.Clock;
import java.util.concurrent.atomic.AtomicLong;

public class AtomicTimestampGenerator {
    private Clock clock;
    private AtomicLong lastRef = new AtomicLong(0L);

    public AtomicTimestampGenerator(Clock clock) {
        this.clock = clock;
    }

    public long next() {
        long next;
        long last;
        while (!this.lastRef.compareAndSet(last = this.lastRef.get(), next = this.computeNext(last))) {
        }
        return next;
    }

    private long computeNext(long last) {
        long currentTick = this.clock.currentTimeMicros();
        if (last >= currentTick) {
            return last + 1L;
        }
        return currentTick;
    }
}

