/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.util;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.dataformat.csv.CsvGenerator;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvParser;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import io.confluent.catalog.util.CatalogTenantUtils;
import java.io.IOException;

public class QualifiedNameGenerator {
    public static final String TYPE_NAME_DELIMITER = "__";
    public static final char NAME_DELIM_CHAR = ':';
    public static final char NAME_QUOTE_CHAR = '\'';
    public static final String NAME_DELIMITER = String.valueOf(':');
    private static final CsvMapper MAPPER = QualifiedNameGenerator.newMapper();
    private static final CsvSchema SCHEMA = CsvSchema.builder().setColumnSeparator(':').setQuoteChar('\'').setLineSeparator("").build();

    private static CsvMapper newMapper() {
        CsvMapper mapper = new CsvMapper();
        mapper.enable(CsvGenerator.Feature.STRICT_CHECK_FOR_QUOTING);
        mapper.enable(CsvParser.Feature.WRAP_AS_ARRAY);
        return mapper;
    }

    public static String ensureTypeTenantPrefix(String tenant, String typeName) {
        String escapedTenant = CatalogTenantUtils.tenantToEscaped(tenant);
        return QualifiedNameGenerator.ensurePrefix(escapedTenant, TYPE_NAME_DELIMITER, typeName);
    }

    public static String stripTypeTenantPrefix(String tenant, String typeName) {
        String escapedTenant = CatalogTenantUtils.tenantToEscaped(tenant);
        if (typeName != null && typeName.startsWith(escapedTenant + TYPE_NAME_DELIMITER)) {
            int index = escapedTenant.length() + TYPE_NAME_DELIMITER.length();
            return typeName.substring(index);
        }
        return typeName;
    }

    public static String ensureEntityTenantPrefix(String tenant, String typeName, String qualifiedName) {
        String prefix = QualifiedNameGenerator.isSrEntity(typeName, qualifiedName) && qualifiedName != null && !qualifiedName.startsWith(NAME_DELIMITER) ? QualifiedNameGenerator.getQualifiedName(tenant, ".") : tenant;
        return QualifiedNameGenerator.ensurePrefix(prefix, NAME_DELIMITER, qualifiedName);
    }

    private static boolean isSrEntity(String typeName, String qualifiedName) {
        if (typeName == null) {
            return !qualifiedName.startsWith("lcc-") && !qualifiedName.startsWith("lkc-") && !qualifiedName.startsWith("lksqlc-");
        }
        return typeName.startsWith("sr_");
    }

    public static String stripEntityTenantPrefix(String tenant, String typeName, String name) {
        String prefix;
        if (name == null) {
            return null;
        }
        String string = prefix = typeName == null || typeName.startsWith("sr_") ? QualifiedNameGenerator.getQualifiedName(tenant, ".") : tenant;
        if (name.startsWith(prefix)) {
            return name.replaceFirst(prefix + NAME_DELIMITER, "");
        }
        return name;
    }

    public static String ensurePrefix(String prefix, String delimiter, String name) {
        if (name != null && !name.startsWith(prefix)) {
            if (!name.startsWith(delimiter)) {
                name = delimiter + name;
            }
            name = prefix + name;
        }
        return name;
    }

    public static String getQualifiedName(Object ... parts) {
        try {
            ObjectWriter writer = MAPPER.writerFor(Object[].class).with((FormatSchema)SCHEMA);
            return writer.writeValueAsString((Object)parts);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String[] parseQualifiedName(String name) {
        try {
            ObjectReader reader = MAPPER.readerFor(String[].class).with((FormatSchema)SCHEMA);
            MappingIterator iter = reader.readValues(name);
            return iter.hasNext() ? (String[])iter.next() : new String[]{};
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

