/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.web.filters;

import com.google.inject.Injector;
import io.confluent.catalog.hook.TypeDefStoreLoader;
import io.confluent.catalog.metrics.MetricsManager;
import io.confluent.catalog.web.graphql.resources.GraphQLResource;
import io.confluent.catalog.web.rest.resources.CatalogResource;
import io.confluent.catalog.web.rest.resources.EntityResource;
import io.confluent.catalog.web.rest.resources.SearchResource;
import io.confluent.catalog.web.rest.resources.TypesResource;
import io.confluent.rest.entities.ErrorMessage;
import java.io.IOException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasInitializationFilter
implements ContainerRequestFilter {
    public static final String DELETE_OR_MOVE_DATA_DIR_PROPERTY = "DeleteOrMoveDataDir";
    private static final Logger LOG = LoggerFactory.getLogger(AtlasInitializationFilter.class);
    private final Injector injector;
    private final TypeDefStoreLoader typeDefStoreLoader;
    private final MetricsManager metricsManager;
    private final boolean rebuildingCatalog;
    @Context
    private ResourceInfo resourceInfo;

    public AtlasInitializationFilter(Injector injector) {
        this.injector = injector;
        this.typeDefStoreLoader = (TypeDefStoreLoader)injector.getInstance(TypeDefStoreLoader.class);
        this.metricsManager = (MetricsManager)injector.getInstance(MetricsManager.class);
        this.rebuildingCatalog = Boolean.parseBoolean(System.getProperty(DELETE_OR_MOVE_DATA_DIR_PROPERTY, "false"));
        LOG.info("Initializing AtlasInitializationFilter, rebuildingCatalog={}", (Object)this.rebuildingCatalog);
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        Class resourceClass = this.resourceInfo.getResourceClass();
        if (resourceClass.equals(CatalogResource.class) || resourceClass.equals(EntityResource.class) || resourceClass.equals(SearchResource.class) || resourceClass.equals(TypesResource.class) || resourceClass.equals(GraphQLResource.class)) {
            if (!this.typeDefStoreLoader.metadataRegistryInitialized() && this.rebuildingCatalog) {
                requestContext.abortWith(Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)new ErrorMessage(5030000, "Catalog is not available yet. Please try again later.")).build());
                this.metricsManager.recordServiceUnavailable();
                return;
            }
            this.typeDefStoreLoader.initTypeDefStore(this.injector);
        }
    }
}

