/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.web.filters;

import io.confluent.catalog.client.autthorizer.CatalogAuthorizerClient;
import io.confluent.catalog.util.CatalogTenantUtils;
import io.confluent.catalog.util.QualifiedNameGenerator;
import io.confluent.catalog.util.RbacConstants;
import io.confluent.catalog.util.RbacException;
import io.confluent.catalog.util.RbacUtils;
import io.confluent.catalog.web.filters.CatalogRequestContextHolder;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.kafka.schemaregistry.utils.QualifiedSubject;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.atlas.authorize.AtlasAdminAccessRequest;
import org.apache.atlas.authorize.AtlasAuthorizationException;
import org.apache.atlas.authorize.AtlasAuthorizer;
import org.apache.atlas.authorize.AtlasEntityAccessRequest;
import org.apache.atlas.authorize.AtlasRelationshipAccessRequest;
import org.apache.atlas.authorize.AtlasSearchResultScrubRequest;
import org.apache.atlas.authorize.AtlasTypeAccessRequest;
import org.apache.atlas.authorize.AtlasTypesDefFilterRequest;
import org.apache.atlas.model.discovery.AtlasSearchResult;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.instance.AtlasRelatedObjectId;
import org.apache.atlas.repository.store.graph.AtlasEntityStore;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogRbacAuthorizationFilter
implements AtlasAuthorizer {
    private static ThreadLocal<Integer> preRbacResultSize = new ThreadLocal();
    private boolean isRbacEnabled;
    private Map<String, Object> authorizationConfig;
    private static final Logger LOG = LoggerFactory.getLogger(CatalogRbacAuthorizationFilter.class);
    private CatalogAuthorizerClient authorizerRestClient;
    private KafkaSchemaRegistry schemaRegistry;
    private AtlasEntityStore entityStore;

    public void init() {
        this.isRbacEnabled = false;
        LOG.debug("Initialized CatalogRbacAuthorizationFilter. RBAC not enabled yet");
    }

    public void cleanUp() {
    }

    public boolean isAccessAllowed(AtlasAdminAccessRequest atlasAdminAccessRequest) throws AtlasAuthorizationException {
        return false;
    }

    public boolean isAccessAllowed(AtlasEntityAccessRequest atlasEntityAccessRequest) throws AtlasAuthorizationException {
        return true;
    }

    public boolean isAccessAllowed(AtlasTypeAccessRequest atlasTypeAccessRequest) throws AtlasAuthorizationException {
        return true;
    }

    public boolean isAccessAllowed(AtlasRelationshipAccessRequest request) throws AtlasAuthorizationException {
        return true;
    }

    public void scrubSearchResults(AtlasSearchResultScrubRequest request) throws AtlasAuthorizationException {
        Iterator iter;
        LinkedList<AtlasEntityHeader> entities;
        AtlasSearchResult result = request.getSearchResult();
        if (result.getEntities() != null) {
            preRbacResultSize.set(result.getEntities().size());
        } else {
            preRbacResultSize.set(0);
        }
        LOG.info("search params in filter " + result.getSearchParameters().toString());
        if (!this.isRbacEnabled) {
            return;
        }
        if (CollectionUtils.isNotEmpty((Collection)result.getEntities())) {
            this.scrubEntities(request.getUser(), result.getEntities());
            ListIterator iter2 = result.getEntities().listIterator();
            while (iter2.hasNext()) {
                AtlasEntityHeader entity = (AtlasEntityHeader)iter2.next();
                if (!entity.getGuid().equals("-1")) continue;
                iter2.remove();
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)result.getFullTextResult())) {
            entities = new LinkedList<AtlasEntityHeader>();
            for (AtlasSearchResult.AtlasFullTextResult fullTextResult : result.getFullTextResult()) {
                if (fullTextResult == null) continue;
                entities.add(fullTextResult.getEntity());
            }
            this.scrubEntities(request.getUser(), entities);
            iter = result.getFullTextResult().listIterator();
            while (iter.hasNext()) {
                AtlasSearchResult.AtlasFullTextResult fullTextResult;
                fullTextResult = (AtlasSearchResult.AtlasFullTextResult)iter.next();
                if (fullTextResult == null || !fullTextResult.getEntity().getGuid().equals("-1")) continue;
                iter.remove();
            }
        }
        if (MapUtils.isNotEmpty((Map)result.getReferredEntities())) {
            entities = new LinkedList();
            for (AtlasEntityHeader entity : result.getReferredEntities().values()) {
                entities.add(entity);
            }
            this.scrubEntities(request.getUser(), entities);
            iter = result.getReferredEntities().values().iterator();
            while (iter.hasNext()) {
                AtlasEntityHeader entity;
                entity = (AtlasEntityHeader)iter.next();
                if (entity == null || !entity.getGuid().equals("-1")) continue;
                iter.remove();
            }
        }
    }

    public static Integer getPreRbacResultSize() {
        return preRbacResultSize.get();
    }

    public static void removePreRbacResultSize() {
        preRbacResultSize.remove();
    }

    public void scrubEntityHeader(AtlasEntityHeader entity) {
        super.scrubEntityHeader(entity);
        entity.setDisplayText("Not Authorized");
    }

    public void filterTypesDef(AtlasTypesDefFilterRequest request) throws AtlasAuthorizationException {
    }

    public void setRbacEnabled(boolean rbacEnabled) {
        this.isRbacEnabled = rbacEnabled;
        LOG.debug("RBAC Enabled = {}", (Object)rbacEnabled);
    }

    public void setSchemaRegistry(KafkaSchemaRegistry schemaRegistry) {
        this.schemaRegistry = schemaRegistry;
    }

    public void setAuthorizerRestClient(CatalogAuthorizerClient client) {
        this.authorizerRestClient = client;
        LOG.debug("Set Authorizer rest client");
    }

    public void setEntityStore(AtlasEntityStore entityStore) {
        this.entityStore = entityStore;
    }

    public void scrubEntities(String user, Collection<AtlasEntityHeader> entities) {
        for (AtlasEntityHeader entity : entities) {
            try {
                this.checkEntityAuthorization(user, entity);
            }
            catch (Exception e) {
                LOG.error("RBAC Auth Error. Entity:{} EntityType:{},Exception:{}", new Object[]{entity.getAttribute("qualifiedName"), entity.getTypeName(), e.getMessage()});
                this.scrubEntityHeader(entity);
            }
        }
    }

    private void checkEntityAuthorization(String user, AtlasEntityHeader entity) throws Exception {
        List<CatalogAuthorizerClient.CatalogAuthorizerAction> actions = this.convertToActions(entity);
        if (actions.size() == 0) {
            LOG.debug("Actions empty for resource {}. No authorization check is performed", entity.getAttribute("qualifiedName"));
            return;
        }
        List<CatalogAuthorizerClient.CatalogAuthorizerResponse> responses = this.authorizerRestClient.authorize(CatalogRequestContextHolder.getRequestContext(), user, new CatalogAuthorizerClient.CatalogAuthorizerRequest("", actions));
        boolean allowed = false;
        for (CatalogAuthorizerClient.CatalogAuthorizerResponse response : responses) {
            if (response.getResult() != CatalogAuthorizerClient.CatalogAuthorizeResult.ALLOWED) continue;
            allowed = true;
            break;
        }
        if (!allowed) {
            LOG.debug("Read Authorization not allowed for resource {}. Entity will be scrubbed", entity.getAttribute("qualifiedName"));
            this.scrubEntityHeader(entity);
        }
    }

    private List<CatalogAuthorizerClient.CatalogAuthorizerAction> convertToActions(AtlasEntityHeader entity) throws Exception {
        String qualifiedName = (String)entity.getAttribute("qualifiedName");
        String[] parsedValues = QualifiedNameGenerator.parseQualifiedName(qualifiedName);
        String tenant = parsedValues[0];
        String name = QualifiedNameGenerator.stripEntityTenantPrefix(tenant, entity.getTypeName(), qualifiedName);
        LinkedList<CatalogAuthorizerClient.CatalogAuthorizerAction> actions = new LinkedList<CatalogAuthorizerClient.CatalogAuthorizerAction>();
        RbacConstants.RbacResourceTypes rbacType = RbacUtils.toRbacResourceType(entity.getTypeName());
        if (rbacType == null) {
            LOG.error("Null entity type: {}", (Object)entity.getTypeName());
            throw new RbacException("Unknown entity type");
        }
        switch (rbacType) {
            case CatalogSubject: {
                Set subjectNames;
                String context = parsedValues[1];
                if (entity.getTypeName().equals("sr_subject_version")) {
                    QualifiedSubject subject = new QualifiedSubject(tenant, context, parsedValues[2]);
                    subjectNames = Collections.singleton(subject.toQualifiedSubject());
                } else {
                    int schemaId = Integer.parseInt(parsedValues[2]);
                    subjectNames = this.schemaRegistry.listSubjectsForId(schemaId, context, entity.getStatus() == AtlasEntity.Status.DELETED);
                }
                if (subjectNames != null) {
                    for (String tenantSubject : subjectNames) {
                        String resourceName = CatalogTenantUtils.subjectFor(tenant, tenantSubject);
                        actions.add(RbacUtils.getUrlEncodedAuthorizerAction(RbacConstants.RbacResourceTypes.CatalogSubject.getLabel(), resourceName, RbacConstants.RbacOperations.ReadCatalog.name()));
                    }
                    break;
                }
                LOG.error("CatalogRbacAuthorizationFilter:scrubEntities Empty subject list for tenant {}", (Object)tenant);
                break;
            }
            case CatalogTopic: {
                String resourceName = parsedValues[parsedValues.length - 1];
                if (resourceName == null) {
                    resourceName = name;
                }
                actions.add(RbacUtils.getUrlEncodedAuthorizerAction(RbacConstants.RbacResourceTypes.CatalogTopic.getLabel(), resourceName, RbacConstants.RbacOperations.ReadCatalog.name()));
                break;
            }
            case CatalogConnector: {
                String connectorName = (String)entity.getAttribute("name");
                actions.add(RbacUtils.getUrlEncodedAuthorizerAction(RbacConstants.RbacResourceTypes.CatalogConnector.getLabel(), connectorName, RbacConstants.RbacOperations.ReadCatalog.name()));
                break;
            }
            case CatalogPipeline: 
            case CatalogKafkaCluster: 
            case CatalogEnvironment: {
                actions.add(RbacUtils.getUrlEncodedAuthorizerAction(rbacType.getLabel(), name, RbacConstants.RbacOperations.ReadCatalog.name()));
                break;
            }
            case CatalogKafkaClusterLink: {
                AtlasEntity.AtlasEntityWithExtInfo clusterLinkEntity = this.entityStore.getById(entity.getGuid());
                AtlasRelatedObjectId destCluster = (AtlasRelatedObjectId)clusterLinkEntity.getEntity().getRelationshipAttribute("destination_cluster");
                if (destCluster == null || AtlasEntity.Status.ACTIVE != destCluster.getEntityStatus()) {
                    LOG.error("No active destination cluster for: {} for {}", (Object)"kafka_cluster_link", (Object)qualifiedName);
                    throw new RbacException("No active destination cluster");
                }
                AtlasEntity.AtlasEntityWithExtInfo destClusterEntity = this.entityStore.getById(destCluster.getGuid(), true, true);
                if (destClusterEntity == null || destClusterEntity.getEntity() == null) {
                    LOG.error("Invalid destination lkc for: {} for {}", (Object)"kafka_cluster_link", (Object)qualifiedName);
                    throw new RbacException("No destination cluster entity");
                }
                String clusterId = (String)destClusterEntity.getEntity().getAttribute("id");
                actions.add(RbacUtils.getUrlEncodedAuthorizerAction(rbacType.getLabel(), clusterId, RbacConstants.RbacOperations.ReadCatalog.name()));
                break;
            }
            default: {
                LOG.error("Unknown entity type: {} for {}", (Object)rbacType, (Object)qualifiedName);
                throw new RbacException("Unknown entity type");
            }
        }
        return actions;
    }
}

