/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.web.filters;

import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import java.util.HashSet;
import java.util.Set;

public class MultiTenantAuthChecker {
    private Set<String> noAuthUris;

    public MultiTenantAuthChecker(SchemaRegistryConfig schemaRegistryConfig) {
        this.noAuthUris = new HashSet<String>(schemaRegistryConfig.getList("authentication.skip.paths"));
    }

    public boolean isUnauthenticatedUri(String uri, String requestMethod) {
        return this.noAuthUris.contains("/" + uri) || "OPTIONS".equals(requestMethod);
    }
}

