/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.web.graphql.resources;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.catalog.web.graphql.entities.GraphQLRequestBody;
import io.confluent.catalog.web.graphql.schema.GraphQLExecutor;
import io.confluent.catalog.web.rest.resources.SchemaRegistryResource;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import io.confluent.rest.annotations.PerformanceMetric;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.core.Context;
import org.apache.atlas.exception.AtlasBaseException;
import org.springframework.stereotype.Service;

@Path(value="catalog/graphql")
@Singleton
@Service
@Produces(value={"application/json"})
public class GraphQLResource
extends SchemaRegistryResource {
    public static final String APPLICATION_GRAPHQL_VALUE = "application/graphql";
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final GraphQLExecutor graphQLExecutor;

    @Inject
    public GraphQLResource(SchemaRegistry schemaRegistry, GraphQLExecutor graphQLExecutor) {
        super(schemaRegistry);
        this.graphQLExecutor = graphQLExecutor;
    }

    @POST
    @Consumes(value={"application/json"})
    @PerformanceMetric(value="catalog.graphql.post-json")
    public Object postJSON(@QueryParam(value="query") String query, @QueryParam(value="operationName") String operationName, @QueryParam(value="variables") String variablesJson, @QueryParam(value="refill") @DefaultValue(value="false") boolean refill, GraphQLRequestBody request, @Context HttpServletRequest webRequest) throws AtlasBaseException {
        if (query == null) {
            query = request.getQuery();
        }
        if (query == null) {
            query = "";
        }
        if (operationName == null) {
            operationName = request.getOperationName();
        }
        Map<String, Object> variables = variablesJson == null ? request.getVariables() : this.convertVariablesJson(variablesJson);
        return this.executeRequest(query, operationName, variables, webRequest, refill);
    }

    @POST
    @Consumes(value={"application/graphql"})
    @PerformanceMetric(value="catalog.graphql.post-graphql")
    public Object postGraphQL(@QueryParam(value="query") String query, @QueryParam(value="operationName") String operationName, @QueryParam(value="variables") String variablesJson, @QueryParam(value="refill") @DefaultValue(value="false") boolean refill, String body, @Context HttpServletRequest webRequest) throws AtlasBaseException {
        if (query == null) {
            query = body;
        }
        if (query == null) {
            query = "";
        }
        return this.executeRequest(query, operationName, this.convertVariablesJson(variablesJson), webRequest, refill);
    }

    @GET
    @Consumes(value={"application/json"})
    @PerformanceMetric(value="catalog.graphql.get-query")
    public Object getQuery(@QueryParam(value="query") String query, @QueryParam(value="operationName") String operationName, @QueryParam(value="variables") String variablesJson, @QueryParam(value="refill") @DefaultValue(value="false") boolean refill, @Context HttpServletRequest webRequest) throws AtlasBaseException {
        if (query == null) {
            query = "";
        }
        return this.executeRequest(query, operationName, this.convertVariablesJson(variablesJson), webRequest, refill);
    }

    private Map<String, Object> convertVariablesJson(String jsonMap) {
        if (jsonMap == null) {
            return Collections.emptyMap();
        }
        try {
            return (Map)this.objectMapper.readValue(jsonMap, Map.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Object executeRequest(String query, String operationName, Map<String, Object> variables, HttpServletRequest webRequest, boolean refill) {
        String requestId = webRequest.getHeader("X-Request-ID");
        return this.graphQLExecutor.execute(this.getSchemaRegistry().tenant(), requestId, query, variables, refill);
    }

    @Override
    public SchemaRegistryResource.RbacPermissionEntity getRequestRbacPermissionEntity(ContainerRequestContext requestContext) {
        return null;
    }

    @Override
    public SchemaRegistryResource.RbacPermissionEntity getResponseRbacPermissionEntity(ContainerRequestContext requestContext, ContainerResponseContext responseContext, String resourceMethod) {
        return null;
    }
}

