/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.web.graphql.schema;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import graphql.Scalars;
import graphql.scalars.ExtendedScalars;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLImplementingType;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.TypeResolver;
import io.confluent.catalog.DataCatalogConfig;
import io.confluent.catalog.atlas.repository.store.graph.v2.CfltEntityGraphRetriever;
import io.confluent.catalog.hook.SchemaAtlasTypes;
import io.confluent.catalog.model.ModelConstants;
import io.confluent.catalog.web.graphql.schema.AttributeFetcher;
import io.confluent.catalog.web.graphql.schema.DummyCountFetcher;
import io.confluent.catalog.web.graphql.schema.EntityFetcher;
import io.confluent.catalog.web.graphql.schema.EntityResolver;
import io.confluent.catalog.web.graphql.schema.GraphQLQueryFactory;
import io.confluent.catalog.web.graphql.schema.JavaScalars;
import io.confluent.catalog.web.graphql.schema.Logical;
import io.confluent.catalog.web.graphql.schema.PredicateFilter;
import io.confluent.catalog.web.graphql.schema.timeout.TimeoutAsyncDataFetcher;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import io.confluent.rest.RestConfigException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.atlas.discovery.AtlasDiscoveryService;
import org.apache.atlas.model.typedef.AtlasEnumDef;
import org.apache.atlas.model.typedef.AtlasRelationshipDef;
import org.apache.atlas.model.typedef.AtlasRelationshipEndDef;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.store.graph.v2.EntityGraphRetriever;
import org.apache.atlas.type.AtlasArrayType;
import org.apache.atlas.type.AtlasBuiltInTypes;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasEnumType;
import org.apache.atlas.type.AtlasMapType;
import org.apache.atlas.type.AtlasRelationshipType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLSchemaBuilder {
    private static final Logger log = LoggerFactory.getLogger(GraphQLSchemaBuilder.class);
    public static final String QUERY_ROOT = "query_root";
    public static final String DELETED_PARAM_NAME = "deleted";
    public static final String LIMIT_PARAM_NAME = "limit";
    public static final String OFFSET_PARAM_NAME = "offset";
    public static final String ORDER_BY_PARAM_NAME = "order_by";
    public static final String BUSINESS_METADATA_PARAM_NAME = "business_metadata";
    public static final String TAGS_PARAM_NAME = "tags";
    public static final String WHERE_PARAM_NAME = "where";
    public static final String SCHEMA_ATTR_NAME = "schema";
    public static final String ENTITY_STATUS_ATTR_NAME = "entity_status";
    public static final String BUSINESS_METADATA_ATTR_NAME = "business_metadata";
    public static final String TAGS_ATTR_NAME = "tags";
    public static final String TAG_DEFS_ATTR_NAME = "tag_defs";
    public static final String RULE_TAGS_ATTR_NAME = "rule_tags";
    public static final String AUTH = "auth";
    public static final String TENANT = "tenant";
    public static final String REQUEST_CONTEXT = "request_context";
    public static final String REQUEST_ID = "request_id";
    public static final String ENTITY_COUNT_SUFFIX = "_count";
    public static final String ENTITY_COUNT = "entity_count";
    public static final String REFILL_KEY = "refill";
    public static final String FETCHED_DATA_KEY = "fetchedData";
    public static final String LIMIT_OFFSET_KEY = "limitOffset";
    private final int timeoutMs;
    private final Executor executor;
    private final KafkaSchemaRegistry schemaRegistry;
    private final AtlasDiscoveryService discoveryService;
    private final AtlasTypeRegistry typeRegistry;
    private final AtlasGraph graph;
    private final EntityGraphRetriever entityRetriever;
    private final Map<String, GraphQLImplementingType> entityCache = new HashMap<String, GraphQLImplementingType>();
    private final Map<String, GraphQLType> typeCache = new HashMap<String, GraphQLType>();
    private final Map<String, GraphQLArgument> whereArgumentsMap = new HashMap<String, GraphQLArgument>();
    private final Map<String, GraphQLInputType> whereAttributesMap = new HashMap<String, GraphQLInputType>();
    private final Map<String, GraphQLArgument> orderByArgumentsMap = new HashMap<String, GraphQLArgument>();
    private static final GraphQLEnumType orderByDirectionEnum = GraphQLEnumType.newEnum().name("order_by_enum").description("Specifies the direction (ascending/descending) for sorting a field").value("asc", (Object)"asc", "Ascending").value("desc", (Object)"desc", "Descending").build();
    private static final GraphQLEnumType entityStatusEnum = GraphQLEnumType.newEnum().name("entity_status_enum").description("Specifies the status (active/deleted) for an entity").value("active", (Object)"active", "Active").value("deleted", (Object)"deleted", "Deleted").build();
    private static final GraphQLInputObjectType betweenObject = GraphQLInputObjectType.newInputObject().name("between_start_end").description("Specifies the start and end for a range query").field(GraphQLInputObjectField.newInputObjectField().name("start").description("The range start").type((GraphQLInputType)JavaScalars.GraphQLDate).build()).field(GraphQLInputObjectField.newInputObjectField().name("end").description("The range end").type((GraphQLInputType)JavaScalars.GraphQLDate).build()).build();
    private static final GraphQLObjectType tagDef = GraphQLObjectType.newObject().name("tag_def").description("TagDef associated with the entity and its metadata").field(GraphQLFieldDefinition.newFieldDefinition().name("name").type((GraphQLOutputType)Scalars.GraphQLString).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("description").type((GraphQLOutputType)Scalars.GraphQLString).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("createTime").type((GraphQLOutputType)JavaScalars.GraphQLDate).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("updateTime").type((GraphQLOutputType)JavaScalars.GraphQLDate).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("color").type((GraphQLOutputType)Scalars.GraphQLString).build()).build();
    private static final GraphQLInputObjectType bmAttributeInputObject = GraphQLInputObjectType.newInputObject().name("business_metadata_input_attribute").description("Specifies a business metadata input attribute").field(GraphQLInputObjectField.newInputObjectField().name("name").description("The business metadata input attribute name").type((GraphQLInputType)Scalars.GraphQLString).build()).field(GraphQLInputObjectField.newInputObjectField().name("value").description("The business metadata input attribute value").type((GraphQLInputType)JavaScalars.GraphQLJsonPrimitive).build()).field(GraphQLInputObjectField.newInputObjectField().name("valuePrefix").description("The business metadata input attribute value prefix").type((GraphQLInputType)Scalars.GraphQLString).build()).build();
    private static final GraphQLObjectType bmAttributeObject = GraphQLObjectType.newObject().name("business_metadata_attribute").description("Specifies a business metadata attribute").field(GraphQLFieldDefinition.newFieldDefinition().name("name").description("The business metadata attribute name").type((GraphQLOutputType)Scalars.GraphQLString).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("value").description("The business metadata attribute value").type((GraphQLOutputType)JavaScalars.GraphQLJsonPrimitive).build()).build();
    private static final GraphQLEnumType sinceEnum = GraphQLEnumType.newEnum().name("since_enum").description("Specifies the enum for a since query").value("last_7_days", (Object)"last_7_days", "Last 7 days").value("last_30_days", (Object)"last_30_days", "Last 30 days").value("last_month", (Object)"last_month", "Last month").value("this_month", (Object)"this_month", "This month").value("today", (Object)"today", "Today").value("yesterday", (Object)"yesterday", "Yesterday").value("this_year", (Object)"this_year", "This year").value("last_year", (Object)"last_year", "Last year").value("this_quarter", (Object)"this_quarter", "This quarter").value("last_quarter", (Object)"last_quarter", "Last quarter").value("last_3_months", (Object)"last_3_months", "Last 3 months").value("last_6_months", (Object)"last_6_months", "Last 6 months").value("last_12_months", (Object)"last_12_months", "Last 12 months").build();

    @Inject
    public GraphQLSchemaBuilder(SchemaRegistry schemaRegistry, AtlasDiscoveryService discoveryService, AtlasTypeRegistry typeRegistry, AtlasGraph graph) {
        try {
            DataCatalogConfig dataCatalogConfig = new DataCatalogConfig(schemaRegistry.config().originalProperties());
            this.timeoutMs = dataCatalogConfig.catalogGraphQLTimeoutMs();
            int numThreads = dataCatalogConfig.catalogGraphQLNumThreads();
            this.executor = new ThreadPoolExecutor(numThreads, numThreads * 2, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("graphql-query-%d").build());
            this.schemaRegistry = (KafkaSchemaRegistry)schemaRegistry;
            this.discoveryService = discoveryService;
            this.typeRegistry = typeRegistry;
            this.graph = graph;
            this.entityRetriever = new CfltEntityGraphRetriever(graph, typeRegistry);
        }
        catch (RestConfigException e) {
            throw new IllegalArgumentException("Could not instantiate GraphQLSchemaBuilder", e);
        }
    }

    public GraphQLSchema getGraphQLSchema() {
        GraphQLSchema.Builder schema = GraphQLSchema.newSchema().query(this.getQueryType());
        return schema.build();
    }

    private GraphQLObjectType getQueryType() {
        Set allSuperTypes = this.typeRegistry.getAllEntityTypes().stream().flatMap(e -> e.getSuperTypes().stream()).collect(Collectors.toSet());
        GraphQLCodeRegistry.Builder codeRegistry = GraphQLCodeRegistry.newCodeRegistry();
        GraphQLObjectType.Builder queryType = GraphQLObjectType.newObject().name(QUERY_ROOT).description("GraphQL schema for all catalog entities");
        queryType.fields(this.typeRegistry.getAllEntityTypes().stream().filter(this::isNotIgnored).map(e -> this.getQueryFieldDefinition(codeRegistry, (AtlasEntityType)e, allSuperTypes.contains(e.getTypeName()), false)).collect(Collectors.toList()));
        queryType.fields(this.typeRegistry.getAllEntityTypes().stream().filter(this::isNotIgnored).map(e -> this.getQueryFieldDefinition(codeRegistry, (AtlasEntityType)e, allSuperTypes.contains(e.getTypeName()), true)).collect(Collectors.toList()));
        codeRegistry.build();
        return queryType.build();
    }

    private GraphQLFieldDefinition getQueryFieldDefinition(GraphQLCodeRegistry.Builder codeRegistry, AtlasEntityType entityType, boolean isSuperType, boolean isEntityCount) {
        GraphQLImplementingType implementingType = this.getImplementingType(codeRegistry, entityType, isSuperType, isEntityCount);
        GraphQLQueryFactory queryFactory = GraphQLQueryFactory.builder().withDiscoveryService(this.discoveryService).withTypeRegistry(this.typeRegistry).withEntityTypeName(entityType.getTypeName()).withImplementingType(implementingType).build();
        String typeName = this.getTypeName(entityType, isEntityCount);
        return GraphQLFieldDefinition.newFieldDefinition().name(typeName).description(entityType.getEntityDef().getDescription()).type((GraphQLOutputType)new GraphQLList((GraphQLType)implementingType)).dataFetcher(TimeoutAsyncDataFetcher.timeoutAsync(new EntityFetcher(this.schemaRegistry, queryFactory), this.executor, this.timeoutMs)).argument(this.getWhereArgument(entityType)).argument(this.getBusinessMetadataArgument(entityType)).argument(this.getTagsArgument(entityType)).argument(this.getLimitArgument(entityType)).argument(this.getOffsetArgument(entityType)).argument(this.getOrderByArgument(entityType)).argument(this.getDeletedArgument(entityType)).build();
    }

    private String getTypeName(AtlasEntityType entityType, boolean isEntityCount) {
        return isEntityCount ? entityType.getTypeName() + ENTITY_COUNT_SUFFIX : entityType.getTypeName();
    }

    private GraphQLArgument getWhereArgument(AtlasEntityType entityType) {
        return this.whereArgumentsMap.computeIfAbsent(entityType.getTypeName(), k -> this.computeWhereArgument(entityType));
    }

    private GraphQLArgument computeWhereArgument(AtlasEntityType entityType) {
        String typeName = entityType.getTypeName() + "_criteria";
        GraphQLInputObjectType whereInputObject = GraphQLInputObjectType.newInputObject().name(typeName).description("Where logical specification of the provided list of criteria expressions").field(GraphQLInputObjectField.newInputObjectField().name(Logical.OR.symbol()).description("Logical operation for expressions").type((GraphQLInputType)new GraphQLList((GraphQLType)new GraphQLTypeReference(typeName))).build()).field(GraphQLInputObjectField.newInputObjectField().name(Logical.AND.symbol()).description("Logical operation for expressions").type((GraphQLInputType)new GraphQLList((GraphQLType)new GraphQLTypeReference(typeName))).build()).fields(entityType.getAllAttributes().values().stream().filter(this::isNotIgnored).flatMap(attr -> this.getWhereInputField(entityType, (AtlasStructType.AtlasAttribute)attr)).collect(Collectors.toList())).build();
        return GraphQLArgument.newArgument().name(WHERE_PARAM_NAME).description("Where logical specification").type((GraphQLInputType)whereInputObject).build();
    }

    private Stream<GraphQLInputObjectField> getWhereInputField(AtlasEntityType entityType, AtlasStructType.AtlasAttribute attribute) {
        return this.getWhereAttributeType(entityType, attribute).filter(Objects::nonNull).map(type -> GraphQLInputObjectField.newInputObjectField().name(attribute.getName()).description(attribute.getAttributeDef().getDescription()).type(type).build());
    }

    private Stream<GraphQLInputType> getWhereAttributeType(AtlasEntityType entityType, AtlasStructType.AtlasAttribute attribute) {
        String typeName = entityType.getTypeName() + "_" + attribute.getName() + "_criteria";
        if (this.whereAttributesMap.containsKey(typeName)) {
            return Stream.of(this.whereAttributesMap.get(typeName));
        }
        AtlasType type = attribute.getAttributeType();
        if (type instanceof AtlasArrayType || type instanceof AtlasMapType) {
            return Stream.empty();
        }
        GraphQLType attributeType = this.getBasicAttributeType(type);
        if (attributeType == null) {
            return Stream.empty();
        }
        GraphQLInputObjectType.Builder builder = GraphQLInputObjectType.newInputObject().name(typeName).description("Criteria expression specification of " + attribute.getName() + " attribute in entity " + entityType.getTypeName()).field(GraphQLInputObjectField.newInputObjectField().name(PredicateFilter.Criteria.EQ.symbol()).description("Equals criteria").type((GraphQLInputType)attributeType).build()).field(GraphQLInputObjectField.newInputObjectField().name(PredicateFilter.Criteria.LTE.symbol()).description("Less than or equals criteria").type((GraphQLInputType)attributeType).build()).field(GraphQLInputObjectField.newInputObjectField().name(PredicateFilter.Criteria.GTE.symbol()).description("Greater or equals criteria").type((GraphQLInputType)attributeType).build()).field(GraphQLInputObjectField.newInputObjectField().name(PredicateFilter.Criteria.GT.symbol()).description("Greater than criteria").type((GraphQLInputType)attributeType).build()).field(GraphQLInputObjectField.newInputObjectField().name(PredicateFilter.Criteria.LT.symbol()).description("Less than criteria").type((GraphQLInputType)attributeType).build());
        if (type instanceof AtlasBuiltInTypes.AtlasStringType || type instanceof AtlasEnumType) {
            builder.field(GraphQLInputObjectField.newInputObjectField().name(PredicateFilter.Criteria.STARTS_WITH.symbol()).description("Starts with criteria").type((GraphQLInputType)attributeType).build());
        } else if (type instanceof AtlasBuiltInTypes.AtlasDateType) {
            builder.field(GraphQLInputObjectField.newInputObjectField().name(PredicateFilter.Criteria.BETWEEN.symbol()).description("Between criteria").type((GraphQLInputType)betweenObject).build()).field(GraphQLInputObjectField.newInputObjectField().name(PredicateFilter.Criteria.SINCE.symbol()).description("Since criteria").type((GraphQLInputType)sinceEnum).build());
        }
        GraphQLInputObjectType answer = builder.build();
        this.whereAttributesMap.putIfAbsent(typeName, (GraphQLInputType)answer);
        return Stream.of(answer);
    }

    private GraphQLArgument getBusinessMetadataArgument(AtlasEntityType entityType) {
        return GraphQLArgument.newArgument().name("business_metadata").description("Limit the result set to entities with the given business metadata attributes").type((GraphQLInputType)new GraphQLList((GraphQLType)bmAttributeInputObject)).build();
    }

    private GraphQLArgument getTagsArgument(AtlasEntityType entityType) {
        return GraphQLArgument.newArgument().name("tags").description("Limit the result set to entities with the given tag").type((GraphQLInputType)new GraphQLList((GraphQLType)Scalars.GraphQLString)).build();
    }

    private GraphQLArgument getLimitArgument(AtlasEntityType entityType) {
        return GraphQLArgument.newArgument().name(LIMIT_PARAM_NAME).description("Limit the result set to the given number").type((GraphQLInputType)Scalars.GraphQLInt).build();
    }

    private GraphQLArgument getOffsetArgument(AtlasEntityType entityType) {
        return GraphQLArgument.newArgument().name(OFFSET_PARAM_NAME).description("Start offset for the result set").type((GraphQLInputType)Scalars.GraphQLInt).build();
    }

    private GraphQLArgument getOrderByArgument(AtlasEntityType entityType) {
        return this.orderByArgumentsMap.computeIfAbsent(entityType.getTypeName(), k -> this.computeOrderByArgument(entityType));
    }

    private GraphQLArgument computeOrderByArgument(AtlasEntityType entityType) {
        String typeName = entityType.getTypeName() + "_order";
        GraphQLInputObjectType orderByInputObject = GraphQLInputObjectType.newInputObject().name(typeName).description("Order by attribute").fields(entityType.getAllAttributes().values().stream().filter(this::isNotIgnored).map(attr -> this.getOrderByInputField(entityType, (AtlasStructType.AtlasAttribute)attr)).collect(Collectors.toList())).build();
        return GraphQLArgument.newArgument().name(ORDER_BY_PARAM_NAME).description("Order by specification").type((GraphQLInputType)new GraphQLList((GraphQLType)orderByInputObject)).build();
    }

    private GraphQLInputObjectField getOrderByInputField(AtlasEntityType entityType, AtlasStructType.AtlasAttribute attribute) {
        return GraphQLInputObjectField.newInputObjectField().name(attribute.getName()).description(attribute.getAttributeDef().getDescription()).type((GraphQLInputType)orderByDirectionEnum).build();
    }

    private GraphQLArgument getDeletedArgument(AtlasEntityType entityType) {
        return GraphQLArgument.newArgument().name(DELETED_PARAM_NAME).description("Whether to include deleted entities").type((GraphQLInputType)Scalars.GraphQLBoolean).build();
    }

    private GraphQLImplementingType getImplementingType(GraphQLCodeRegistry.Builder codeRegistry, AtlasEntityType entityType, boolean isSuperType, boolean isEntityCount) {
        String typeName = this.getTypeName(entityType, isEntityCount);
        return this.entityCache.computeIfAbsent(typeName, k -> this.computeImplementingType(codeRegistry, entityType, isSuperType, isEntityCount));
    }

    private GraphQLImplementingType computeImplementingType(GraphQLCodeRegistry.Builder codeRegistry, AtlasEntityType entityType, boolean isSuperType, boolean isEntityCount) {
        GraphQLObjectType.Builder builder;
        String typeName = this.getTypeName(entityType, isEntityCount);
        GraphQLTypeReference[] interfaces = (GraphQLTypeReference[])entityType.getAllSuperTypes().stream().filter(this::isNotIgnored).map(GraphQLTypeReference::new).toArray(GraphQLTypeReference[]::new);
        List attrFields = entityType.getAllAttributes().values().stream().filter(this::isNotIgnored).flatMap(attr -> this.getObjectField(codeRegistry, entityType, (AtlasStructType.AtlasAttribute)attr, false)).collect(Collectors.toList());
        List relAttrFields = entityType.getRelationshipAttributes().entrySet().stream().filter(e -> !((String)e.getKey()).startsWith("__")).flatMap(e -> ((Map)e.getValue()).values().stream()).flatMap(attr -> this.getObjectField(codeRegistry, entityType, (AtlasStructType.AtlasAttribute)attr, true)).collect(Collectors.toCollection(ArrayList::new));
        if (typeName.startsWith("sr_") && !entityType.getRelationshipAttributes().containsKey(SCHEMA_ATTR_NAME)) {
            String schemaTypeName = SchemaAtlasTypes.SR_SCHEMA.getName();
            AtlasEntityType schemaEntityType = this.typeRegistry.getEntityTypeByName(schemaTypeName);
            relAttrFields.add(GraphQLFieldDefinition.newFieldDefinition().name(SCHEMA_ATTR_NAME).description("Schema for the entity").type((GraphQLOutputType)new GraphQLTypeReference(schemaTypeName)).dataFetcher((DataFetcher)new AttributeFetcher(this.typeRegistry, this.graph, this.entityRetriever, entityType.getTypeName(), SCHEMA_ATTR_NAME, schemaEntityType)).argument(this.getWhereArgument(schemaEntityType)).argument(this.getBusinessMetadataArgument(schemaEntityType)).argument(this.getTagsArgument(schemaEntityType)).build());
        }
        GraphQLFieldDefinition tagDefs = GraphQLFieldDefinition.newFieldDefinition().name(TAG_DEFS_ATTR_NAME).description("List of tag defs associated with the entity").type((GraphQLOutputType)new GraphQLList((GraphQLType)tagDef)).dataFetcher((DataFetcher)new AttributeFetcher(this.typeRegistry, this.graph, this.entityRetriever, entityType.getTypeName(), TAG_DEFS_ATTR_NAME)).build();
        if (isSuperType) {
            builder = GraphQLInterfaceType.newInterface().name(typeName).description(entityType.getEntityDef().getDescription()).fields(attrFields).fields(relAttrFields).field(tagDefs).field(GraphQLFieldDefinition.newFieldDefinition().name(ENTITY_STATUS_ATTR_NAME).description("Status of the entity").type((GraphQLOutputType)entityStatusEnum).dataFetcher((DataFetcher)new AttributeFetcher(this.typeRegistry, this.graph, this.entityRetriever, entityType.getTypeName(), ENTITY_STATUS_ATTR_NAME)).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("business_metadata").description("Business metadata for the entity").type((GraphQLOutputType)new GraphQLList((GraphQLType)bmAttributeObject)).dataFetcher((DataFetcher)new AttributeFetcher(this.typeRegistry, this.graph, this.entityRetriever, entityType.getTypeName(), "business_metadata")).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("tags").description("Tags for the entity").type((GraphQLOutputType)new GraphQLList((GraphQLType)Scalars.GraphQLString)).dataFetcher((DataFetcher)new AttributeFetcher(this.typeRegistry, this.graph, this.entityRetriever, entityType.getTypeName(), "tags")).build()).typeResolver((TypeResolver)new EntityResolver());
            for (GraphQLTypeReference type : interfaces) {
                builder.withInterface(type);
            }
            if (isEntityCount) {
                builder.field(GraphQLFieldDefinition.newFieldDefinition().name(ENTITY_COUNT).type((GraphQLOutputType)Scalars.GraphQLInt).dataFetcher((DataFetcher)new DummyCountFetcher()).build());
            }
            return builder.build();
        }
        builder = GraphQLObjectType.newObject().name(typeName).description(entityType.getEntityDef().getDescription()).fields(attrFields).fields(relAttrFields).field(tagDefs).field(GraphQLFieldDefinition.newFieldDefinition().name(ENTITY_STATUS_ATTR_NAME).description("Status of the entity").type((GraphQLOutputType)entityStatusEnum).dataFetcher((DataFetcher)new AttributeFetcher(this.typeRegistry, this.graph, this.entityRetriever, entityType.getTypeName(), ENTITY_STATUS_ATTR_NAME)).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("business_metadata").description("Business metadata for the entity").type((GraphQLOutputType)new GraphQLList((GraphQLType)bmAttributeObject)).dataFetcher((DataFetcher)new AttributeFetcher(this.typeRegistry, this.graph, this.entityRetriever, entityType.getTypeName(), "business_metadata")).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("tags").description("Tags for the entity").type((GraphQLOutputType)new GraphQLList((GraphQLType)Scalars.GraphQLString)).dataFetcher((DataFetcher)new AttributeFetcher(this.typeRegistry, this.graph, this.entityRetriever, entityType.getTypeName(), "tags")).build()).withInterfaces(interfaces);
        if (isEntityCount) {
            builder.field(GraphQLFieldDefinition.newFieldDefinition().name(ENTITY_COUNT).type((GraphQLOutputType)Scalars.GraphQLInt).dataFetcher((DataFetcher)new DummyCountFetcher()).build());
        }
        return builder.build();
    }

    private Stream<GraphQLFieldDefinition> getObjectField(GraphQLCodeRegistry.Builder codeRegistry, AtlasEntityType entityType, AtlasStructType.AtlasAttribute attribute, boolean isRelationship) {
        AtlasEntityType relType;
        ArrayList<GraphQLArgument> arguments = new ArrayList<GraphQLArgument>();
        Map.Entry<Optional<String>, Stream<GraphQLType>> attrType = this.getAttributeType(entityType, attribute);
        if (isRelationship && attrType.getKey().isPresent()) {
            relType = this.typeRegistry.getEntityTypeByName(attrType.getKey().get());
            arguments.add(this.getWhereArgument(relType));
            arguments.add(this.getBusinessMetadataArgument(relType));
            arguments.add(this.getTagsArgument(relType));
        } else {
            relType = null;
        }
        return attrType.getValue().filter(type -> type instanceof GraphQLOutputType).map(type -> GraphQLFieldDefinition.newFieldDefinition().name(GraphQLSchemaBuilder.alias(attribute.getName())).description(this.getAttributeDescription(attribute)).type((GraphQLOutputType)type).dataFetcher((DataFetcher)new AttributeFetcher(this.typeRegistry, this.graph, this.entityRetriever, entityType.getTypeName(), attribute.getName(), relType)).arguments(arguments).build());
    }

    private GraphQLType getBasicAttributeType(AtlasType type) {
        if (type instanceof AtlasBuiltInTypes.AtlasStringType) {
            return Scalars.GraphQLString;
        }
        if (type instanceof AtlasBuiltInTypes.AtlasByteType) {
            return ExtendedScalars.GraphQLByte;
        }
        if (type instanceof AtlasBuiltInTypes.AtlasIntType) {
            return Scalars.GraphQLInt;
        }
        if (type instanceof AtlasBuiltInTypes.AtlasShortType) {
            return ExtendedScalars.GraphQLShort;
        }
        if (type instanceof AtlasBuiltInTypes.AtlasFloatType || type instanceof AtlasBuiltInTypes.AtlasDoubleType) {
            return Scalars.GraphQLFloat;
        }
        if (type instanceof AtlasBuiltInTypes.AtlasLongType) {
            return ExtendedScalars.GraphQLLong;
        }
        if (type instanceof AtlasBuiltInTypes.AtlasBooleanType) {
            return Scalars.GraphQLBoolean;
        }
        if (type instanceof AtlasBuiltInTypes.AtlasBigDecimalType) {
            return ExtendedScalars.GraphQLBigDecimal;
        }
        if (type instanceof AtlasBuiltInTypes.AtlasBigIntegerType) {
            return ExtendedScalars.GraphQLBigInteger;
        }
        if (type instanceof AtlasBuiltInTypes.AtlasDateType) {
            return JavaScalars.GraphQLDate;
        }
        if (type instanceof AtlasEnumType) {
            return this.getTypeFromJavaType(type);
        }
        if (type instanceof AtlasArrayType) {
            return this.getTypeFromJavaType(type);
        }
        if (type instanceof AtlasMapType) {
            return this.getTypeFromJavaType(type);
        }
        throw new UnsupportedOperationException("Class could not be mapped to GraphQL: '" + type.getClass().getTypeName() + "'");
    }

    private Map.Entry<Optional<String>, Stream<GraphQLType>> getAttributeType(AtlasEntityType entityType, AtlasStructType.AtlasAttribute attribute) {
        String typeName = entityType.getTypeName();
        String relationshipName = attribute.getRelationshipName();
        if (relationshipName == null) {
            try {
                GraphQLType type = this.getBasicAttributeType(attribute.getAttributeType());
                return type != null ? new AbstractMap.SimpleEntry<Optional<String>, Stream<GraphQLType>>(Optional.empty(), Stream.of(type)) : new AbstractMap.SimpleEntry(Optional.empty(), Stream.empty());
            }
            catch (UnsupportedOperationException type) {}
        } else {
            AtlasRelationshipEndDef otherRel;
            AtlasRelationshipEndDef thisRel;
            AtlasRelationshipType relationshipType = this.typeRegistry.getRelationshipTypeByName(relationshipName);
            AtlasRelationshipDef relationshipDef = relationshipType.getRelationshipDef();
            if (attribute.getRelationshipEdgeDirection() == AtlasStructType.AtlasAttribute.AtlasRelationshipEdgeDirection.OUT) {
                thisRel = relationshipDef.getEndDef1();
                otherRel = relationshipDef.getEndDef2();
            } else {
                thisRel = relationshipDef.getEndDef2();
                otherRel = relationshipDef.getEndDef1();
            }
            if (!this.isNotIgnored(otherRel.getType())) {
                return new AbstractMap.SimpleEntry<Optional<String>, Stream<GraphQLType>>(Optional.empty(), Stream.empty());
            }
            String otherRelType = otherRel.getType();
            switch (thisRel.getCardinality()) {
                case SINGLE: {
                    return new AbstractMap.SimpleEntry<Optional<String>, Stream<GraphQLType>>(Optional.of(otherRelType), Stream.of(new GraphQLTypeReference(otherRelType)));
                }
                case LIST: 
                case SET: {
                    return new AbstractMap.SimpleEntry<Optional<String>, Stream<GraphQLType>>(Optional.of(otherRelType), Stream.of(new GraphQLList((GraphQLType)new GraphQLTypeReference(otherRelType))));
                }
            }
            throw new IllegalArgumentException();
        }
        throw new UnsupportedOperationException("Attribute could not be mapped to GraphQL: field '" + attribute.getName() + "' of entity '" + typeName + "'");
    }

    private String getAttributeDescription(AtlasStructType.AtlasAttribute attribute) {
        String relationshipName = attribute.getRelationshipName();
        if (relationshipName == null) {
            return attribute.getAttributeDef().getDescription();
        }
        AtlasRelationshipType relationshipType = this.typeRegistry.getRelationshipTypeByName(relationshipName);
        AtlasRelationshipDef relationshipDef = relationshipType.getRelationshipDef();
        AtlasRelationshipEndDef thisRel = attribute.getRelationshipEdgeDirection() == AtlasStructType.AtlasAttribute.AtlasRelationshipEdgeDirection.OUT ? relationshipDef.getEndDef1() : relationshipDef.getEndDef2();
        return thisRel.getDescription();
    }

    private boolean isNotIgnored(AtlasEntityType entityType) {
        return this.isNotIgnored(entityType.getTypeName());
    }

    private boolean isNotIgnored(String typeName) {
        return ModelConstants.hasValidPrefix(typeName);
    }

    private boolean isNotIgnored(AtlasStructType.AtlasAttribute attribute) {
        return !attribute.getName().startsWith("__");
    }

    private GraphQLType getTypeFromJavaType(AtlasType type) {
        String typeName = type.getTypeName();
        if (type instanceof AtlasEnumType) {
            AtlasEnumType enumType = (AtlasEnumType)type;
            if (this.typeCache.containsKey(typeName)) {
                return this.typeCache.get(typeName);
            }
            GraphQLEnumType.Builder enumBuilder = GraphQLEnumType.newEnum().name(typeName);
            for (AtlasEnumDef.AtlasEnumElementDef elementDef : enumType.getEnumDef().getElementDefs()) {
                enumBuilder.value(elementDef.getValue(), (Object)elementDef.getOrdinal());
            }
            GraphQLEnumType answer = enumBuilder.build();
            this.typeCache.put(typeName, (GraphQLType)answer);
            return answer;
        }
        if (type instanceof AtlasArrayType) {
            AtlasArrayType arrayType = (AtlasArrayType)type;
            try {
                return GraphQLList.list((GraphQLType)this.getBasicAttributeType(arrayType.getElementType()));
            }
            catch (UnsupportedOperationException e) {
                return null;
            }
        }
        if (type instanceof AtlasMapType) {
            return ExtendedScalars.Object;
        }
        throw new UnsupportedOperationException("Class could not be mapped to GraphQL: '" + type.getClass().getTypeName() + "'");
    }

    static String alias(String attrName) {
        return attrName.equals("tags") ? RULE_TAGS_ATTR_NAME : attrName;
    }

    static String unalias(String attrName) {
        return attrName.equals(RULE_TAGS_ATTR_NAME) ? "tags" : attrName;
    }
}

