/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.web.graphql.schema.util;

import graphql.GraphQLError;
import graphql.PublicApi;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.DataFetcherExceptionHandlerParameters;
import graphql.execution.DataFetcherExceptionHandlerResult;
import graphql.execution.ResultPath;
import graphql.language.SourceLocation;
import graphql.util.LogKit;
import io.confluent.catalog.web.graphql.schema.util.DefaultGraphQLError;
import java.util.concurrent.CompletionException;
import org.slf4j.Logger;

@PublicApi
public class DefaultDataFetcherExceptionHandler
implements DataFetcherExceptionHandler {
    private static final Logger logNotSafe = LogKit.getNotPrivacySafeLogger(DefaultDataFetcherExceptionHandler.class);

    public DataFetcherExceptionHandlerResult onException(DataFetcherExceptionHandlerParameters handlerParameters) {
        Throwable exception = this.unwrap(handlerParameters.getException());
        SourceLocation sourceLocation = handlerParameters.getSourceLocation();
        ResultPath path = handlerParameters.getPath();
        DefaultGraphQLError error = new DefaultGraphQLError(path, exception, sourceLocation);
        logNotSafe.warn(error.getMessage(), exception);
        return DataFetcherExceptionHandlerResult.newResult().error((GraphQLError)error).build();
    }

    protected Throwable unwrap(Throwable exception) {
        if (exception.getCause() != null && exception instanceof CompletionException) {
            return exception.getCause();
        }
        return exception;
    }
}

