/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.web.graphql.schema.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.atlas.discovery.SearchContext;
import org.apache.atlas.model.discovery.SearchParameters;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graph.GraphHelper;
import org.apache.atlas.type.AtlasArrayType;
import org.apache.atlas.type.AtlasClassificationType;
import org.apache.atlas.type.AtlasEnumType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.util.SearchPredicateUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.PredicateUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchPredicates {
    private static final Logger LOG = LoggerFactory.getLogger(SearchPredicates.class);
    public static final char CUSTOM_ATTR_SEPARATOR = '=';
    public static final String CUSTOM_ATTR_SEARCH_FORMAT = "\"\\\"%s\\\":\\\"%s\\\"\"";
    public static final String CUSTOM_ATTR_SEARCH_FORMAT_GRAPH = "\"%s\":\"%s\"";
    private static final Map<SearchParameters.Operator, SearchPredicateUtil.ElementAttributePredicateGenerator> OP_PREDICATES = new HashMap<SearchParameters.Operator, SearchPredicateUtil.ElementAttributePredicateGenerator>();

    public static Predicate toInMemoryPredicate(AtlasTypeRegistry typeRegistry, AtlasStructType structType, SearchParameters.FilterCriteria criteria, List<String> classificationNames) {
        Predicate attrPredicate;
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        Predicate traitPredicate = SearchPredicates.toInMemoryTraitPredicate(typeRegistry, classificationNames);
        if (traitPredicate != null) {
            predicates.add(traitPredicate);
        }
        if ((attrPredicate = SearchPredicates.toInMemoryAttrPredicate(structType, criteria)) != null) {
            predicates.add(attrPredicate);
        }
        if (CollectionUtils.isNotEmpty(predicates)) {
            return PredicateUtils.allPredicate(predicates);
        }
        return null;
    }

    public static Predicate toInMemoryTraitPredicate(AtlasTypeRegistry typeRegistry, List<String> classificationNames) {
        Predicate traitPredicate;
        if (classificationNames.isEmpty()) {
            return null;
        }
        List<AtlasClassificationType> classificationTypes = SearchPredicates.getClassificationTypes(typeRegistry, classificationNames);
        AtlasClassificationType classificationType = null;
        if (CollectionUtils.isNotEmpty(classificationTypes)) {
            classificationType = classificationTypes.iterator().next();
        }
        if (classificationType == SearchContext.MATCH_ALL_CLASSIFICATION_TYPES) {
            traitPredicate = PredicateUtils.orPredicate((Predicate)SearchPredicateUtil.getNotEmptyPredicateGenerator().generatePredicate(Constants.TRAIT_NAMES_PROPERTY_KEY, null, List.class), (Predicate)SearchPredicateUtil.getNotEmptyPredicateGenerator().generatePredicate(Constants.PROPAGATED_TRAIT_NAMES_PROPERTY_KEY, null, List.class));
        } else if (classificationType == SearchContext.MATCH_ALL_NOT_CLASSIFIED) {
            traitPredicate = PredicateUtils.andPredicate((Predicate)SearchPredicateUtil.getIsNullOrEmptyPredicateGenerator().generatePredicate(Constants.TRAIT_NAMES_PROPERTY_KEY, null, List.class), (Predicate)SearchPredicateUtil.getIsNullOrEmptyPredicateGenerator().generatePredicate(Constants.PROPAGATED_TRAIT_NAMES_PROPERTY_KEY, null, List.class));
        } else if (SearchPredicates.isWildCardSearch(classificationNames)) {
            ArrayList predicates = new ArrayList();
            classificationNames.forEach(classificationName -> {
                String regexString = SearchPredicates.getRegexString("\\|" + classificationName + "\\|");
                predicates.add(SearchPredicateUtil.getRegexPredicateGenerator().generatePredicate(Constants.CLASSIFICATION_NAMES_KEY, (Object)regexString, String.class));
                predicates.add(SearchPredicateUtil.getRegexPredicateGenerator().generatePredicate(Constants.PROPAGATED_CLASSIFICATION_NAMES_KEY, (Object)regexString, String.class));
            });
            traitPredicate = PredicateUtils.anyPredicate(predicates);
        } else {
            traitPredicate = PredicateUtils.orPredicate((Predicate)SearchPredicateUtil.getContainsAnyPredicateGenerator().generatePredicate(Constants.TRAIT_NAMES_PROPERTY_KEY, classificationNames, List.class), (Predicate)SearchPredicateUtil.getContainsAnyPredicateGenerator().generatePredicate(Constants.PROPAGATED_TRAIT_NAMES_PROPERTY_KEY, classificationNames, List.class));
        }
        return traitPredicate;
    }

    private static boolean isWildCardSearch(List<String> classificationNames) {
        if (CollectionUtils.isNotEmpty(classificationNames)) {
            return classificationNames.stream().anyMatch(classification -> classification.contains("*"));
        }
        return false;
    }

    private static List<AtlasClassificationType> getClassificationTypes(AtlasTypeRegistry typeRegistry, List<String> classificationNames) {
        if (CollectionUtils.isNotEmpty(classificationNames)) {
            return classificationNames.stream().map(n -> SearchPredicates.getClassificationType(typeRegistry, n)).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return null;
    }

    private static AtlasClassificationType getClassificationType(AtlasTypeRegistry typeRegistry, String classificationName) {
        AtlasClassificationType ret = StringUtils.equals((String)classificationName, (String)SearchContext.MATCH_ALL_WILDCARD_CLASSIFICATION.getTypeName()) ? SearchContext.MATCH_ALL_WILDCARD_CLASSIFICATION : (StringUtils.equals((String)classificationName, (String)SearchContext.MATCH_ALL_CLASSIFIED.getTypeName()) ? SearchContext.MATCH_ALL_CLASSIFIED : (StringUtils.equals((String)classificationName, (String)SearchContext.MATCH_ALL_NOT_CLASSIFIED.getTypeName()) ? SearchContext.MATCH_ALL_NOT_CLASSIFIED : (StringUtils.equals((String)classificationName, (String)"_ALL_CLASSIFICATION_TYPES") ? SearchContext.MATCH_ALL_CLASSIFICATION_TYPES : typeRegistry.getClassificationTypeByName(classificationName))));
        return ret;
    }

    public static Predicate toInMemoryAttrPredicate(AtlasStructType structType, SearchParameters.FilterCriteria criteria) {
        if (criteria.getCondition() != null && CollectionUtils.isNotEmpty((Collection)criteria.getCriterion())) {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            for (SearchParameters.FilterCriteria filterCriteria : criteria.getCriterion()) {
                Predicate predicate = SearchPredicates.toInMemoryAttrPredicate(structType, filterCriteria);
                if (predicate == null) continue;
                predicates.add(predicate);
            }
            if (CollectionUtils.isNotEmpty(predicates)) {
                if (criteria.getCondition() == SearchParameters.FilterCriteria.Condition.AND) {
                    return PredicateUtils.allPredicate(predicates);
                }
                return PredicateUtils.anyPredicate(predicates);
            }
        } else if (StringUtils.isNotEmpty((String)criteria.getAttributeName())) {
            String attrName = criteria.getAttributeName();
            String attrValue = criteria.getAttributeValue();
            SearchParameters.Operator operator = criteria.getOperator();
            if (operator == SearchParameters.Operator.TIME_RANGE) {
                SearchParameters.FilterCriteria processedRangeCriteria = SearchPredicates.processDateRange(criteria);
                attrValue = processedRangeCriteria.getAttributeValue();
            }
            if (SearchPredicates.isPipeSeparatedSystemAttribute(attrName)) {
                SearchParameters.FilterCriteria processedCriteria = SearchPredicates.processPipeSeperatedSystemAttribute(attrName, operator, attrValue);
                attrValue = processedCriteria.getAttributeValue();
                operator = processedCriteria.getOperator();
            }
            return SearchPredicates.toInMemoryPredicate(structType, attrName, operator, attrValue);
        }
        return null;
    }

    private static boolean isPipeSeparatedSystemAttribute(String attrName) {
        return StringUtils.equals((String)attrName, (String)Constants.CLASSIFICATION_NAMES_KEY) || StringUtils.equals((String)attrName, (String)Constants.PROPAGATED_CLASSIFICATION_NAMES_KEY) || StringUtils.equals((String)attrName, (String)Constants.LABELS_PROPERTY_KEY) || StringUtils.equals((String)attrName, (String)Constants.CUSTOM_ATTRIBUTES_PROPERTY_KEY);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static SearchParameters.FilterCriteria processDateRange(SearchParameters.FilterCriteria criteria) {
        SearchParameters.FilterCriteria ret;
        String attrVal;
        SearchParameters.Operator op;
        String attrName;
        block35: {
            LocalDateTime endTime;
            LocalDateTime startTime;
            block36: {
                attrName = criteria.getAttributeName();
                op = criteria.getOperator();
                attrVal = criteria.getAttributeValue();
                ret = new SearchParameters.FilterCriteria();
                LocalDateTime now = LocalDateTime.now();
                switch (attrVal) {
                    case "LAST_7_DAYS": {
                        startTime = now.minusDays(6L).withHour(0).withMinute(0).withSecond(0).withNano(0);
                        endTime = startTime.plusDays(7L).minusNanos(1L);
                        break;
                    }
                    case "LAST_30_DAYS": {
                        startTime = now.minusDays(29L).withHour(0).withMinute(0).withSecond(0).withNano(0);
                        endTime = startTime.plusDays(30L).minusNanos(1L);
                        break;
                    }
                    case "LAST_MONTH": {
                        startTime = now.minusMonths(1L).withDayOfMonth(1).withHour(0).withMinute(0).withSecond(0).withNano(0);
                        endTime = startTime.plusMonths(1L).minusNanos(1L);
                        break;
                    }
                    case "THIS_MONTH": {
                        startTime = now.withDayOfMonth(1).withHour(0).withMinute(0).withSecond(0).withNano(0);
                        endTime = startTime.plusMonths(1L).minusNanos(1L);
                        break;
                    }
                    case "TODAY": {
                        startTime = now.withHour(0).withMinute(0).withSecond(0).withNano(0);
                        endTime = startTime.plusDays(1L).minusNanos(1L);
                        break;
                    }
                    case "YESTERDAY": {
                        startTime = now.minusDays(1L).withHour(0).withMinute(0).withSecond(0).withNano(0);
                        endTime = startTime.plusDays(1L).minusNanos(1L);
                        break;
                    }
                    case "THIS_YEAR": {
                        startTime = now.withDayOfYear(1).withDayOfMonth(1).withHour(0).withMinute(0).withSecond(0).withNano(0);
                        endTime = startTime.plusYears(1L).minusNanos(1L);
                        break;
                    }
                    case "LAST_YEAR": {
                        startTime = now.minusYears(1L).withDayOfYear(1).withHour(0).withMinute(0).withSecond(0).withNano(0);
                        endTime = startTime.plusYears(1L).minusNanos(1L);
                        break;
                    }
                    case "THIS_QUARTER": {
                        startTime = now.minusMonths(1L).withDayOfMonth(1).withHour(0).withMinute(0).withSecond(0).withNano(0);
                        endTime = startTime.plusMonths(3L).minusNanos(1L);
                        break;
                    }
                    case "LAST_QUARTER": {
                        startTime = now.minusMonths(4L).withDayOfMonth(1).withHour(0).withMinute(0).withSecond(0).withNano(0);
                        endTime = startTime.plusMonths(3L).minusNanos(1L);
                        break;
                    }
                    case "LAST_3_MONTHS": {
                        startTime = now.minusMonths(3L).withDayOfMonth(1).withHour(0).withMinute(0).withSecond(0).withNano(0);
                        endTime = startTime.plusMonths(3L).minusNanos(1L);
                        break;
                    }
                    case "LAST_6_MONTHS": {
                        startTime = now.minusMonths(6L).withDayOfMonth(1).withHour(0).withMinute(0).withSecond(0).withNano(0);
                        endTime = startTime.plusMonths(6L).minusNanos(1L);
                        break;
                    }
                    case "LAST_12_MONTHS": {
                        startTime = now.minusMonths(12L).withDayOfMonth(1).withHour(0).withMinute(0).withSecond(0).withNano(0);
                        endTime = startTime.plusMonths(12L).minusNanos(1L);
                        break;
                    }
                    default: {
                        startTime = null;
                        endTime = null;
                    }
                }
                if (startTime != null && endTime != null) break block36;
                String[] rangeAttr = attrVal.split(",");
                boolean numeric = true;
                if (rangeAttr.length != 2) {
                    LOG.error("Separator invalid");
                    break block35;
                } else {
                    try {
                        Long.parseLong(String.valueOf(rangeAttr[0]));
                        Long.parseLong(String.valueOf(rangeAttr[1]));
                    }
                    catch (NumberFormatException e) {
                        numeric = false;
                        if (!numeric) {
                            LOG.error("Attributes passed need to be LONG");
                        }
                        break block35;
                    }
                }
            }
            attrVal = Timestamp.valueOf(startTime).getTime() + "," + Timestamp.valueOf(endTime).getTime();
        }
        ret.setAttributeName(attrName);
        ret.setOperator(op);
        ret.setAttributeValue(attrVal);
        return ret;
    }

    private static SearchParameters.FilterCriteria processPipeSeperatedSystemAttribute(String attrName, SearchParameters.Operator op, String attrVal) {
        SearchParameters.FilterCriteria ret = new SearchParameters.FilterCriteria();
        if (op != null && attrVal != null) {
            switch (op) {
                case STARTS_WITH: {
                    attrVal = "|" + attrVal;
                    op = SearchParameters.Operator.CONTAINS;
                    break;
                }
                case ENDS_WITH: {
                    attrVal = attrVal + "|";
                    op = SearchParameters.Operator.CONTAINS;
                    break;
                }
                case EQ: {
                    attrVal = GraphHelper.getDelimitedClassificationNames(Collections.singleton(attrVal));
                    op = SearchParameters.Operator.CONTAINS;
                    break;
                }
                case NEQ: {
                    attrVal = GraphHelper.getDelimitedClassificationNames(Collections.singleton(attrVal));
                    op = SearchParameters.Operator.NOT_CONTAINS;
                    break;
                }
                case CONTAINS: 
                case NOT_CONTAINS: {
                    if (!attrName.equals(Constants.CUSTOM_ATTRIBUTES_PROPERTY_KEY)) break;
                    attrVal = SearchPredicates.getCustomAttributeIndexQueryValue(attrVal, true);
                    break;
                }
            }
        }
        ret.setAttributeName(attrName);
        ret.setOperator(op);
        ret.setAttributeValue(attrVal);
        return ret;
    }

    private static String getCustomAttributeIndexQueryValue(String attrValue, boolean forGraphQuery) {
        String ret = null;
        if (StringUtils.isNotEmpty((String)attrValue)) {
            String value;
            int separatorIdx = attrValue.indexOf(61);
            String key = separatorIdx != -1 ? attrValue.substring(0, separatorIdx) : null;
            String string = value = key != null ? attrValue.substring(separatorIdx + 1) : null;
            ret = key != null && value != null ? (forGraphQuery ? String.format(CUSTOM_ATTR_SEARCH_FORMAT_GRAPH, key, value) : String.format(CUSTOM_ATTR_SEARCH_FORMAT, key, value)) : attrValue;
        }
        return ret;
    }

    private static Predicate toInMemoryPredicate(AtlasStructType type, String attrName, SearchParameters.Operator op, String attrVal) {
        Predicate ret = null;
        AtlasStructType.AtlasAttribute attribute = type.getAttribute(attrName);
        SearchPredicateUtil.ElementAttributePredicateGenerator predicate = OP_PREDICATES.get(op);
        if (attribute != null && predicate != null) {
            Object attrValue;
            Class attrClass;
            AtlasType attrType = attribute.getAttributeType();
            Long attrValue2 = null;
            switch (attrType.getTypeName()) {
                case "string": {
                    attrClass = String.class;
                    attrValue = attrVal;
                    break;
                }
                case "short": {
                    attrClass = Short.class;
                    attrValue = StringUtils.isEmpty((String)attrVal) ? null : Short.valueOf(Short.parseShort(attrVal));
                    break;
                }
                case "int": {
                    attrClass = Integer.class;
                    attrValue = StringUtils.isEmpty((String)attrVal) ? null : Integer.valueOf(Integer.parseInt(attrVal));
                    break;
                }
                case "biginteger": {
                    attrClass = BigInteger.class;
                    attrValue = StringUtils.isEmpty((String)attrVal) ? null : new BigInteger(attrVal);
                    break;
                }
                case "boolean": {
                    attrClass = Boolean.class;
                    attrValue = StringUtils.isEmpty((String)attrVal) ? null : Boolean.valueOf(Boolean.parseBoolean(attrVal));
                    break;
                }
                case "byte": {
                    attrClass = Byte.class;
                    attrValue = StringUtils.isEmpty((String)attrVal) ? null : Byte.valueOf(Byte.parseByte(attrVal));
                    break;
                }
                case "long": 
                case "date": {
                    String[] parts;
                    attrClass = Long.class;
                    String rangeStart = "";
                    String rangeEnd = "";
                    if (op == SearchParameters.Operator.TIME_RANGE && (parts = attrVal.split(",")).length == 2) {
                        rangeStart = parts[0];
                        rangeEnd = parts[1];
                    }
                    if (StringUtils.isNotEmpty((String)rangeStart) && StringUtils.isNotEmpty((String)rangeEnd)) {
                        attrValue = Long.parseLong(rangeStart);
                        attrValue2 = Long.parseLong(rangeEnd);
                        break;
                    }
                    attrValue = StringUtils.isEmpty((String)attrVal) ? null : Long.valueOf(Long.parseLong(attrVal));
                    break;
                }
                case "float": {
                    attrClass = Float.class;
                    attrValue = StringUtils.isEmpty((String)attrVal) ? null : Float.valueOf(Float.parseFloat(attrVal));
                    break;
                }
                case "double": {
                    attrClass = Double.class;
                    attrValue = StringUtils.isEmpty((String)attrVal) ? null : Double.valueOf(Double.parseDouble(attrVal));
                    break;
                }
                case "bigdecimal": {
                    attrClass = BigDecimal.class;
                    attrValue = StringUtils.isEmpty((String)attrVal) ? null : new BigDecimal(attrVal);
                    break;
                }
                default: {
                    attrClass = attrType instanceof AtlasEnumType ? String.class : (attrType instanceof AtlasArrayType ? List.class : Object.class);
                    attrValue = attrVal;
                }
            }
            String vertexPropertyName = attribute.getVertexPropertyName();
            ret = attrValue != null && attrValue2 != null ? predicate.generatePredicate(StringUtils.isEmpty((String)vertexPropertyName) ? attribute.getQualifiedName() : vertexPropertyName, attrValue, attrValue2, attrClass) : predicate.generatePredicate(StringUtils.isEmpty((String)vertexPropertyName) ? attribute.getQualifiedName() : vertexPropertyName, attrValue, attrClass);
        }
        return ret;
    }

    private static String getRegexString(String value) {
        return ".*" + value.replace("*", ".*") + ".*";
    }

    static {
        OP_PREDICATES.put(SearchParameters.Operator.LT, SearchPredicateUtil.getLTPredicateGenerator());
        OP_PREDICATES.put(SearchParameters.Operator.GT, SearchPredicateUtil.getGTPredicateGenerator());
        OP_PREDICATES.put(SearchParameters.Operator.LTE, SearchPredicateUtil.getLTEPredicateGenerator());
        OP_PREDICATES.put(SearchParameters.Operator.GTE, SearchPredicateUtil.getGTEPredicateGenerator());
        OP_PREDICATES.put(SearchParameters.Operator.EQ, SearchPredicateUtil.getEQPredicateGenerator());
        OP_PREDICATES.put(SearchParameters.Operator.NEQ, SearchPredicateUtil.getNEQPredicateGenerator());
        OP_PREDICATES.put(SearchParameters.Operator.IN, SearchPredicateUtil.getINPredicateGenerator());
        OP_PREDICATES.put(SearchParameters.Operator.LIKE, SearchPredicateUtil.getLIKEPredicateGenerator());
        OP_PREDICATES.put(SearchParameters.Operator.STARTS_WITH, SearchPredicateUtil.getStartsWithPredicateGenerator());
        OP_PREDICATES.put(SearchParameters.Operator.ENDS_WITH, SearchPredicateUtil.getEndsWithPredicateGenerator());
        OP_PREDICATES.put(SearchParameters.Operator.CONTAINS, SearchPredicateUtil.getContainsPredicateGenerator());
        OP_PREDICATES.put(SearchParameters.Operator.NOT_CONTAINS, SearchPredicateUtil.getNotContainsPredicateGenerator());
        OP_PREDICATES.put(SearchParameters.Operator.IS_NULL, SearchPredicateUtil.getIsNullPredicateGenerator());
        OP_PREDICATES.put(SearchParameters.Operator.NOT_NULL, SearchPredicateUtil.getNotNullPredicateGenerator());
        OP_PREDICATES.put(SearchParameters.Operator.NOT_EMPTY, SearchPredicateUtil.getNotEmptyPredicateGenerator());
        OP_PREDICATES.put(SearchParameters.Operator.TIME_RANGE, SearchPredicateUtil.getInRangePredicateGenerator());
    }
}

