/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.web.rest.resources;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import io.confluent.catalog.DataCatalogConfig;
import io.confluent.catalog.model.ModelConstants;
import io.confluent.catalog.model.instance.BusinessMetadata;
import io.confluent.catalog.model.instance.SchemaMetadata;
import io.confluent.catalog.model.instance.Tag;
import io.confluent.catalog.storage.MetadataRegistry;
import io.confluent.catalog.util.CatalogTenantUtils;
import io.confluent.catalog.util.QualifiedNameGenerator;
import io.confluent.catalog.util.RbacConstants;
import io.confluent.catalog.util.RbacException;
import io.confluent.catalog.util.RbacUtils;
import io.confluent.catalog.web.rest.entities.BusinessMetadataResponse;
import io.confluent.catalog.web.rest.entities.SchemaTagsResponse;
import io.confluent.catalog.web.rest.entities.TagResponse;
import io.confluent.catalog.web.rest.resources.SchemaRegistryResource;
import io.confluent.catalog.web.util.Servlets;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.rest.exceptions.Errors;
import io.confluent.kafka.schemaregistry.rest.resources.DocumentedName;
import io.confluent.kafka.schemaregistry.rest.resources.RequestHeaderBuilder;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import io.confluent.rest.RestConfigException;
import io.confluent.rest.annotations.PerformanceMetric;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasRelatedObjectId;
import org.apache.atlas.model.instance.AtlasStruct;
import org.apache.atlas.model.instance.EntityMutationResponse;
import org.apache.atlas.repository.store.graph.AtlasEntityStore;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Path(value="catalog/v1/entity")
@Singleton
@Service
@Produces(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json; qs=0.9", "application/json; qs=0.5"})
@Consumes(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json", "application/json"})
public class EntityResource
extends SchemaRegistryResource {
    private static final Logger LOG = LoggerFactory.getLogger(EntityResource.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String CORE_PATH = "catalog/v1/entity";
    private static final String TAG_PATH = "/tags";
    private static final String SCHEMA_TAG_PATH = "/schematags";
    private static final String BUSINESSMETADATA_PATH = "/businessmetadata";
    private final MetadataRegistry registry;
    private final AtlasTypeRegistry typeRegistry;
    private final AtlasEntityStore entityStore;
    private final Set<String> modifiableAttrs;
    private final String modifiableAttrsPrefix;
    private final RequestHeaderBuilder requestHeaderBuilder = new RequestHeaderBuilder();

    @Inject
    public EntityResource(SchemaRegistry schemaRegistry, MetadataRegistry registry, AtlasTypeRegistry typeRegistry, AtlasEntityStore entityStore) {
        super(schemaRegistry);
        try {
            DataCatalogConfig dataCatalogConfig = new DataCatalogConfig(schemaRegistry.config().originalProperties());
            this.registry = registry;
            this.typeRegistry = typeRegistry;
            this.entityStore = entityStore;
            HashSet<String> modifiableAttrs = new HashSet<String>(dataCatalogConfig.catalogEntityModifiableAttrs());
            modifiableAttrs.add("qualifiedName");
            modifiableAttrs.add("tenant");
            this.modifiableAttrs = modifiableAttrs;
            this.modifiableAttrsPrefix = dataCatalogConfig.catalogEntityModifiableAttrsPrefix();
        }
        catch (RestConfigException e) {
            throw new IllegalArgumentException("Could not instantiate TypesResource", e);
        }
    }

    @GET
    @Path(value="/type/{typeName}/name/{qualifiedName}")
    @PerformanceMetric(value="catalog.entity.get-entity")
    @Operation(summary="Fetch complete definition of an entity given its type and unique attribute.", description="Fetch complete definition of an entity given its type and unique attribute.", responses={@ApiResponse(responseCode="200", description="The entity", content={@Content(schema=@Schema(implementation=AtlasEntity.AtlasEntityWithExtInfo.class))}), @ApiResponse(responseCode="400", description="Bad Request"), @ApiResponse(responseCode="404", description="Entity not found"), @ApiResponse(responseCode="429", description="Rate Limit Error"), @ApiResponse(responseCode="500", description="Internal Server Error")})
    @DocumentedName(value="getEntityByTypeAndName")
    public AtlasEntity.AtlasEntityWithExtInfo getByUniqueAttributes(@Parameter(description="The type of the entity") @PathParam(value="typeName") String typeName, @Parameter(description="The qualified name of the entity") @PathParam(value="qualifiedName") String qualifiedName, @Parameter(description="Whether to only populate header and schema attributes") @QueryParam(value="minExtInfo") @DefaultValue(value="false") boolean minExtInfo, @Parameter(description="Whether to ignore relationships") @QueryParam(value="ignoreRelationships") @DefaultValue(value="false") boolean ignoreRelationships, @Parameter(description="If not null, include internal attributes that start with this prefix") @QueryParam(value="includeInternalPrefix") String includeInternalPrefix) throws AtlasBaseException {
        Servlets.validateQueryParamLength("typeName", typeName);
        Servlets.validateQueryParamLength("qualifiedName", qualifiedName);
        LOG.debug("Get entity: typeName {}, qualifiedName {}, minExtInfo {}, ignoreRelationships {}, includeInternalPrefix {}", new Object[]{typeName, qualifiedName, minExtInfo, ignoreRelationships, includeInternalPrefix});
        String tenant = this.getSchemaRegistry().tenant();
        AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = this.registry.getEntity(tenant, typeName, qualifiedName, minExtInfo, ignoreRelationships);
        if (entityWithExtInfo == null || this.registry.isEntityDeprecated(entityWithExtInfo)) {
            throw new AtlasBaseException(AtlasErrorCode.INSTANCE_BY_UNIQUE_ATTRIBUTE_NOT_FOUND, new String[]{typeName, qualifiedName});
        }
        this.scrubInternalAttributes(entityWithExtInfo, includeInternalPrefix);
        return entityWithExtInfo;
    }

    private void scrubInternalAttributes(AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo, String includeInternalPrefix) {
        AtlasEntity entity = entityWithExtInfo.getEntity();
        Map oldAttrsList = entity.getAttributes();
        HashMap newAttrsList = new HashMap();
        if (oldAttrsList != null && !oldAttrsList.isEmpty()) {
            for (Map.Entry entry : oldAttrsList.entrySet()) {
                String attrName = (String)entry.getKey();
                if (attrName.startsWith("__") && (includeInternalPrefix == null || !attrName.startsWith("__" + includeInternalPrefix))) continue;
                newAttrsList.put(entry.getKey(), entry.getValue());
            }
        }
        entity.setAttributes(newAttrsList);
    }

    @PUT
    @PerformanceMetric(value="catalog.entity.partial-update-entity")
    @DocumentedName(value="partialEntityUpdate")
    public void partialUpdateByUniqueAttributes(@Suspended AsyncResponse asyncResponse, @Context HttpHeaders headers, AtlasEntity.AtlasEntityWithExtInfo entity) throws AtlasBaseException {
        LOG.debug("Partially update entity: entity {}", (Object)entity);
        if (entity == null || entity.getEntity() == null) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{"no entity to update"});
        }
        Map headerProperties = this.requestHeaderBuilder.buildRequestHeaders(headers, this.getSchemaRegistry().config().whitelistHeaders());
        String tenant = this.getSchemaRegistry().tenant();
        EntityResource.ensureEntityUpdate(entity.getEntity(), tenant);
        if (entity.getReferredEntities() != null) {
            for (AtlasEntity referredEntity : entity.getReferredEntities().values()) {
                EntityResource.ensureEntityUpdate(referredEntity, tenant);
            }
        }
        for (String attrName : entity.getEntity().getAttributes().keySet()) {
            if (this.modifiableAttrs.contains(attrName) || attrName.startsWith(this.modifiableAttrsPrefix)) continue;
            AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(entity.getEntity().getTypeName());
            AtlasStructType.AtlasAttribute attr = entityType.getAttribute(attrName);
            AtlasType attrType = attr.getAttributeType();
            throw new AtlasBaseException(AtlasErrorCode.ATTRIBUTE_UPDATE_NOT_SUPPORTED, new String[]{attrName, attrType.getTypeName()});
        }
        try {
            EntityMutationResponse ret = this.registry.partiallyUpdateEntityOrForward(tenant, entity, headerProperties);
            asyncResponse.resume((Object)ret);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException((String)"Error while partially updating entity", (Throwable)e);
        }
    }

    protected static void ensureEntityUpdate(AtlasEntity entity, String tenant) throws AtlasBaseException {
        entity.setAttribute("tenant", (Object)tenant);
        String typeName = entity.getTypeName();
        if (!ModelConstants.hasValidPrefix(typeName)) {
            throw new AtlasBaseException(AtlasErrorCode.UNKNOWN_TYPENAME, new String[]{typeName});
        }
        String qualifiedName = (String)entity.getAttribute("qualifiedName");
        if (qualifiedName == null) {
            throw new AtlasBaseException(AtlasErrorCode.MISSING_MANDATORY_QUALIFIED_NAME, new String[0]);
        }
        String entityQualifiedName = QualifiedNameGenerator.ensureEntityTenantPrefix(tenant, typeName, qualifiedName);
        entity.setAttribute("qualifiedName", (Object)entityQualifiedName);
        Map relationshipAttrs = entity.getRelationshipAttributes();
        if (relationshipAttrs != null) {
            for (Map.Entry entry : relationshipAttrs.entrySet()) {
                Map map;
                Object uniqueAttrs;
                Object relAttrs = entry.getValue();
                if (!(relAttrs instanceof Map) || !((uniqueAttrs = (map = (Map)relAttrs).get("uniqueAttributes")) instanceof Map)) continue;
                EntityResource.ensureEntityTenantPrefixForQualifiedName(tenant, typeName, (Map)uniqueAttrs);
            }
        }
    }

    private static void ensureEntityTenantPrefixForQualifiedName(String tenant, String typeName, Map<String, Object> map) {
        Object qualifiedName = map.get("qualifiedName");
        if (qualifiedName != null) {
            String newQualifiedName = QualifiedNameGenerator.ensureEntityTenantPrefix(tenant, typeName, qualifiedName.toString());
            map.put("qualifiedName", newQualifiedName);
        }
    }

    @GET
    @Path(value="/type/{typeName}/name/{qualifiedName}/tags")
    @PerformanceMetric(value="catalog.entity.get-tags")
    @Operation(summary="Gets the list of classifications for a given entity represented by a qualifed name.", description="Gets the list of classifications for a given entity represented by a qualifed name.", responses={@ApiResponse(responseCode="200", description="The tags", content={@Content(array=@ArraySchema(schema=@Schema(implementation=TagResponse.class)))}), @ApiResponse(responseCode="400", description="Bad Request"), @ApiResponse(responseCode="404", description="Entity not found"), @ApiResponse(responseCode="429", description="Rate Limit Error"), @ApiResponse(responseCode="500", description="Internal Server Error")})
    @DocumentedName(value="getTags")
    public List<TagResponse> getTags(@Parameter(description="The type of the entity") @PathParam(value="typeName") String typeName, @Parameter(description="The qualified name of the entity") @PathParam(value="qualifiedName") String qualifiedName) throws AtlasBaseException {
        Servlets.validateQueryParamLength("typeName", typeName);
        Servlets.validateQueryParamLength("qualifiedName", qualifiedName);
        LOG.debug("Get entity tags: typeName {}, qualifiedName {}", (Object)typeName, (Object)qualifiedName);
        String tenant = this.getSchemaRegistry().tenant();
        String entityQualifiedName = QualifiedNameGenerator.ensureEntityTenantPrefix(tenant, typeName, qualifiedName);
        String guid = this.registry.getGuid(tenant, typeName, qualifiedName);
        List classifications = this.entityStore.getClassifications(guid);
        List<TagResponse> tags = classifications.stream().map(classification -> new TagResponse(new Tag((AtlasClassification)classification, typeName, entityQualifiedName))).collect(Collectors.toList());
        return tags;
    }

    @POST
    @Path(value="/tags")
    @PerformanceMetric(value="catalog.entity.create-tags")
    @Operation(summary="Bulk API to create multiple tags.", description="Bulk API to create multiple tags.", responses={@ApiResponse(responseCode="200", description="The tags. Errored tags will have an additional error property.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=TagResponse.class)))}), @ApiResponse(responseCode="400", description="Bad Request"), @ApiResponse(responseCode="429", description="Rate Limit Error"), @ApiResponse(responseCode="500", description="Internal Server Error")})
    @DocumentedName(value="createTags")
    public void createTags(@Suspended AsyncResponse asyncResponse, @Context HttpHeaders headers, @Parameter(description="The tags") List<Tag> tags) throws AtlasBaseException {
        LOG.debug("Create entity tags: tags {}", tags);
        Map headerProperties = this.requestHeaderBuilder.buildRequestHeaders(headers, this.getSchemaRegistry().config().whitelistHeaders());
        String tenant = this.getSchemaRegistry().tenant();
        for (Tag tag : tags) {
            tag.ensureTenantPrefix(tenant);
            String typeName = tag.getEntityType();
            String qualifiedName = tag.getEntityName();
            this.registry.getGuid(tenant, typeName, qualifiedName);
            tag.setEntityName(qualifiedName);
        }
        try {
            List<TagResponse> ret = this.registry.createTagsOrForward(this.getSchemaRegistry().tenant(), tags, headerProperties);
            asyncResponse.resume(ret);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException((String)"Error while creating tags", (Throwable)e);
        }
    }

    @PUT
    @Path(value="/tags")
    @PerformanceMetric(value="catalog.entity.update-tags")
    @Operation(summary="Bulk API to update multiple tags.", description="Bulk API to update multiple tags.", responses={@ApiResponse(responseCode="200", description="The tags. Errored tags will have an additional error property.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=TagResponse.class)))}), @ApiResponse(responseCode="400", description="Bad Request"), @ApiResponse(responseCode="429", description="Rate Limit Error"), @ApiResponse(responseCode="500", description="Internal Server Error")})
    @DocumentedName(value="updateTags")
    public void updateTags(@Suspended AsyncResponse asyncResponse, @Context HttpHeaders headers, @Parameter(description="The tags") List<Tag> tags) throws AtlasBaseException {
        LOG.debug("Update entity tags: tags {}", tags);
        Map headerProperties = this.requestHeaderBuilder.buildRequestHeaders(headers, this.getSchemaRegistry().config().whitelistHeaders());
        String tenant = this.getSchemaRegistry().tenant();
        for (Tag tag : tags) {
            tag.ensureTenantPrefix(tenant);
            String typeName = tag.getEntityType();
            String qualifiedName = tag.getEntityName();
            this.registry.getGuid(tenant, typeName, qualifiedName);
            tag.setEntityName(qualifiedName);
        }
        try {
            List<TagResponse> ret = this.registry.updateTagsOrForward(this.getSchemaRegistry().tenant(), tags, headerProperties);
            asyncResponse.resume(ret);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException((String)"Error while updating tags", (Throwable)e);
        }
    }

    @DELETE
    @Path(value="/type/{typeName}/name/{qualifiedName}/tags/{tagName}")
    @PerformanceMetric(value="catalog.entity.delete-tag")
    @Operation(summary="Delete a tag on an entity.", description="Delete a tag on an entity.", responses={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="400", description="Bad Request"), @ApiResponse(responseCode="429", description="Rate Limit Error"), @ApiResponse(responseCode="500", description="Internal Server Error")})
    @DocumentedName(value="deleteTag")
    public void deleteTag(@Suspended AsyncResponse asyncResponse, @Context HttpHeaders headers, @Parameter(description="The type of the entity") @PathParam(value="typeName") String typeName, @Parameter(description="The qualified name of the entity") @PathParam(value="qualifiedName") String qualifiedName, @Parameter(description="The name of the tag") @PathParam(value="tagName") String tagName) throws AtlasBaseException {
        LOG.debug("Delete entity tag: typeName {}, qualifiedName {}, tagName {}", new Object[]{typeName, qualifiedName, tagName});
        Map headerProperties = this.requestHeaderBuilder.buildRequestHeaders(headers, this.getSchemaRegistry().config().whitelistHeaders());
        String tenant = this.getSchemaRegistry().tenant();
        String qualifiedTagName = QualifiedNameGenerator.ensureTypeTenantPrefix(tenant, tagName);
        String entityQualifiedName = QualifiedNameGenerator.ensureEntityTenantPrefix(tenant, typeName, qualifiedName);
        try {
            this.registry.deleteTagOrForward(this.getSchemaRegistry().tenant(), typeName, entityQualifiedName, qualifiedTagName, headerProperties);
            asyncResponse.resume((Object)Response.status((int)204).build());
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException((String)"Error while deleting tag", (Throwable)e);
        }
    }

    @GET
    @Path(value="/type/{typeName}/name/{qualifiedName}/businessmetadata")
    @PerformanceMetric(value="catalog.entity.get-businessmetadata")
    @Operation(summary="Gets the list of business metadata for a given entity represented by a qualified name.", description="Gets the list of business metadata for a given entity represented by a qualified name.", responses={@ApiResponse(responseCode="200", description="The business metadata", content={@Content(array=@ArraySchema(schema=@Schema(implementation=BusinessMetadataResponse.class)))}), @ApiResponse(responseCode="400", description="Bad Request"), @ApiResponse(responseCode="404", description="Entity not found"), @ApiResponse(responseCode="429", description="Rate Limit Error"), @ApiResponse(responseCode="500", description="Internal Server Error")})
    @DocumentedName(value="getBusinessMetadata")
    public List<BusinessMetadataResponse> getBusinessMetadata(@Parameter(description="The type of the entity") @PathParam(value="typeName") String typeName, @Parameter(description="The qualified name of the entity") @PathParam(value="qualifiedName") String qualifiedName) throws AtlasBaseException {
        Servlets.validateQueryParamLength("typeName", typeName);
        Servlets.validateQueryParamLength("qualifiedName", qualifiedName);
        LOG.debug("Get entity business metadata: typeName {}, qualifiedName {}", (Object)typeName, (Object)qualifiedName);
        String tenant = this.getSchemaRegistry().tenant();
        String entityQualifiedName = QualifiedNameGenerator.ensureEntityTenantPrefix(tenant, typeName, qualifiedName);
        String guid = this.registry.getGuid(tenant, typeName, qualifiedName);
        Map businessAttributes = this.entityStore.getById(guid).getEntity().getBusinessAttributes();
        if (businessAttributes == null) {
            return new ArrayList<BusinessMetadataResponse>();
        }
        return businessAttributes.entrySet().stream().map(bm -> new BusinessMetadataResponse(new BusinessMetadata(new AtlasStruct((String)bm.getKey(), (Map)bm.getValue()), typeName, entityQualifiedName))).collect(Collectors.toList());
    }

    @POST
    @Path(value="/businessmetadata")
    @PerformanceMetric(value="catalog.entity.create-businessmetadata")
    @Operation(summary="Bulk API to create multiple business metadata.", description="Bulk API to create multiple business metadata.", responses={@ApiResponse(responseCode="200", description="The business metadata. Errored business metadata will have an additional error property.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=BusinessMetadataResponse.class)))}), @ApiResponse(responseCode="400", description="Bad Request"), @ApiResponse(responseCode="429", description="Rate Limit Error"), @ApiResponse(responseCode="500", description="Internal Server Error")})
    @DocumentedName(value="createBusinessMetadata")
    public void createBusinessMetadata(@Suspended AsyncResponse asyncResponse, @Context HttpHeaders headers, @Parameter(description="The business metadata") List<BusinessMetadata> bms) throws AtlasBaseException {
        LOG.debug("Create entity business metadata: bms {}", bms);
        Map headerProperties = this.requestHeaderBuilder.buildRequestHeaders(headers, this.getSchemaRegistry().config().whitelistHeaders());
        String tenant = this.getSchemaRegistry().tenant();
        for (BusinessMetadata bm : bms) {
            bm.ensureTenantPrefix(tenant);
            String typeName = bm.getEntityType();
            String qualifiedName = bm.getEntityName();
            this.registry.getGuid(tenant, typeName, qualifiedName);
            bm.setEntityName(qualifiedName);
            bm.setAttribute("__bmName", QualifiedNameGenerator.stripTypeTenantPrefix(tenant, bm.getTypeName()));
        }
        try {
            List<BusinessMetadataResponse> ret = this.registry.createBusinessMetadataOrForward(this.getSchemaRegistry().tenant(), bms, headerProperties);
            asyncResponse.resume(ret);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException((String)"Error while creating business metadata", (Throwable)e);
        }
    }

    @PUT
    @Path(value="/businessmetadata")
    @PerformanceMetric(value="catalog.entity.update-businessmetadata")
    @Operation(summary="Bulk API to update multiple business metadata.", description="Bulk API to update multiple business metadata.", responses={@ApiResponse(responseCode="200", description="The business metadata. Errored business metadata will have an additional error property.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=BusinessMetadataResponse.class)))}), @ApiResponse(responseCode="400", description="Bad Request"), @ApiResponse(responseCode="429", description="Rate Limit Error"), @ApiResponse(responseCode="500", description="Internal Server Error")})
    @DocumentedName(value="updateBusinessMetadata")
    public void updateBusinessMetadata(@Suspended AsyncResponse asyncResponse, @Context HttpHeaders headers, @Parameter(description="The business metadata") List<BusinessMetadata> bms) throws AtlasBaseException {
        LOG.debug("Update entity business metadata: bms {}", bms);
        Map headerProperties = this.requestHeaderBuilder.buildRequestHeaders(headers, this.getSchemaRegistry().config().whitelistHeaders());
        String tenant = this.getSchemaRegistry().tenant();
        for (BusinessMetadata bm : bms) {
            bm.ensureTenantPrefix(tenant);
            String typeName = bm.getEntityType();
            String qualifiedName = bm.getEntityName();
            this.registry.getGuid(tenant, typeName, qualifiedName);
            bm.setEntityName(qualifiedName);
            bm.setAttribute("__bmName", QualifiedNameGenerator.stripTypeTenantPrefix(tenant, bm.getTypeName()));
        }
        try {
            List<BusinessMetadataResponse> ret = this.registry.updateBusinessMetadataOrForward(this.getSchemaRegistry().tenant(), bms, headerProperties);
            asyncResponse.resume(ret);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException((String)"Error while updating business metadata", (Throwable)e);
        }
    }

    @DELETE
    @Path(value="/type/{typeName}/name/{qualifiedName}/businessmetadata/{bmName}")
    @PerformanceMetric(value="catalog.entity.delete-businessmetadata")
    @Operation(summary="Delete a business metadata on an entity.", description="Delete a business metadata on an entity.", responses={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="400", description="Bad Request"), @ApiResponse(responseCode="429", description="Rate Limit Error"), @ApiResponse(responseCode="500", description="Internal Server Error")})
    @DocumentedName(value="deleteBusinessMetadata")
    public void deleteBusinessMetadata(@Suspended AsyncResponse asyncResponse, @Context HttpHeaders headers, @Parameter(description="The type of the entity") @PathParam(value="typeName") String typeName, @Parameter(description="The qualified name of the entity") @PathParam(value="qualifiedName") String qualifiedName, @Parameter(description="The name of the business metadata") @PathParam(value="bmName") String bmName) throws AtlasBaseException {
        LOG.debug("Delete entity business metadata: typeName {}, qualifiedName {}, bmName {}", new Object[]{typeName, qualifiedName, bmName});
        Map headerProperties = this.requestHeaderBuilder.buildRequestHeaders(headers, this.getSchemaRegistry().config().whitelistHeaders());
        String tenant = this.getSchemaRegistry().tenant();
        String qualifiedBMName = QualifiedNameGenerator.ensureTypeTenantPrefix(tenant, bmName);
        String entityQualifiedName = QualifiedNameGenerator.ensureEntityTenantPrefix(tenant, typeName, qualifiedName);
        try {
            this.registry.deleteBusinessMetadataOrForward(this.getSchemaRegistry().tenant(), typeName, entityQualifiedName, qualifiedBMName, headerProperties);
            asyncResponse.resume((Object)Response.status((int)204).build());
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException((String)"Error while deleting business metadata", (Throwable)e);
        }
    }

    @Deprecated
    @POST
    @Path(value="/schematags")
    @PerformanceMetric(value="catalog.entity.update-schematags")
    @Operation(summary="Bulk API to update schema metadata.", description="Bulk API to create schema subject versions, each new version has the provided field or record level schema tags embedded (or remove) in the schema string, as well as the given metadata and ruleset.", responses={@ApiResponse(responseCode="200", description="The subjects. Errored subject will have an additional error property.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=SchemaTagsResponse.class)))}), @ApiResponse(responseCode="400", description="Bad Request"), @ApiResponse(responseCode="429", description="Rate Limit Error"), @ApiResponse(responseCode="500", description="Internal Server Error")})
    @DocumentedName(value="updateSchemaTags")
    public void updateSchemaTags(@Suspended AsyncResponse asyncResponse, @Context HttpHeaders headers, @Parameter(description="The schema metadata per subject") List<SchemaMetadata> schemaMetadataList) throws AtlasBaseException {
        LOG.info("Update schema metadata: {}", schemaMetadataList);
        Map headerProperties = this.requestHeaderBuilder.buildRequestHeaders(headers, this.getSchemaRegistry().config().whitelistHeaders());
        try {
            List<SchemaTagsResponse> ret = this.registry.updateSchemaMetadataOrForward(this.getSchemaRegistry().tenant(), schemaMetadataList, headerProperties);
            asyncResponse.resume(ret);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException((String)"Error while updating schema metadata", (Throwable)e);
        }
    }

    private AtlasEntityType ensureEntityType(String typeName) throws AtlasBaseException {
        AtlasEntityType ret = this.typeRegistry.getEntityTypeByName(typeName);
        if (ret == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_INVALID, new String[]{TypeCategory.ENTITY.name(), typeName});
        }
        return ret;
    }

    private void validateEntity(String tenant, AtlasEntity.AtlasEntityWithExtInfo entity, AtlasErrorCode errorCode, String ... errorParams) throws AtlasBaseException {
        String tenantValue = (String)entity.getEntity().getAttribute("tenant");
        if (!tenant.equals(tenantValue)) {
            throw new AtlasBaseException(errorCode, errorParams);
        }
    }

    @Override
    public SchemaRegistryResource.RbacPermissionEntity getRequestRbacPermissionEntity(ContainerRequestContext requestContext) throws Exception {
        String httpMethod = requestContext.getMethod();
        if (httpMethod.equalsIgnoreCase("GET")) {
            return null;
        }
        String cluster = this.getSchemaRegistry().tenant();
        String resourceType = "";
        UriInfo uri = requestContext.getUriInfo();
        if (StringUtils.containsIgnoreCase((CharSequence)uri.getPath(), (CharSequence)"catalog/v1/entity/tags") || StringUtils.containsIgnoreCase((CharSequence)uri.getPath(), (CharSequence)"catalog/v1/entity/schematags")) {
            resourceType = RbacConstants.RbacResourceTypes.CatalogTag.getLabel();
        } else if (StringUtils.containsIgnoreCase((CharSequence)uri.getPath(), (CharSequence)"catalog/v1/entity/businessmetadata")) {
            resourceType = RbacConstants.RbacResourceTypes.CatalogBusinessMetadata.getLabel();
        } else if (StringUtils.containsIgnoreCase((CharSequence)uri.getPath(), (CharSequence)CORE_PATH) && StringUtils.containsIgnoreCase((CharSequence)uri.getPath(), (CharSequence)TAG_PATH)) {
            resourceType = RbacConstants.RbacResourceTypes.CatalogTag.getLabel();
        } else if (StringUtils.containsIgnoreCase((CharSequence)uri.getPath(), (CharSequence)CORE_PATH) && StringUtils.containsIgnoreCase((CharSequence)uri.getPath(), (CharSequence)BUSINESSMETADATA_PATH)) {
            resourceType = RbacConstants.RbacResourceTypes.CatalogBusinessMetadata.getLabel();
        } else if (StringUtils.containsIgnoreCase((CharSequence)uri.getPath(), (CharSequence)CORE_PATH)) {
            resourceType = RbacConstants.RbacResourceTypes.CatalogEntity.getLabel();
        } else {
            LOG.info("Invalid resourceType sent. uri {}", (Object)requestContext.getUriInfo().getPath());
            return null;
        }
        List<SchemaRegistryResource.RbacPermissionAction> permissionList = null;
        if (httpMethod.equalsIgnoreCase("POST") || httpMethod.equalsIgnoreCase("PUT")) {
            permissionList = this.getResourcesForWriteRequest(requestContext, resourceType, cluster);
        } else if (httpMethod.equalsIgnoreCase("DELETE")) {
            permissionList = this.getResourcesForDeleteRequest(requestContext, cluster);
        }
        return new SchemaRegistryResource.RbacPermissionEntity(permissionList, cluster);
    }

    @Override
    public SchemaRegistryResource.RbacPermissionEntity getResponseRbacPermissionEntity(ContainerRequestContext requestContext, ContainerResponseContext responseContext, String resourceMethod) throws Exception {
        String httpMethod = requestContext.getMethod();
        if (!httpMethod.equalsIgnoreCase("GET")) {
            return null;
        }
        String cluster = this.getSchemaRegistry().tenant();
        List<SchemaRegistryResource.RbacPermissionAction> permissionList = null;
        switch (resourceMethod) {
            case "getTags": {
                permissionList = this.getRbacPermissionsTags(responseContext, cluster);
                break;
            }
            case "getByUniqueAttributes": {
                permissionList = this.getRbacPermissionsUniqueAttributes(responseContext, cluster);
                break;
            }
            case "getBusinessMetadata": {
                permissionList = this.getRbacPermissionsBusinessMetaData(responseContext, cluster);
                break;
            }
            default: {
                throw new RbacException("Unhandled resourceMethod");
            }
        }
        return permissionList != null ? new SchemaRegistryResource.RbacPermissionEntity(permissionList, cluster) : null;
    }

    private List<SchemaRegistryResource.RbacPermissionAction> getRbacPermissionActionForEntity(String typeName, String qualifiedName, String tenant, RbacConstants.RbacOperations operation, String resourceMessage) throws Exception {
        RbacConstants.RbacResourceTypes rbacType = RbacUtils.toRbacResourceType(typeName);
        if (rbacType == null) {
            LOG.error("Null entity type: {}", (Object)typeName);
            throw new RbacException("Null entity type");
        }
        switch (rbacType) {
            case CatalogSubject: {
                return this.getSREntityRbacPermissionActions(typeName, qualifiedName, tenant, operation);
            }
            case CatalogTopic: {
                String[] names;
                String resourceName = QualifiedNameGenerator.stripEntityTenantPrefix(tenant, typeName, qualifiedName);
                if (resourceName.startsWith("lkc-") && (names = QualifiedNameGenerator.parseQualifiedName(resourceName)).length > 1) {
                    resourceName = names[1];
                }
                return Collections.singletonList(new SchemaRegistryResource.RbacPermissionAction(resourceName, RbacConstants.RbacResourceTypes.CatalogTopic, operation));
            }
            case CatalogConnector: {
                AtlasEntity.AtlasEntityWithExtInfo connectorEntity = this.getEntityByTypeAndQualifiedName(tenant, typeName, qualifiedName);
                String connectorName = (String)connectorEntity.getEntity().getAttribute("name");
                return Collections.singletonList(new SchemaRegistryResource.RbacPermissionAction(connectorName, RbacConstants.RbacResourceTypes.CatalogConnector, operation));
            }
            case CatalogPipeline: 
            case CatalogEnvironment: 
            case CatalogKafkaCluster: {
                return this.getSingleEntityPermissionActionWithId(rbacType, operation, tenant, typeName, qualifiedName);
            }
            case CatalogKafkaClusterLink: {
                AtlasEntity.AtlasEntityWithExtInfo clusterLinkEntity = this.getEntityByTypeAndQualifiedName(tenant, typeName, qualifiedName, false);
                AtlasRelatedObjectId destinationCluster = (AtlasRelatedObjectId)clusterLinkEntity.getEntity().getRelationshipAttribute("destination_cluster");
                if (destinationCluster == null || destinationCluster.getEntityStatus() != AtlasEntity.Status.ACTIVE) {
                    LOG.error("No active destination cluster for: {} for {}", (Object)typeName, (Object)qualifiedName);
                    throw new RbacException("No active destination cluster for cluster link");
                }
                AtlasEntity.AtlasEntityWithExtInfo destClusterEntity = this.entityStore.getById(destinationCluster.getGuid(), true, true);
                if (destClusterEntity == null || destClusterEntity.getEntity() == null) {
                    throw new RbacException("Null destination cluster entity");
                }
                String clusterId = (String)destClusterEntity.getEntity().getAttribute("id");
                return Collections.singletonList(new SchemaRegistryResource.RbacPermissionAction(clusterId, rbacType, operation));
            }
        }
        LOG.error("Unknown entity type: {} for {}", (Object)typeName, (Object)qualifiedName);
        throw new RbacException("Unknown entity type");
    }

    private List<SchemaRegistryResource.RbacPermissionAction> getSingleEntityPermissionActionWithId(RbacConstants.RbacResourceTypes resourceType, RbacConstants.RbacOperations operation, String tenant, String typeName, String qualifiedName) throws AtlasBaseException {
        AtlasEntity.AtlasEntityWithExtInfo entity = this.getEntityByTypeAndQualifiedName(tenant, typeName, qualifiedName);
        String entityId = (String)entity.getEntity().getAttribute("id");
        return Collections.singletonList(new SchemaRegistryResource.RbacPermissionAction(entityId, resourceType, operation));
    }

    private AtlasEntity.AtlasEntityWithExtInfo getEntityByTypeAndQualifiedName(String tenant, String typeName, String qualifiedName) throws AtlasBaseException {
        return this.getEntityByTypeAndQualifiedName(tenant, typeName, qualifiedName, true);
    }

    private AtlasEntity.AtlasEntityWithExtInfo getEntityByTypeAndQualifiedName(String tenant, String typeName, String qualifiedName, boolean ignoreRelationship) throws AtlasBaseException {
        AtlasEntityType entityType = this.ensureEntityType(typeName);
        String entityQualifiedName = QualifiedNameGenerator.ensureEntityTenantPrefix(tenant, typeName, qualifiedName);
        Map<String, String> attributes = Collections.singletonMap("qualifiedName", entityQualifiedName);
        return this.entityStore.getByUniqueAttributes(entityType, attributes, false, ignoreRelationship);
    }

    private List<SchemaRegistryResource.RbacPermissionAction> getRbacPermissionsUniqueAttributes(ContainerResponseContext responseContext, String tenant) throws Exception {
        if (!(responseContext.getEntity() instanceof AtlasEntity.AtlasEntityWithExtInfo)) {
            return null;
        }
        AtlasEntity.AtlasEntityWithExtInfo response = null;
        if (responseContext.getEntity() == null) {
            return null;
        }
        response = (AtlasEntity.AtlasEntityWithExtInfo)responseContext.getEntity();
        String qualifiedName = (String)response.getEntity().getAttribute("qualifiedName");
        String typeName = response.getEntity().getTypeName();
        return this.getRbacPermissionActionForEntity(typeName, qualifiedName, tenant, RbacConstants.RbacOperations.ReadCatalog, " GET while getting unique attribute RbacPermissionAction");
    }

    private List<SchemaRegistryResource.RbacPermissionAction> getRbacPermissionsTags(ContainerResponseContext responseContext, String tenant) throws Exception {
        LinkedList<SchemaRegistryResource.RbacPermissionAction> actions = new LinkedList<SchemaRegistryResource.RbacPermissionAction>();
        if (!(responseContext.getEntity() instanceof List)) {
            return null;
        }
        List tagResponses = (List)responseContext.getEntity();
        for (TagResponse response : tagResponses) {
            if (response.getTypeName() == null) continue;
            List<SchemaRegistryResource.RbacPermissionAction> permissionActions = this.getRbacPermissionActionForEntity(response.getEntityType(), response.getEntityName(), tenant, RbacConstants.RbacOperations.ReadCatalog, "GET while getting tag entity RbacPermissionAction");
            if (permissionActions != null) {
                actions.addAll(permissionActions);
                continue;
            }
            throw new RbacException("null permission actions");
        }
        return actions;
    }

    private List<SchemaRegistryResource.RbacPermissionAction> getRbacPermissionsBusinessMetaData(ContainerResponseContext responseContext, String tenant) throws Exception {
        LinkedList<SchemaRegistryResource.RbacPermissionAction> actions = new LinkedList<SchemaRegistryResource.RbacPermissionAction>();
        if (!(responseContext.getEntity() instanceof List)) {
            return null;
        }
        List bmResponses = (List)responseContext.getEntity();
        for (BusinessMetadataResponse response : bmResponses) {
            if (response.getTypeName() == null) continue;
            List<SchemaRegistryResource.RbacPermissionAction> permissionActions = this.getRbacPermissionActionForEntity(response.getEntityType(), response.getEntityName(), tenant, RbacConstants.RbacOperations.ReadCatalog, "GET while getting bm entity RbacPermissionAction");
            if (permissionActions != null) {
                actions.addAll(permissionActions);
                continue;
            }
            throw new RbacException("Null permission actions");
        }
        return actions;
    }

    private List<SchemaRegistryResource.RbacPermissionAction> getResourcesForDeleteRequest(ContainerRequestContext requestContext, String tenant) throws Exception {
        String entityName = Servlets.getPathParameter(requestContext.getUriInfo(), "qualifiedName");
        String entityTypeName = Servlets.getPathParameter(requestContext.getUriInfo(), "typeName");
        return this.getRbacPermissionActionForEntity(entityTypeName, entityName, tenant, RbacConstants.RbacOperations.WriteCatalog, "DELETE while getting entity RbacPermissionAction");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<SchemaRegistryResource.RbacPermissionAction> getResourcesForWriteRequest(ContainerRequestContext requestContext, String resourceType, String tenant) throws Exception {
        LinkedList<SchemaRegistryResource.RbacPermissionAction> requests = new LinkedList<SchemaRegistryResource.RbacPermissionAction>();
        String json = IOUtils.toString((InputStream)requestContext.getEntityStream(), (Charset)Charsets.UTF_8);
        if (resourceType.equals(RbacConstants.RbacResourceTypes.CatalogTag.getLabel())) {
            if (requestContext.getUriInfo().getPath().contains(TAG_PATH)) {
                List tags = (List)MAPPER.readValue(json, (TypeReference)new TypeReference<List<Tag>>(){});
                for (Tag tag : tags) {
                    if (tag.getEntityType() == null) continue;
                    List<SchemaRegistryResource.RbacPermissionAction> permissionActions = this.getRbacPermissionActionForEntity(tag.getEntityType(), tag.getEntityName(), tenant, RbacConstants.RbacOperations.WriteCatalog, "write catalog tag entity RbacPermissionAction");
                    if (permissionActions == null) throw new RbacException("no permission actions for tag");
                    requests.addAll(permissionActions);
                }
            } else {
                List schemaMetadataList = (List)MAPPER.readValue(json, (TypeReference)new TypeReference<List<SchemaMetadata>>(){});
                Set<String> subjects = schemaMetadataList.stream().map(SchemaMetadata::getSubject).collect(Collectors.toSet());
                List<SchemaRegistryResource.RbacPermissionAction> permissionActions = this.getRbacPermissionActionForSubjects(subjects, tenant, RbacConstants.RbacOperations.WriteCatalog);
                if (permissionActions.isEmpty()) throw new RbacException("no permission actions for subjects");
                requests.addAll(permissionActions);
            }
        } else if (resourceType.equals(RbacConstants.RbacResourceTypes.CatalogBusinessMetadata.getLabel())) {
            List bms = (List)MAPPER.readValue(json, (TypeReference)new TypeReference<List<BusinessMetadata>>(){});
            for (BusinessMetadata bm : bms) {
                if (bm.getEntityType() == null) continue;
                List<SchemaRegistryResource.RbacPermissionAction> permissionActions = this.getRbacPermissionActionForEntity(bm.getEntityType(), bm.getEntityName(), tenant, RbacConstants.RbacOperations.WriteCatalog, "write catalog business metadata entity RbacPermissionAction");
                if (permissionActions == null) throw new RbacException("no permission actions for business metadata");
                requests.addAll(permissionActions);
            }
        } else if (resourceType.equals(RbacConstants.RbacResourceTypes.CatalogEntity.getLabel())) {
            AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = (AtlasEntity.AtlasEntityWithExtInfo)MAPPER.readValue(json, (TypeReference)new TypeReference<AtlasEntity.AtlasEntityWithExtInfo>(){});
            String qualifiedName = (String)entityWithExtInfo.getEntity().getAttribute("qualifiedName");
            if (entityWithExtInfo.getEntity().getTypeName() != null) {
                List<SchemaRegistryResource.RbacPermissionAction> permissionActions = this.getRbacPermissionActionForEntity(entityWithExtInfo.getEntity().getTypeName(), qualifiedName, tenant, RbacConstants.RbacOperations.WriteCatalog, "write catalog entity RbacPermissionAction");
                if (permissionActions == null) throw new RbacException("no permission actions for entity");
                requests.addAll(permissionActions);
            }
        } else {
            LOG.info("getResourcesForWriteRequest has empty resource request. URI:{}", (Object)requestContext.getUriInfo().getPath());
            InputStream in = IOUtils.toInputStream((String)json, (Charset)StandardCharsets.UTF_8);
            requestContext.setEntityStream(in);
            throw new RbacException("no permission actions for empty resource request");
        }
        InputStream in = IOUtils.toInputStream((String)json, (Charset)StandardCharsets.UTF_8);
        requestContext.setEntityStream(in);
        return requests;
    }

    private List<SchemaRegistryResource.RbacPermissionAction> getSREntityRbacPermissionActions(String entityTypeName, String entityName, String tenant, RbacConstants.RbacOperations operation) throws Exception {
        AtlasEntityType entityType = this.ensureEntityType(entityTypeName);
        String entityQualifiedName = QualifiedNameGenerator.ensureEntityTenantPrefix(tenant, entityTypeName, entityName);
        Map<String, String> attributes = Collections.singletonMap("qualifiedName", entityQualifiedName);
        AtlasEntity.AtlasEntityWithExtInfo entity = this.entityStore.getByUniqueAttributes(entityType, attributes, false, true);
        String context = (String)entity.getEntity().getAttribute("context");
        Set subjects = ((KafkaSchemaRegistry)this.getSchemaRegistry()).listSubjectsForId(((Integer)entity.getEntity().getAttribute("id")).intValue(), context);
        if (subjects == null) {
            LOG.error("EntityResource:getEntityRbacPermissionActions - subjects is null for entity {}", (Object)entityQualifiedName);
            throw new RbacException("subjects is null");
        }
        return this.getRbacPermissionActionForSubjects(subjects, tenant, operation);
    }

    private List<SchemaRegistryResource.RbacPermissionAction> getRbacPermissionActionForSubjects(Set<String> subjects, String tenant, RbacConstants.RbacOperations operation) {
        LinkedList<SchemaRegistryResource.RbacPermissionAction> actions = new LinkedList<SchemaRegistryResource.RbacPermissionAction>();
        for (String tenantSubject : subjects) {
            String subject = CatalogTenantUtils.subjectFor(tenant, tenantSubject);
            actions.add(new SchemaRegistryResource.RbacPermissionAction(subject, RbacConstants.RbacResourceTypes.CatalogSubject, operation));
        }
        return actions;
    }
}

