/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.catalog.web.util;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.apache.atlas.AtlasConfiguration;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.utils.ParamChecker;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriUtils;

public final class Servlets {
    private static final Logger LOG = LoggerFactory.getLogger(Servlets.class);
    public static final String JSON_MEDIA_TYPE = "application/json; charset=UTF-8";
    public static final String BINARY = "application/octet-stream";
    private static final int QUERY_PARAM_MAX_LENGTH = AtlasConfiguration.QUERY_PARAM_MAX_LENGTH.getInt();
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private static final String DO_AS = "doAs";

    private Servlets() {
    }

    public static String getUserFromRequest(HttpServletRequest httpRequest) {
        String user = httpRequest.getRemoteUser();
        if (!StringUtils.isEmpty((CharSequence)user)) {
            return user;
        }
        user = httpRequest.getParameter("user.name");
        if (!StringUtils.isEmpty((CharSequence)user)) {
            return user;
        }
        user = httpRequest.getHeader("Remote-User");
        if (!StringUtils.isEmpty((CharSequence)user)) {
            return user;
        }
        user = Servlets.getDoAsUser(httpRequest);
        if (!StringUtils.isEmpty((CharSequence)user)) {
            return user;
        }
        return null;
    }

    public static String getDoAsUser(HttpServletRequest request) {
        List list;
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{request.getQueryString()}) && (list = URLEncodedUtils.parse((String)request.getQueryString(), (Charset)UTF8_CHARSET)) != null) {
            for (NameValuePair nv : list) {
                if (!DO_AS.equals(nv.getName())) continue;
                return nv.getValue();
            }
        }
        return null;
    }

    public static String getRequestURI(HttpServletRequest httpRequest) {
        StringBuilder url = new StringBuilder(100).append(httpRequest.getRequestURI());
        if (httpRequest.getQueryString() != null) {
            url.append('?').append(httpRequest.getQueryString());
        }
        return url.toString();
    }

    public static String getRequestURL(HttpServletRequest httpRequest) {
        StringBuilder url = new StringBuilder(100).append(httpRequest.getRequestURL());
        if (httpRequest.getQueryString() != null) {
            url.append('?').append(httpRequest.getQueryString());
        }
        return url.toString();
    }

    public static String getRequestId() {
        return Thread.currentThread().getName();
    }

    public static String escapeJsonString(String inputStr) {
        ParamChecker.notNull((Object)inputStr, (String)"Input String cannot be null");
        return StringEscapeUtils.escapeJson((String)inputStr);
    }

    public static String getHostName(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getLocalName();
    }

    public static String getUserName(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getRemoteUser();
    }

    public static Map<String, Object> getParameterMap(HttpServletRequest request) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (MapUtils.isNotEmpty((Map)request.getParameterMap())) {
            for (Map.Entry e : request.getParameterMap().entrySet()) {
                String key = (String)e.getKey();
                if (key == null) continue;
                String[] values = (String[])e.getValue();
                String value = values != null && values.length > 0 ? values[0] : null;
                attributes.put(key, value);
            }
        }
        return attributes;
    }

    public static void validateQueryParamLength(String paramName, String paramValue) throws AtlasBaseException {
        if (StringUtils.isNotEmpty((CharSequence)paramValue) && paramValue.length() > QUERY_PARAM_MAX_LENGTH) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_QUERY_PARAM_LENGTH, new String[]{paramName});
        }
    }

    public static String decodeQueryString(String query) {
        return UriUtils.decode((String)query, (String)"UTF-8");
    }

    public static String getPathParameter(UriInfo uri, String parameter) {
        MultivaluedMap map = uri.getPathParameters();
        for (String k : map.keySet()) {
            if (!k.equalsIgnoreCase(parameter)) continue;
            return (String)map.getFirst((Object)k);
        }
        return null;
    }
}

